/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.runtime;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.ActivityDefnVO;
import com.webmcq.ld.activities.LDActItem;
import com.webmcq.ld.activities.LdItem;
import com.webmcq.ld.activities.LearningDesignDefnVO;
import com.webmcq.ld.activities.MultiTaskVO;
import com.webmcq.ld.activities.OptionalActivityDefnVO;
import com.webmcq.ld.activities.OptionalActivityDummyTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.activities.TransitionDefnVO;
import com.webmcq.ld.activities.dao.ActivityDefnDAO;
import com.webmcq.ld.activities.dao.LearningDesignDefnDAO;
import com.webmcq.ld.activities.dao.MultiTaskDAO;
import com.webmcq.ld.activities.dao.OptionalActivityDefnDAO;
import com.webmcq.ld.activities.dao.SimpleTaskDefnDAO;
import com.webmcq.ld.activities.runtime.LDRuntimeServiceException;
import com.webmcq.ld.activities.runtime.LearningDesignRuntime;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.ParsingUtil;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.ObjectNotFoundException;
import org.apache.log4j.Logger;

public abstract class LDRuntimeServiceBean
extends BaseSessionBean {
    public static String JNDI_NAME = "ejb/activities/LDRuntimeService";
    public static String LOCAL_NAME = "activities/LDRuntimeService";
    private static Logger logger = Logger.getLogger((String)(class$com$webmcq$ld$activities$runtime$LDRuntimeServiceBean == null ? (class$com$webmcq$ld$activities$runtime$LDRuntimeServiceBean = LDRuntimeServiceBean.class$("com.webmcq.ld.activities.runtime.LDRuntimeServiceBean")) : class$com$webmcq$ld$activities$runtime$LDRuntimeServiceBean).getName());
    static /* synthetic */ Class class$com$webmcq$ld$activities$runtime$LDRuntimeServiceBean;
    static /* synthetic */ Class class$com$webmcq$ld$activities$AbstractTaskVO;
    static /* synthetic */ Class class$com$webmcq$ld$activities$TransitionDefnVO;
    static /* synthetic */ Class class$com$webmcq$ld$activities$OptionalActivityDummyTaskVO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getFirstTask(int learningDesignSid) throws LDRuntimeServiceException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            Vector vector = this.getFirstTask(sess, learningDesignSid);
            return vector;
        }
        finally {
            sess.close();
        }
    }

    public Vector getFirstTask(PersistenceSession sess, int learningDesignSid) throws LDRuntimeServiceException {
        AbstractTaskVO task = null;
        LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
        LearningDesignDefnVO ld = ldDao.find(learningDesignSid);
        Integer firstActivityId = ld.getFirstActivityId();
        if (firstActivityId == null) {
            firstActivityId = ld.calculateFirstActivity();
        }
        if (firstActivityId == null) {
            throw new LDRuntimeServiceException("Internal error - can't work out first activity in learning design. Design was " + ld.toString());
        }
        task = this.getNextTaskFromActivityOptActivity(ld, firstActivityId);
        Vector<AbstractTaskVO> firstTasks = new Vector<AbstractTaskVO>(1);
        if (task != null) {
            firstTasks.add(task);
        }
        sess.flush();
        return firstTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDActItem getFirstActivity(int learningDesignSid) throws LDRuntimeServiceException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
            LearningDesignDefnVO ld = ldDao.find(learningDesignSid);
            Integer firstActivityId = ld.getFirstActivityId();
            LDActItem act = null;
            if (firstActivityId != null && (act = ld.selectActivity(firstActivityId)) == null) {
                act = ld.selectOptionalActivity(firstActivityId);
            }
            sess.flush();
            ActivityDefnVO activityDefnVO = act;
            return activityDefnVO;
        }
        finally {
            sess.close();
        }
    }

    protected AbstractTaskVO findTask(PersistenceSession session, Long currTaskSid) throws LDRuntimeServiceException {
        AbstractTaskVO task;
        block9: {
            if (currTaskSid == null) {
                throw new LDRuntimeServiceException("Cannot find task as sid supplied is null");
            }
            task = null;
            try {
                try {
                    task = (AbstractTaskVO)session.persistece().load(class$com$webmcq$ld$activities$AbstractTaskVO == null ? (class$com$webmcq$ld$activities$AbstractTaskVO = LDRuntimeServiceBean.class$("com.webmcq.ld.activities.AbstractTaskVO")) : class$com$webmcq$ld$activities$AbstractTaskVO, (Serializable)currTaskSid);
                }
                catch (ObjectNotFoundException e) {
                    // empty catch block
                }
                if (task != null) break block9;
                try {
                    task = (TransitionDefnVO)session.persistece().load(class$com$webmcq$ld$activities$TransitionDefnVO == null ? (class$com$webmcq$ld$activities$TransitionDefnVO = LDRuntimeServiceBean.class$("com.webmcq.ld.activities.TransitionDefnVO")) : class$com$webmcq$ld$activities$TransitionDefnVO, (Serializable)currTaskSid);
                }
                catch (ObjectNotFoundException e) {
                    // empty catch block
                }
                if (task != null) break block9;
                try {
                    task = (OptionalActivityDummyTaskVO)session.persistece().load(class$com$webmcq$ld$activities$OptionalActivityDummyTaskVO == null ? (class$com$webmcq$ld$activities$OptionalActivityDummyTaskVO = LDRuntimeServiceBean.class$("com.webmcq.ld.activities.OptionalActivityDummyTaskVO")) : class$com$webmcq$ld$activities$OptionalActivityDummyTaskVO, (Serializable)currTaskSid);
                }
                catch (ObjectNotFoundException e) {
                    throw new LDRuntimeServiceException("Cannot find task/transition. Both task and transition tables checked. Task sid is " + currTaskSid);
                }
            }
            catch (HibernateException e) {
                logger.error((Object)("Hibernate threw exception while loading task sid=" + currTaskSid), (Throwable)e);
                throw new LDRuntimeServiceException("Cannot find task as database access error occured " + e.getMessage());
            }
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getNextTask(int learningDesignSid, AbstractTaskVO task) throws LDRuntimeServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for next task after the task " + (task != null ? task.toString() : " no current task ") + "in learning design sid=" + learningDesignSid));
        }
        PersistenceSession sess = null;
        try {
            AbstractTaskVO currTask;
            sess = new PersistenceSession();
            if (task == null) {
                Vector tasks = this.getFirstTask(sess, learningDesignSid);
                sess.flush();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found first task:" + (tasks != null ? tasks.toString() : " no tasks found ")));
                }
                Vector vector = tasks;
                return vector;
            }
            if (task.theTaskType() == 2) {
                Vector subTasks = this.getSubTasks((MultiTaskVO)task);
                sess.flush();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found subtasks:" + (subTasks != null ? subTasks.toString() : " no tasks found ")));
                }
                Vector vector = subTasks;
                return vector;
            }
            if (task.theTaskType() == 5) {
                OptionalActivityDummyTaskVO dummyTask = (OptionalActivityDummyTaskVO)task;
                Vector subTasks = new Vector(dummyTask.getSubFirstTasks());
                sess.flush();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found subtasks:" + (subTasks != null ? subTasks.toString() : " no tasks found ")));
                }
                Vector vector = subTasks;
                return vector;
            }
            LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
            LearningDesignDefnVO ld = ldDao.find(learningDesignSid);
            if (task.theTaskType() == 3) {
                Vector nextTasks = null;
                try {
                    nextTasks = this.getTasksAfterTransition(sess, ld, (TransitionDefnVO)task);
                }
                catch (Exception e) {
                    sess.flush();
                    logger.error((Object)("Error finding task after the controller has passed us back a transition" + task.getSid()), (Throwable)e);
                    throw new LDRuntimeServiceException("Error finding next task based on current task " + task.toString() + " " + e.getMessage());
                }
                sess.flush();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found next tasks:" + (nextTasks != null ? nextTasks.toString() : " no tasks found ")));
                }
                Vector e = nextTasks;
                return e;
            }
            try {
                currTask = this.findTask(sess, task.getSid());
            }
            catch (Exception e) {
                sess.flush();
                logger.error((Object)("Error finding task " + task.getSid()), (Throwable)e);
                throw new LDRuntimeServiceException("Error finding task " + task.getSid() + " " + e.getMessage());
            }
            Hashtable nextTaskList = this.getNextTaskTransitionUsingTransitions(sess, ld, currTask);
            if (nextTaskList == null) {
                sess.flush();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Found next tasks via transitions: none found");
                }
                Vector vector = new Vector(0);
                return vector;
            }
            int numTasks = nextTaskList.size();
            Vector nextTasks = new Vector(numTasks);
            Enumeration enumTasks = nextTaskList.elements();
            while (enumTasks.hasMoreElements()) {
                nextTasks.add(enumTasks.nextElement());
            }
            sess.flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found next tasks via transitions: " + (nextTasks != null ? nextTasks.toString() : " no tasks found ")));
            }
            Vector vector = nextTasks;
            return vector;
        }
        finally {
            sess.close();
        }
    }

    public Vector getNextTask(int learningDesignSid, AbstractTaskVO task, PersistenceSession sess) throws LDRuntimeServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for next task after the task " + (task != null ? task.toString() : " no current task ") + "in learning design sid=" + learningDesignSid));
        }
        if (task == null) {
            Vector tasks = this.getFirstTask(sess, learningDesignSid);
            sess.flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found first task:" + (tasks != null ? tasks.toString() : " no tasks found ")));
            }
            return tasks;
        }
        if (task.theTaskType() == 2) {
            Vector subTasks = this.getSubTasks((MultiTaskVO)task);
            sess.flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found subtasks:" + (subTasks != null ? subTasks.toString() : " no tasks found ")));
            }
            return subTasks;
        }
        if (task.theTaskType() == 5) {
            OptionalActivityDummyTaskVO dummyTask = (OptionalActivityDummyTaskVO)task;
            Vector subTasks = new Vector(dummyTask.getSubFirstTasks());
            sess.flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found subtasks:" + (subTasks != null ? subTasks.toString() : " no tasks found ")));
            }
            return subTasks;
        }
        LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
        LearningDesignDefnVO ld = ldDao.find(learningDesignSid);
        if (task.theTaskType() == 3) {
            Vector nextTasks = null;
            try {
                nextTasks = this.getTasksAfterTransition(sess, ld, (TransitionDefnVO)task);
            }
            catch (Exception e) {
                sess.flush();
                logger.error((Object)("Error finding task after the controller has passed us back a transition" + task.getSid()), (Throwable)e);
                throw new LDRuntimeServiceException("Error finding next task based on current task " + task.toString() + " " + e.getMessage());
            }
            sess.flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found next tasks:" + (nextTasks != null ? nextTasks.toString() : " no tasks found ")));
            }
            return nextTasks;
        }
        Hashtable nextTaskList = this.getNextTaskTransitionUsingTransitions(sess, ld, task);
        if (nextTaskList == null) {
            sess.flush();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Found next tasks via transitions: none found");
            }
            return new Vector(0);
        }
        int numTasks = nextTaskList.size();
        Vector nextTasks = new Vector(numTasks);
        Enumeration enumTasks = nextTaskList.elements();
        while (enumTasks.hasMoreElements()) {
            nextTasks.add(enumTasks.nextElement());
        }
        sess.flush();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found next tasks via transitions: " + (nextTasks != null ? nextTasks.toString() : " no tasks found ")));
        }
        return nextTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getNextTaskAfterInternals(int learningDesignSid, AbstractTaskVO task) throws LDRuntimeServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for next task after internal tasks. Learning Design Sid=" + learningDesignSid + " current task " + (task != null ? task.toString() : " no current task ")));
        }
        if (task.theTaskType() == 5) {
            PersistenceSession sess = null;
            try {
                sess = new PersistenceSession();
                logger.debug((Object)"Trying to get activity _after_ the optional activity");
                Vector nextTasks = new Vector();
                LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
                LearningDesignDefnVO ld = ldDao.find(learningDesignSid);
                OptionalActivityDummyTaskVO dummyTask = (OptionalActivityDummyTaskVO)task;
                OptionalActivityDefnVO optAct = dummyTask.getOptionalActivity();
                if (optAct == null) {
                    throw new LDRuntimeServiceException("Error finding optional activity related to dummy task " + (dummyTask != null ? dummyTask.toString() : "null"));
                }
                Hashtable tasks = this.getSubsequentActivityTasksWithinLD(null, ld, optAct);
                if (tasks != null) {
                    Enumeration enumTasks = tasks.elements();
                    while (enumTasks.hasMoreElements()) {
                        nextTasks.add(enumTasks.nextElement());
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found tasks:" + (nextTasks != null ? nextTasks.toString() : " no tasks found ")));
                }
                sess.flush();
                Vector vector = nextTasks;
                return vector;
            }
            finally {
                sess.close();
            }
        }
        logger.warn((Object)("getNextTaskAfterInternals() called with task " + (task != null ? task.toString() : "null") + ". Should only be called with a optional activity dummy task. " + " Returning results of getNextTask()."));
        return this.getNextTask(learningDesignSid, task);
    }

    public Vector getNextTaskAfterInternals(int learningDesignSid, AbstractTaskVO task, PersistenceSession sess) throws LDRuntimeServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for next task after internal tasks. Learning Design Sid=" + learningDesignSid + " current task " + (task != null ? task.toString() : " no current task ")));
        }
        if (task.theTaskType() == 5) {
            logger.debug((Object)"Trying to get activity _after_ the optional activity");
            Vector nextTasks = new Vector();
            LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
            LearningDesignDefnVO ld = ldDao.find(learningDesignSid);
            OptionalActivityDummyTaskVO dummyTask = (OptionalActivityDummyTaskVO)task;
            OptionalActivityDefnVO optAct = dummyTask.getOptionalActivity();
            if (optAct == null) {
                throw new LDRuntimeServiceException("Error finding optional activity related to dummy task " + (dummyTask != null ? dummyTask.toString() : "null"));
            }
            Hashtable tasks = this.getSubsequentActivityTasksWithinLD(null, ld, optAct);
            if (tasks != null) {
                Enumeration enumTasks = tasks.elements();
                while (enumTasks.hasMoreElements()) {
                    nextTasks.add(enumTasks.nextElement());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found tasks:" + (nextTasks != null ? nextTasks.toString() : " no tasks found ")));
            }
            sess.flush();
            return nextTasks;
        }
        logger.warn((Object)("getNextTaskAfterInternals() called with task " + (task != null ? task.toString() : "null") + ". Should only be called with a optional activity dummy task. " + " Returning results of getNextTask()."));
        return this.getNextTask(learningDesignSid, task);
    }

    protected Vector getSubTasks(MultiTaskVO task) throws LDRuntimeServiceException {
        Vector<AbstractTaskVO> returnValue = new Vector<AbstractTaskVO>();
        String order = task.getTaskOrderOnScreen();
        if (order == null) {
            Set subTasks = task.getSubTasks();
            if (subTasks.size() > 0) {
                logger.error((Object)("Subtasks exist but order is unknown. Using random order. Multitask is " + task.toString()));
                returnValue.addAll(subTasks);
            }
            return returnValue;
        }
        Vector orderVector = ParsingUtil.parseStringToInts(order);
        Iterator iter = orderVector.iterator();
        while (iter.hasNext()) {
            Integer id = (Integer)iter.next();
            AbstractTaskVO subTask = task.selectTaskById(id);
            if (subTask == null) {
                throw new LDRuntimeServiceException("Task referred to in subtask order doesn't exist in subtasks set. Multitask is " + task.toString());
            }
            returnValue.add(subTask);
        }
        return returnValue;
    }

    protected Hashtable getNextTaskTransitionUsingTransitions(PersistenceSession session, LearningDesignDefnVO ld, AbstractTaskVO task) throws LDRuntimeServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("In getNextTaskTransitionUsingTransitions with ld = " + ld + " current task" + task.toString()));
        }
        Hashtable subsequent = new Hashtable();
        try {
            LdItem taskLocation = this.getLdItemContainingTask(session, task);
            if (taskLocation == null) {
                logger.debug((Object)("Unable to find home for the task " + task.toString() + " within learning design " + ld.toString() + " hence won't be able to find next task. Tried within activities directly" + " and with multitasks within activities"));
                throw new Exception("Unable to find home for the task " + task.getSid() + " within learning design " + ld.getSid() + "So can't find next task.");
            }
            try {
                ActivityDefnVO activity = (ActivityDefnVO)taskLocation;
                logger.debug((Object)"Found task within activity");
                subsequent = this.getSubsequentTasksTransitionsWithinActivity(subsequent, activity, new Integer(task.getId()));
                if (subsequent.size() == 0) {
                    this.getSubsequentActivityTasksWithinLD(session, subsequent, ld, activity);
                }
            }
            catch (ClassCastException cce) {
                try {
                    MultiTaskVO multiTask = (MultiTaskVO)taskLocation;
                    logger.debug((Object)"Found task within multitask");
                    return this.getNextTaskTransitionUsingTransitions(session, ld, multiTask);
                }
                catch (ClassCastException cce2) {
                    logger.debug((Object)("Found home for the task " + task.toString() + " but don't understand type - expecting ActivityDefnVO or MultiTaskVO got " + taskLocation.getClass().getName()));
                    throw new Exception("Unable to interpret the home for the task " + task.getSid() + " within learning design " + ld.getSid() + " Class type " + taskLocation.getClass().getName() + "not expected.");
                }
            }
        }
        catch (Exception e) {
            String message = "Unable to find next activity/task due to an internal error";
            logger.error((Object)("Looking for next task from learning design " + ld.getSid() + " current task " + task.toString() + message), (Throwable)e);
            throw new LDRuntimeServiceException(message + " " + e.getMessage());
        }
        if (subsequent.size() > 0) {
            return subsequent;
        }
        return null;
    }

    protected LdItem getLdItemContainingTask(PersistenceSession session, AbstractTaskVO taskToFind) {
        ActivityDefnDAO actDAO;
        ActivityDefnVO activity;
        if (taskToFind == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to find activity or multitask containing task " + taskToFind.getSid()));
        }
        if ((activity = (actDAO = new ActivityDefnDAO(session)).findContainsTaskDirectly(taskToFind.getSid())) != null) {
            return activity;
        }
        MultiTaskDAO mtDAO = new MultiTaskDAO(session);
        MultiTaskVO multitask = mtDAO.findContainsTask(taskToFind.getSid());
        if (multitask != null) {
            return multitask;
        }
        OptionalActivityDefnDAO optDAO = new OptionalActivityDefnDAO(session);
        OptionalActivityDefnVO optional = optDAO.findContainsTaskDirectly(taskToFind.getSid());
        if (optional != null) {
            return optional;
        }
        return null;
    }

    private boolean isSyncTransition(TransitionDefnVO tran) {
        return "synchronize".equals(tran.getCompletion()) || "synchronize_teacher".equals(tran.getCompletion()) || "synchronize_both".equals(tran.getCompletion());
    }

    protected Hashtable getSubsequentTasksTransitionsWithinActivity(Hashtable subsequentTasks, ActivityDefnVO activity, Integer currentTaskId) throws LDRuntimeServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("In getSubsequentTasksTransitionsWithinActivity with activity = " + activity.toString() + " current task id " + currentTaskId));
        }
        Hashtable results = subsequentTasks != null ? subsequentTasks : new Hashtable();
        Set transitions = activity.calculateSubsequentTransitionsTasks(currentTaskId);
        Iterator iter = transitions.iterator();
        while (iter.hasNext()) {
            TransitionDefnVO tran = (TransitionDefnVO)iter.next();
            logger.debug((Object)("Checking transition " + tran.toString()));
            if (this.isSyncTransition(tran)) {
                logger.debug((Object)"Using transition ");
                results.put(new Integer(tran.getId()), tran);
                continue;
            }
            logger.debug((Object)"Getting next task");
            Integer nextTaskId = new Integer(tran.getToTaskActivityId());
            this.addTaskToSubsequentById(results, activity, nextTaskId);
        }
        return results;
    }

    protected void addTaskToSubsequentById(Hashtable subsequentTasks, ActivityDefnVO activity, Integer taskId) throws LDRuntimeServiceException {
        AbstractTaskVO task = activity.selectTaskById(taskId);
        if (task != null) {
            subsequentTasks.put(new Integer(task.getId()), task);
        }
    }

    protected Hashtable getSubsequentActivityTasksWithinLD(PersistenceSession session, Hashtable subsequentTT, LearningDesignDefnVO ld, ActivityDefnVO currentActivity) {
        OptionalActivityDefnDAO optActDao;
        OptionalActivityDefnVO optAct;
        int currentActivityId = currentActivity.getId();
        Set transitions = ld.getTransitions();
        Hashtable results = subsequentTT != null ? subsequentTT : new Hashtable();
        boolean foundSuitableTransition = false;
        if (transitions != null && transitions.size() > 0) {
            Iterator iter = transitions.iterator();
            while (iter.hasNext()) {
                TransitionDefnVO transition = (TransitionDefnVO)iter.next();
                logger.debug((Object)("getSubsequentActivityTasksWithinLD: Checking transition " + transition.toString()));
                int fromId = transition.getFromTaskActivityId();
                if (fromId != currentActivityId) continue;
                foundSuitableTransition = true;
                if (this.isSyncTransition(transition)) {
                    logger.debug((Object)"Using transiation");
                    results.put(new Integer(transition.getId()), transition);
                    continue;
                }
                logger.debug((Object)"USing next task");
                int toId = transition.getToTaskActivityId();
                AbstractTaskVO nextTask = this.getNextTaskFromActivityOptActivity(ld, new Integer(toId));
                if (nextTask == null) continue;
                results.put(new Integer(nextTask.getId()), nextTask);
            }
        }
        if (!foundSuitableTransition && (optAct = (optActDao = new OptionalActivityDefnDAO(session)).findContainsActivity(currentActivity.getSid())) != null) {
            results.put(new Integer(optAct.getDummyTask().getId()), optAct.getDummyTask());
        }
        return results;
    }

    protected Hashtable getSubsequentActivityTasksWithinLD(Hashtable subsequentTT, LearningDesignDefnVO ld, OptionalActivityDefnVO currentOptAct) {
        Hashtable results;
        int currentId = currentOptAct.getId();
        Set transitions = ld.getTransitions();
        Hashtable hashtable = results = subsequentTT != null ? subsequentTT : new Hashtable();
        if (transitions != null && transitions.size() > 0) {
            Iterator iter = transitions.iterator();
            while (iter.hasNext()) {
                TransitionDefnVO transition = (TransitionDefnVO)iter.next();
                int fromId = transition.getFromTaskActivityId();
                if (fromId != currentId) continue;
                if (this.isSyncTransition(transition)) {
                    results.put(new Integer(transition.getId()), transition);
                    continue;
                }
                int toId = transition.getToTaskActivityId();
                AbstractTaskVO nextTask = this.getNextTaskFromActivityOptActivity(ld, new Integer(toId));
                if (nextTask == null) continue;
                results.put(new Integer(nextTask.getId()), nextTask);
            }
        }
        return results;
    }

    protected AbstractTaskVO getNextTaskFromActivityOptActivity(LearningDesignDefnVO ld, Integer toId) {
        AbstractTaskVO nextTask = null;
        if (toId != null) {
            ActivityDefnVO nextActivity = ld.selectActivity(toId);
            if (nextActivity != null) {
                nextTask = nextActivity.getFirstTask();
            } else {
                OptionalActivityDefnVO nextOptionalActivity = ld.selectOptionalActivity(toId);
                if (nextOptionalActivity != null) {
                    nextTask = nextOptionalActivity.getDummyTask();
                }
            }
        }
        return nextTask;
    }

    protected Vector getTasksAfterTransition(PersistenceSession session, LearningDesignDefnVO ld, TransitionDefnVO transition) throws Exception {
        Vector<AbstractTaskVO> results = new Vector<AbstractTaskVO>();
        int id = transition.getToTaskActivityId();
        ActivityDefnDAO actDAO = new ActivityDefnDAO(session);
        ActivityDefnVO activity = actDAO.findContainsTransition(transition.getSid());
        if (activity != null) {
            AbstractTaskVO task = activity.selectTaskById(id);
            if (task == null) {
                logger.error((Object)("Unable to find task " + id + " in activity " + activity.toString()));
                throw new Exception("Unable to find task " + id + " in activity " + activity.toString());
            }
            results.add(task);
        } else {
            ActivityDefnVO nextActivity = ld.selectActivity(id);
            if (nextActivity != null) {
                results.add(nextActivity.getFirstTask());
            } else {
                OptionalActivityDefnVO optAct = ld.selectOptionalActivity(id);
                if (optAct != null) {
                    results.add(optAct.getDummyTask());
                } else {
                    logger.error((Object)("Unable to find next activity " + id + " in learning design " + ld.toString()));
                    throw new Exception("Unable to find next activity " + id + " in learning design " + ld.toString());
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLearningDesignAsUsed(Long ldSid) throws LDRuntimeServiceException {
        if (ldSid == null) {
            return;
        }
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
            LearningDesignDefnVO ld = ldDao.find(ldSid);
            if (ld == null) {
                logger.error((Object)("Received notification that learning design # " + ldSid + " is in use but this learning design cannot be found."));
                throw new LDRuntimeServiceException("Unable to mark learning design # " + ldSid + " as in use - learning design cannot be found");
            }
            logger.info((Object)("Setting learning design # " + ldSid + " to read only"));
            ld.setReadOnly();
            sess.flush();
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDActItem getActivityContainingTask(AbstractTaskVO taskToFind) throws LDRuntimeServiceException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            try {
                TransitionDefnVO transition = (TransitionDefnVO)taskToFind;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getActivityContainingTask: looking for transition " + transition.toString()));
                }
                ActivityDefnDAO actDAO = new ActivityDefnDAO(sess);
                ActivityDefnVO activity = actDAO.findContainsTransition(transition.getSid());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getActivityContainingTask: returning " + (activity != null ? activity.toString() : "null")));
                }
                sess.flush();
                ActivityDefnVO activityDefnVO = activity;
                return activityDefnVO;
            }
            catch (ClassCastException e) {
                block13: {
                    LdItem owner;
                    block12: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("getActivityContainingTask: looking for task" + taskToFind.getSid()));
                        }
                        if ((owner = this.getLdItemContainingTask(sess, taskToFind)).theObjectType().equals("optionalactivity")) break block12;
                        while (owner != null && !owner.theObjectType().equals("Activity") && !owner.theObjectType().equals("LearningDesign")) {
                            owner = this.getLdItemContainingTask(sess, (AbstractTaskVO)owner);
                        }
                        if (owner == null || !owner.theObjectType().equals("Activity")) break block13;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("getActivityContainingTask: returning " + (owner != null ? owner.toString() : "null")));
                        }
                        sess.flush();
                        LDActItem lDActItem = (LDActItem)owner;
                        sess.close();
                        return lDActItem;
                    }
                    sess.flush();
                    LDActItem lDActItem = (LDActItem)owner;
                    sess.close();
                    return lDActItem;
                }
                sess.close();
            }
        }
        finally {
            sess.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAllActs(long ldSid) throws LDRuntimeServiceException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            ArrayList<LDActItem> future = new ArrayList<LDActItem>();
            logger.debug((Object)("getAllActs: Working out activities for learning design sid=" + ldSid));
            LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
            LearningDesignDefnVO design = ldDao.find(ldSid);
            if (design == null) {
                logger.error((Object)("getAllActs: Unable to find future activities as cannot find the learning design sid=" + ldSid));
                sess.flush();
                throw new LDRuntimeServiceException("Unable to find learning design sid=" + ldSid);
            }
            HashMap activityMap = this.buildActivityHashMap(design);
            Integer firstActivityId = design.getFirstActivityId();
            if (firstActivityId == null) {
                sess.flush();
                throw new LDRuntimeServiceException("Internal error - can't work out first activity in learning design. Design was " + design.toString());
            }
            ActivityDefnVO activity = design.selectActivity(firstActivityId);
            if (activity != null) {
                future.add(activity);
                this.processActivity(activity, activityMap, design, future);
            } else {
                OptionalActivityDefnVO optionalActivity = design.selectOptionalActivity(firstActivityId);
                if (optionalActivity != null) {
                    future.add(optionalActivity);
                    this.processActivity(optionalActivity, activityMap, design, future);
                } else {
                    logger.error((Object)("getAllActs: Unable to find activity or optional activity sid=" + firstActivityId + " learning design is " + design.toString()));
                    sess.flush();
                    throw new LDRuntimeServiceException("Unable to find activity " + firstActivityId);
                }
            }
            sess.flush();
            ArrayList<LDActItem> arrayList = future;
            return arrayList;
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getFutureActs(long currentActivitySid) throws LDRuntimeServiceException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            ArrayList future = new ArrayList();
            logger.debug((Object)("getFutureActs: Working out activities after sid=" + currentActivitySid));
            LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
            LearningDesignDefnVO design = ldDao.findContainsActivity(currentActivitySid);
            if (design == null && (design = ldDao.findContainsOptionalActivity(currentActivitySid)) == null) {
                logger.error((Object)("getFutureActs: Unable to find future activities as cannot find the learning design containing activity sid=" + currentActivitySid));
                sess.flush();
                throw new LDRuntimeServiceException("Unable to find learning design for activity sid" + currentActivitySid);
            }
            HashMap activityMap = this.buildActivityHashMap(design);
            ActivityDefnDAO actDAO = new ActivityDefnDAO(sess);
            ActivityDefnVO currentActivity = actDAO.find(currentActivitySid);
            if (currentActivity != null) {
                OptionalActivityDefnVO optAct = this.processActWithinOptAct(sess, currentActivity, design, future);
                if (optAct != null) {
                    this.processActivity(optAct, activityMap, design, future);
                } else {
                    this.processActivity(currentActivity, activityMap, design, future);
                }
            } else {
                OptionalActivityDefnDAO optActDao = new OptionalActivityDefnDAO(sess);
                OptionalActivityDefnVO currentOptionalActivity = optActDao.find(currentActivitySid);
                if (currentOptionalActivity != null) {
                    this.processActivity(currentOptionalActivity, activityMap, design, future);
                } else {
                    logger.error((Object)("getFutureActs: Unable to find activity or optional activity sid=" + currentActivitySid + " learning design is " + design.toString()));
                    sess.flush();
                    throw new LDRuntimeServiceException("Unable to find activity " + currentActivitySid);
                }
            }
            sess.flush();
            ArrayList arrayList = future;
            return arrayList;
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getFutureActs(long ldId, long currentActivitySid) throws LDRuntimeServiceException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            ArrayList future = new ArrayList();
            logger.debug((Object)("getFutureActs: Working out activities after sid=" + currentActivitySid));
            LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
            LearningDesignDefnVO design = ldDao.find(ldId);
            if (design == null) {
                logger.error((Object)("getFutureActs: Unable to find future activities as cannot find the learning design containing activity sid=" + currentActivitySid));
                throw new LDRuntimeServiceException("Unable to find learning design for activity sid" + currentActivitySid);
            }
            HashMap activityMap = this.buildActivityHashMap(design);
            ActivityDefnDAO actDAO = new ActivityDefnDAO(sess);
            ActivityDefnVO currentActivity = actDAO.find(currentActivitySid);
            if (currentActivity != null) {
                OptionalActivityDefnVO optAct = this.processActWithinOptAct(sess, currentActivity, design, future);
                if (optAct != null) {
                    this.processActivity(optAct, activityMap, design, future);
                } else {
                    this.processActivity(currentActivity, activityMap, design, future);
                }
            } else {
                OptionalActivityDefnDAO optActDao = new OptionalActivityDefnDAO(sess);
                OptionalActivityDefnVO currentOptionalActivity = optActDao.find(currentActivitySid);
                if (currentOptionalActivity != null) {
                    this.processActivity(currentOptionalActivity, activityMap, design, future);
                } else {
                    logger.error((Object)("getFutureActs: Unable to find activity or optional activity sid=" + currentActivitySid + " learning design is " + design.toString()));
                    sess.flush();
                    throw new LDRuntimeServiceException("Unable to find activity " + currentActivitySid);
                }
            }
            sess.flush();
            ArrayList arrayList = future;
            return arrayList;
        }
        finally {
            sess.close();
        }
    }

    private void processActivity(LdItem currentItem, Map activityMap, LearningDesignDefnVO design, ArrayList future) throws LDRuntimeServiceException {
        ArrayList nextIds = (ArrayList)activityMap.get(new Integer(currentItem.getId()));
        if (nextIds != null) {
            Iterator idIterator = nextIds.iterator();
            while (idIterator.hasNext()) {
                Integer nextId = (Integer)idIterator.next();
                ActivityDefnVO activity = design.selectActivity(nextId);
                if (activity != null) {
                    future.add(activity);
                    this.processActivity(activity, activityMap, design, future);
                    continue;
                }
                OptionalActivityDefnVO optionalActivity = design.selectOptionalActivity(nextId);
                if (optionalActivity != null) {
                    future.add(optionalActivity);
                    this.processActivity(optionalActivity, activityMap, design, future);
                    continue;
                }
                logger.error((Object)("getFutureActs: Unable to find activity with id " + nextId + " learning design is " + design.toString()));
                throw new LDRuntimeServiceException("Unable to find activity with id " + nextId);
            }
        }
    }

    private OptionalActivityDefnVO processActWithinOptAct(PersistenceSession session, ActivityDefnVO currentActivity, LearningDesignDefnVO design, ArrayList future) throws LDRuntimeServiceException {
        Set acts;
        logger.debug((Object)("processActWithinOptAct: Processing item" + currentActivity.toString()));
        OptionalActivityDefnDAO optActDao = new OptionalActivityDefnDAO(session);
        OptionalActivityDefnVO optAct = optActDao.findContainsActivity(currentActivity.getSid());
        if (optAct != null && (acts = optAct.getActivities()) != null) {
            Iterator iter = acts.iterator();
            while (iter.hasNext()) {
                ActivityDefnVO otherActivity = (ActivityDefnVO)iter.next();
                if (otherActivity.equals(currentActivity)) continue;
                future.add(otherActivity);
            }
        }
        return optAct;
    }

    private HashMap buildActivityHashMap(LearningDesignDefnVO design) {
        if (design == null) {
            return new HashMap();
        }
        HashMap<Integer, ArrayList> map = new HashMap<Integer, ArrayList>();
        if (design.getTransitions() != null) {
            Iterator iter = design.getTransitions().iterator();
            while (iter.hasNext()) {
                ArrayList entries;
                TransitionDefnVO transition = (TransitionDefnVO)iter.next();
                Integer fromid = new Integer(transition.getFromTaskActivityId());
                Integer toId = new Integer(transition.getToTaskActivityId());
                if (!map.containsKey(fromid)) {
                    entries = new ArrayList();
                    entries.add(toId);
                    map.put(fromid, entries);
                    continue;
                }
                entries = (ArrayList)map.get(fromid);
                entries.add(toId);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildActivityHashMap: returning " + map.toString()));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDActItem getActAfterAct(long ldSid, long currentActSid) {
        logger.debug((Object)("Looking for activity/optional activity after act/opt act sid = " + currentActSid + " design sid is " + ldSid));
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LDActItem item = null;
            LearningDesignDefnDAO ldDAO = new LearningDesignDefnDAO(sess);
            LearningDesignDefnVO design = ldDAO.find(ldSid);
            LDActItem currItem = new OptionalActivityDefnDAO(sess).find(currentActSid);
            if (currItem == null) {
                currItem = new ActivityDefnDAO(sess).find(currentActSid);
            }
            if (design != null && currItem != null) {
                LearningDesignRuntime ldRuntime = new LearningDesignRuntime(sess, design);
                item = ldRuntime.findNextLdActItem(currItem);
            } else {
                logger.debug((Object)("getActAfterOptAct: Unable to look up next as didn't find either design or activity. design=" + design + " activity " + currItem));
            }
            logger.debug((Object)("Returning item " + (item != null ? item.toString() : "null")));
            LDActItem lDActItem = item;
            return lDActItem;
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityDefnVO getActivity(Long sid) throws LDRuntimeServiceException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            ActivityDefnVO activity = null;
            if (sid != null) {
                ActivityDefnDAO actDAO = new ActivityDefnDAO(sess);
                activity = actDAO.find(sid);
            }
            ActivityDefnVO activityDefnVO = activity;
            return activityDefnVO;
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionalActivityDefnVO getOptionalActivity(Long sid) throws LDRuntimeServiceException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            OptionalActivityDefnVO activity = null;
            if (sid != null) {
                OptionalActivityDefnDAO actDAO = new OptionalActivityDefnDAO(sess);
                activity = actDAO.find(sid);
            }
            OptionalActivityDefnVO optionalActivityDefnVO = activity;
            return optionalActivityDefnVO;
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractTaskVO getTask(Long taskSid) throws LDRuntimeServiceException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            AbstractTaskVO task = this.findTask(sess, taskSid);
            sess.flush();
            AbstractTaskVO abstractTaskVO = task;
            return abstractTaskVO;
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LearningDesignDefnVO getLearningDesign(Long ldSid) throws LDRuntimeServiceException {
        if (ldSid == null) {
            return null;
        }
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(sess);
            LearningDesignDefnVO ld = ldDao.find(ldSid);
            sess.flush();
            LearningDesignDefnVO learningDesignDefnVO = ld;
            return learningDesignDefnVO;
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTaskVO getInputContentCreationTask(int ldSid, long contentSid) throws LDRuntimeServiceException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            SimpleTaskDefnDAO tDAO = new SimpleTaskDefnDAO(sess);
            sess.flush();
            SimpleTaskVO simpleTaskVO = tDAO.findByOutputContentSid(contentSid);
            return simpleTaskVO;
        }
        finally {
            sess.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

