/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.runtimeaccess.builder;

import com.webmcq.ld.activities.ActivityDefnVO;
import com.webmcq.ld.activities.LearningDesignDefnVO;
import com.webmcq.ld.activities.OptionalActivityDefnVO;
import com.webmcq.ld.activities.dao.LearningDesignDefnDAO;
import com.webmcq.ld.activities.runtimeaccess.builder.ActivityBuilder;
import com.webmcq.ld.activities.runtimeaccess.builder.BuilderException;
import com.webmcq.ld.activities.runtimeaccess.builder.OptionalActivityBuilder;
import com.webmcq.ld.activities.runtimeaccess.builder.TransitionBuilder;
import com.webmcq.ld.activities.runtimeaccess.tree.DesignNode;
import com.webmcq.ld.activities.runtimeaccess.tree.SequentialStrategy;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class DesignTreeBuilder {
    private static Logger log = Logger.getLogger((String)(class$com$webmcq$ld$activities$runtimeaccess$builder$DesignTreeBuilder == null ? (class$com$webmcq$ld$activities$runtimeaccess$builder$DesignTreeBuilder = DesignTreeBuilder.class$("com.webmcq.ld.activities.runtimeaccess.builder.DesignTreeBuilder")) : class$com$webmcq$ld$activities$runtimeaccess$builder$DesignTreeBuilder).getName());
    private ActivityBuilder activityBuilder = null;
    private OptionalActivityBuilder optActBuilder = null;
    private HashMap idToItemMapping = null;
    static /* synthetic */ Class class$com$webmcq$ld$activities$runtimeaccess$builder$DesignTreeBuilder;

    public DesignNode getLearningDesign(long sid) throws BuilderException {
        log.debug((Object)("Building tree for learning design " + sid));
        PersistenceSession session = null;
        try {
            session = new PersistenceSession();
            LearningDesignDefnDAO ldDao = new LearningDesignDefnDAO(session);
            LearningDesignDefnVO ld = ldDao.find(sid);
            DesignNode ldTopNode = null;
            this.activityBuilder = new ActivityBuilder();
            this.optActBuilder = new OptionalActivityBuilder();
            this.idToItemMapping = new HashMap();
            if (ld != null) {
                log.info((Object)"Found learning design");
                ldTopNode = this.buildLearningDesignNode(ld);
            }
            DesignNode designNode = ldTopNode;
            return designNode;
        }
        catch (SystemException e) {
            log.error((Object)("obtaining learning design '" + sid + "' failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        finally {
            session.close();
        }
    }

    protected DesignNode buildLearningDesignNode(LearningDesignDefnVO ld) throws BuilderException {
        DesignNode ldTopNode = new DesignNode(ld, null);
        Long firstItemSid = this.processLDActivities(ld.getActivities(), ldTopNode, ld.getFirstActivityId());
        Long firstOptActItemSid = this.processLDOptionalActivities(ld.getOptionalActivities(), ldTopNode, ld.getFirstActivityId());
        if (firstItemSid == null) {
            firstItemSid = firstOptActItemSid;
        }
        TransitionBuilder transitionBuilder = new TransitionBuilder(this.idToItemMapping);
        transitionBuilder.processTransitions(ld.getTransitions(), ldTopNode);
        if (firstItemSid == null) {
            throw new BuilderException("Unable to build learning design node. Cannot determine initial activity/optional activity");
        }
        ldTopNode.setStrategy(new SequentialStrategy(firstItemSid));
        log.debug((Object)("Top level strategy: " + (ldTopNode.getStrategy() != null ? ldTopNode.getStrategy().toString() : "null")));
        return ldTopNode;
    }

    protected Long processLDActivities(Collection voItems, DesignNode ldTopNode, Integer firstId) throws BuilderException {
        if (voItems == null) {
            return null;
        }
        Long firstSid = null;
        Iterator voIterator = voItems.iterator();
        while (voIterator.hasNext()) {
            Object obj = null;
            try {
                DesignNode node;
                obj = voIterator.next();
                ActivityDefnVO element = (ActivityDefnVO)obj;
                if (firstId != null && firstId.intValue() == element.getId()) {
                    firstSid = element.getSid();
                }
                if ((node = this.activityBuilder.getActivityNode(element, ldTopNode)) != null) {
                    ldTopNode.add(node);
                }
                this.idToItemMapping.put(new Integer(element.getId()), node);
            }
            catch (ClassCastException e) {
                throw new BuilderException("Unexpected class found. Expected ActivityDefnVO, got " + obj.getClass().getName() + ": " + obj.toString());
            }
        }
        return firstSid;
    }

    protected Long processLDOptionalActivities(Collection voItems, DesignNode ldTopNode, Integer firstId) throws BuilderException {
        if (voItems == null) {
            return null;
        }
        Long firstSid = null;
        Iterator voIterator = voItems.iterator();
        while (voIterator.hasNext()) {
            Object obj = null;
            try {
                DesignNode node;
                obj = voIterator.next();
                OptionalActivityDefnVO element = (OptionalActivityDefnVO)obj;
                if (firstId != null && firstId.intValue() == element.getId()) {
                    firstSid = element.getSid();
                }
                if ((node = this.optActBuilder.getOptionalActivityNode(element, ldTopNode)) != null) {
                    ldTopNode.add(node);
                }
                this.idToItemMapping.put(new Integer(element.getId()), node);
            }
            catch (ClassCastException e) {
                throw new BuilderException("Unexpected class found. Expected OptionalActivityDefnVO, got " + obj.getClass().getName() + ": " + obj.toString());
            }
        }
        return firstSid;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

