/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.controller.Activity;
import com.webmcq.ld.controller.ActivityInstance;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.LearnerProgress;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.LearningSessionException;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceDAO;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class Learner {
    public static final int NOT_STARTED = 1;
    public static final int ACTIVE = 2;
    public static final int INACTIVE = 3;
    public static final int COMPLETED = 4;
    private long sid;
    private long userId;
    private LearningSession learningSession;
    private int status;
    private LearnerProgress progress;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$Learner == null ? (class$com$webmcq$ld$controller$Learner = Learner.class$("com.webmcq.ld.controller.Learner")) : class$com$webmcq$ld$controller$Learner));
    static /* synthetic */ Class class$com$webmcq$ld$controller$Learner;

    private Learner() {
    }

    public Learner(long userId, LearningSession session) {
        this.userId = userId;
        this.learningSession = session;
        this.status = 1;
        this.progress = new LearnerProgress(session.getLearningDesignId());
    }

    public DisplayTaskData toNextTask(PersistenceSession sess, TaskInstance nextTaskInsatnce) throws ControllerException {
        return nextTaskInsatnce == null ? this.completeSession() : this.toTask(sess, nextTaskInsatnce);
    }

    public TaskInstance getNextTaskInstance(PersistenceSession sess) throws ControllerException {
        log.info((Object)("toNextTask: learner " + this.getSid()));
        Task task = this.getNextTask(sess);
        log.debug((Object)("next task found: " + task));
        return task == null ? null : this.learningSession.getLearningDesignSession().getTaskInstance(sess, task, this);
    }

    private Task getNextTask(PersistenceSession sess) throws ControllerException {
        return this.learningSession.getLearningDesign().nextTask(this.getCurrentTask(), sess);
    }

    public Task getCurrentTask() {
        return this.progress.getCurrentTask();
    }

    public DisplayTaskData toTask(PersistenceSession sess, TaskInstance taskInstance) throws ControllerException {
        taskInstance.prepareTool();
        return this.runTask(sess, taskInstance);
    }

    public DisplayTaskData runTask(PersistenceSession sess, TaskInstance taskInstance) throws ControllerException {
        DisplayTaskData displayTaskData = null;
        log.debug((Object)"next task is not null");
        displayTaskData = this.runTaskInstance(taskInstance);
        TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
        tiDao.update(taskInstance);
        return displayTaskData;
    }

    public void completeCurrentTask() {
        this.progress.completeCurrentTask();
    }

    private DisplayTaskData completeSession() {
        log.debug((Object)"complete learning session");
        DisplayTaskData displayTaskData = new DisplayTaskData(20);
        this.progress.setCurrentTaskInstance(null);
        this.status = 4;
        return displayTaskData;
    }

    private DisplayTaskData runTaskInstance(TaskInstance taskInstance) {
        log.debug((Object)"runTaskInstance");
        taskInstance.participate(this);
        DisplayTaskData displayTaskData = taskInstance.run(this);
        this.status = 2;
        return displayTaskData;
    }

    public LearningSession getLearningSession() {
        return this.learningSession;
    }

    public boolean hasTaken(TaskInstance taskInstance) {
        return this.progress.hasTaken(taskInstance);
    }

    public void exit() {
        this.status = 3;
    }

    public DisplayTaskData resume() {
        log.debug((Object)"resume");
        TaskInstance task = this.progress.getCurrentTaskInstance();
        DisplayTaskData displayTaskData = null;
        if (task != null) {
            displayTaskData = task.resume(this);
        }
        this.status = 2;
        return displayTaskData;
    }

    public String[] checkup() {
        log.debug((Object)"checkup");
        TaskInstance task = this.progress.getCurrentTaskInstance();
        String[] urls = null;
        if (task != null) {
            urls = task.checkup(this);
        }
        this.status = 2;
        return urls;
    }

    public DisplayTaskData view(TaskInstance taskInstance) {
        log.debug((Object)"view");
        DisplayTaskData displayTaskData = taskInstance.view();
        this.status = 2;
        return displayTaskData;
    }

    public ActivityInstance getCurrentActivityInstance() throws ControllerException {
        return this.progress.getCurrentActivityInstance();
    }

    public Activity getCurrentActivity() throws LearningSessionException {
        try {
            return this.progress.getCurrentActivity();
        }
        catch (ControllerException e) {
            throw new LearningSessionException(e);
        }
    }

    public List getPastActivities(ActivityInstance curActInstance) throws ControllerException {
        return this.progress.getPastActivities(curActInstance);
    }

    public Long[] getPastTaskInstanceIds() {
        return this.progress.getPastTaskInstanceIds();
    }

    public Activity[] getFutureActivties(ActivityInstance curActInstance) throws ControllerException {
        return this.progress.getFutureActivties(curActInstance);
    }

    public long getSid() {
        return this.sid;
    }

    public ShwaaUserData getUser() {
        try {
            return UserServiceDelegate.find(this.userId);
        }
        catch (UserNotFoundException e) {
            return null;
        }
    }

    private void setLearningSession(LearningSession learningSession) {
        this.learningSession = learningSession;
    }

    private void setSid(long sid) {
        this.sid = sid;
    }

    public TaskInstance getCurrentTaskInstance() {
        return this.progress.getCurrentTaskInstance();
    }

    public void setCurrentTaskInstance(TaskInstance currentTaskInstance) {
        this.progress.setCurrentTaskInstance(currentTaskInstance);
    }

    public int getStatus() {
        return this.status;
    }

    private void setStatus(int status) {
        this.status = status;
    }

    public List getTaskInstancesTaken() {
        return this.progress.getPastTaskInstances();
    }

    public TaskInstance getLastTaskInstance() {
        return this.progress.getLastTaskInstance();
    }

    public void removeTaskInstanceFromHistory(long taskInstanceId) throws ControllerException {
        this.progress.removeTaskInstanceFromHistory(taskInstanceId);
    }

    private LearnerProgress getProgress() {
        return this.progress;
    }

    private void setProgress(LearnerProgress progress) {
        this.progress = progress;
    }

    public long getUserId() {
        return this.userId;
    }

    private void setUserId(long userId) {
        this.userId = userId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("sid", this.sid).append("userId", this.userId).append("status", this.status).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

