/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.tool;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.OptionalTaskInstance;
import com.webmcq.ld.controller.SyncTaskInstance;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.LearnerDAO;
import com.webmcq.ld.controller.dao.LearningSessionDAO;
import com.webmcq.ld.controller.dao.TaskInstanceDAO;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dto.ActivityData;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.tool.StaffMonitorNotifier;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.exception.BusinessException;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import javax.ejb.EJBException;
import org.apache.log4j.Logger;

public abstract class SupportToolServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$tool$SupportToolServiceBean == null ? (class$com$webmcq$ld$controller$tool$SupportToolServiceBean = SupportToolServiceBean.class$("com.webmcq.ld.controller.tool.SupportToolServiceBean")) : class$com$webmcq$ld$controller$tool$SupportToolServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$controller$tool$SupportToolServiceBean;

    public OptionalTaskInstance getTaskInstance(long taskInstanceId) throws TaskInstanceNotFoundException, ControllerException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
            TaskInstance task = tiDao.find(taskInstanceId);
            if (!(task instanceof OptionalTaskInstance)) {
                throw new ControllerException("not an optional activities selection task: '" + taskInstanceId + "'");
            }
            OptionalTaskInstance optionalTaskInstance = (OptionalTaskInstance)task;
            return optionalTaskInstance;
        }
        catch (TaskInstanceNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public TaskInstance getChosenOptionalActivity(long activityId, long sessionId) throws TaskInstanceNotFoundException, ControllerException {
        OptionalTaskInstance opTaskInstance = this.getTaskInstance(sessionId);
        return opTaskInstance.getFirstTask(activityId);
    }

    public ActivityData[] getOptionalActivities(ShwaaUserData user, long taskInstanceId) throws TaskInstanceNotFoundException, ControllerException {
        OptionalTaskInstance opTaskInstance = this.getTaskInstance(taskInstanceId);
        Learner learner = opTaskInstance.getLearningSession().findLearner(user);
        return opTaskInstance.getActivities(learner);
    }

    public DisplayTaskData joinWaiting(long userId, long taskInstanceId, String callbackURL) throws UserNotFoundException, TaskInstanceNotFoundException, ControllerException {
        DisplayTaskData displayTaskData = null;
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
            SyncTaskInstance syncTaskInstance = tiDao.findSyncTaskInstance(taskInstanceId);
            if (syncTaskInstance.isConditionMet()) {
                Learner learner = syncTaskInstance.getLearningSession().findLearner(userId);
                TaskInstance nextTaskInstance = learner.getNextTaskInstance(sess);
                learner.completeCurrentTask();
                displayTaskData = learner.toNextTask(sess, nextTaskInstance);
                learner.setCurrentTaskInstance(nextTaskInstance);
                tiDao.update(syncTaskInstance);
                LearnerDAO learnerDao = new LearnerDAO(sess);
                learnerDao.update(learner);
            }
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            lsDao.update(syncTaskInstance.getLearningSession());
            sess.flush();
            this.notifySyncToProcess(syncTaskInstance, callbackURL);
        }
        catch (TaskInstanceNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
        return displayTaskData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnClassSyncOff(long userId, long taskInstanceId) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            PersistenceSession sess = null;
            try {
                log.debug((Object)"turnClassSyncOff");
                sess = new PersistenceSession();
                TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
                SyncTaskInstance task = tiDao.findSyncTaskInstance(taskInstanceId);
                task.turnClassSyncOff();
                if (task.isConditionMet()) {
                    task.releaseLearners(sess, userId);
                }
                tiDao.update(task);
                LearningSessionDAO lsDao = new LearningSessionDAO(sess);
                lsDao.update(task.getLearningSession());
                sess.flush();
            }
            catch (BusinessException e) {
                this.getSessionContext().setRollbackOnly();
                throw new SystemException(e);
            }
            catch (SystemException e) {
                this.getSessionContext().setRollbackOnly();
                throw e;
            }
            finally {
                sess.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void turnTeacherSyncOff(long userId, long taskInstanceId) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            PersistenceSession sess = null;
            try {
                log.debug((Object)"turnTeacherSyncOff");
                sess = new PersistenceSession();
                TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
                SyncTaskInstance task = tiDao.findSyncTaskInstance(taskInstanceId);
                task.turnTeacherSyncOff(userId);
                if (task.isConditionMet()) {
                    task.releaseLearners(sess, userId);
                }
                tiDao.update(task);
                LearningSessionDAO lsDao = new LearningSessionDAO(sess);
                lsDao.update(task.getLearningSession());
                sess.flush();
            }
            catch (BusinessException e) {
                this.getSessionContext().setRollbackOnly();
                throw new SystemException(e);
            }
            catch (SystemException e) {
                this.getSessionContext().setRollbackOnly();
                throw e;
            }
            finally {
                sess.close();
            }
        }
    }

    public SyncTaskInstance getSyncTask(long taskInstanceId) throws SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"getSyncTask");
            sess = new PersistenceSession();
            TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
            SyncTaskInstance syncTaskInstance = tiDao.findSyncTaskInstance(taskInstanceId);
            return syncTaskInstance;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            throw new SystemException(e);
        }
        finally {
            sess.close();
        }
    }

    private void notifySyncToProcess(SyncTaskInstance syncTask, String callbackURL) {
        try {
            String title = syncTask.getTask().getTitle() + " (" + syncTask.getParticipants().size() + " of " + syncTask.getGroup().size() + " learners ready)";
            String url = syncTask.getStaffId() == null ? callbackURL : null;
            StaffMonitorNotifier.notifyControllerOfURL(syncTask.getSid(), "sync", title, url);
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

