/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.tool.grouping.web;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.tool.grouping.GroupingServiceDelegate;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class GroupingAction
extends ToolAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$tool$grouping$web$GroupingAction == null ? (class$com$webmcq$ld$controller$tool$grouping$web$GroupingAction = GroupingAction.class$("com.webmcq.ld.controller.tool.grouping.web.GroupingAction")) : class$com$webmcq$ld$controller$tool$grouping$web$GroupingAction));
    public static String JSP_TASK_INSTANCE_ID_TAG = "sessionId";
    public static String JSP_GROUP_MAP_TAG = "group_map";
    static /* synthetic */ Class class$com$webmcq$ld$controller$tool$grouping$web$GroupingAction;

    public ActionForward viewGroupMembers(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"viewGroupMembers");
            long sessionId = WebUtil.readLongParam(req, "sessionId");
            long userId = UserServiceDelegate.findUserId(WebUtil.getUsername(req));
            String mode = WebUtil.readStrParam(req, "mode");
            log.debug((Object)("viewGroupMembers: mode: " + mode));
            if ("view".equals(mode)) {
                req.setAttribute("viewOnly", (Object)mode);
            } else if ("checkup".equals(mode)) {
                req.setAttribute("viewOnly", (Object)mode);
            }
            req.setAttribute(JSP_TASK_INSTANCE_ID_TAG, (Object)new Long(sessionId));
            long lessionID = WebUtil.retrieveLearningSessionIdFromSession(req, mode);
            if ("run".equals(mode) || "resume".equals(mode)) {
                GroupingServiceDelegate.updateGrouping(userId, sessionId, lessionID);
            }
            Map userGroupData = GroupingServiceDelegate.getGroupingData(userId, sessionId, lessionID);
            req.setAttribute(JSP_GROUP_MAP_TAG, (Object)userGroupData);
            WebUtil.saveToken(req, "transactionKeyGrouping", this.generateToken(req));
            return mapping.findForward("grouping_done.jsp");
        }
        catch (UserNotFoundException e) {
            log.error((Object)"UserNotFoundException exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (ToolException e) {
            log.error((Object)"ToolException exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"unexpected exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward completeSession(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            if (WebUtil.isTokenValid(req, "transactionKeyGrouping")) {
                WebUtil.resetToken(req, "transactionKeyGrouping");
                req.getSession().removeAttribute("transactionDoneGrouping");
                log.debug((Object)"completeSession");
                String username = WebUtil.getUsername(req);
                long userId = UserServiceDelegate.findUserId(username);
                long sessionId = WebUtil.readLongParam(req, "sessionId");
                DisplayTaskData displayTaskData = LearnerServiceDelegate.moveToNextTask(sessionId, userId);
                ActionForward action = this.displayTask(displayTaskData, mapping, form, req, res);
                req.getSession().setAttribute("transactionDoneGrouping", (Object)action);
                return action;
            }
            return this.duplicateSubmission(mapping, req, "transactionKeyGrouping");
        }
        catch (UserNotFoundException e) {
            log.error((Object)"UserNotFoundException occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (ControllerException e) {
            log.error((Object)"ControllerException occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"unexpected exception occured", (Throwable)e);
            throw new SystemException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

