/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.service;

import com.webmcq.ld.controller.Activity;
import com.webmcq.ld.controller.ActivityInstance;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.ToolProxy;
import com.webmcq.ld.controller.dao.LearnerDAO;
import com.webmcq.ld.controller.dao.LearningSessionDAO;
import com.webmcq.ld.controller.dao.LearningSessionNotFoundException;
import com.webmcq.ld.controller.dao.TaskInstanceDAO;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dao.ToolNotFoundException;
import com.webmcq.ld.controller.dao.ToolProxyDAO;
import com.webmcq.ld.controller.dto.ActivityData;
import com.webmcq.ld.controller.dto.ControllerDTOFactory;
import com.webmcq.ld.controller.dto.LearningSessionData;
import com.webmcq.ld.controller.dto.PersonalProgressData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.controller.dto.ToolProxyData;
import com.webmcq.ld.controller.learner.LearnerGroup;
import com.webmcq.ld.controller.tool.grouping.GroupingContent;
import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.service.interfaces.ConfigurationServiceLocal;
import com.webmcq.ld.service.interfaces.ConfigurationServiceUtil;
import com.webmcq.ld.usermanagement.OrganisationCompleteData;
import com.webmcq.ld.usermanagement.OrganisationRecursiveData;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.UserManagementException;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import com.webmcq.ld.util.persistence.ThreadLocalSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.Transaction;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public abstract class LearnerServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$service$LearnerServiceBean == null ? (class$com$webmcq$ld$service$LearnerServiceBean = LearnerServiceBean.class$("com.webmcq.ld.service.LearnerServiceBean")) : class$com$webmcq$ld$service$LearnerServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$service$LearnerServiceBean;

    public LearningSessionData getLearningSession(long userId, long learningSessionId) throws LearningSessionNotFoundException, UserManagementException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession learningSession = lsDao.find(learningSessionId);
            sess.flush();
            LearningSessionData learningSessionData = ControllerDTOFactory.buildDetailedLearningSessionData(userId, learningSession);
            return learningSessionData;
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (UserManagementException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public LearningSessionData[] getLearningSessionsLearner(long userId) throws ControllerException {
        try {
            log.debug((Object)("(Begin) getLearningSessions for the user : " + userId));
            Session sess = null;
            sess = ThreadLocalSession.reconnectSession();
            if (sess == null) {
                sess = ThreadLocalSession.currentSession();
            }
            LearningSessionDAO lsDao = new LearningSessionDAO();
            LearningSessionData[] availableSessions = lsDao.findByOrganisation(sess, userId, 2, 0);
            this.updateLearnerStatus(sess, userId, availableSessions);
            availableSessions = this.filterOutUnavailable(availableSessions);
            log.debug((Object)("(End) getLearningSessions for the user : " + userId));
            LearningSessionData[] learningSessionDataArray = availableSessions;
            return learningSessionDataArray;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (HibernateException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ControllerException(e);
        }
        catch (NamingException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ControllerException(e);
        }
        finally {
            try {
                ThreadLocalSession.closeSession();
            }
            catch (HibernateException e) {
                throw new ControllerException(e);
            }
        }
    }

    public LearningSessionData[] getLearningSessions(long userId) throws ControllerException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            Set orgs = UserServiceDelegate.findSessionOrganisations(userId);
            Iterator iter = orgs.iterator();
            long[] orgIds = new long[orgs.size()];
            int i = 0;
            while (iter.hasNext()) {
                orgIds[i++] = ((OrganisationRecursiveData)iter.next()).getSid();
            }
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            List list = lsDao.findByOrganisation(orgIds, 2, 0);
            LearningSessionData[] availableSessions = ControllerDTOFactory.buildLearningSessionDatas(list);
            this.updateLearnerStatus(sess, userId, availableSessions);
            LearningSessionData[] learningSessionDataArray = availableSessions = this.filterOutUnavailable(availableSessions);
            return learningSessionDataArray;
        }
        catch (UserManagementException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ControllerException(e);
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    private void updateLearnerStatus(Session sess, long userId, LearningSessionData[] sessions) {
        LearnerDAO ldao = new LearnerDAO();
        Map joinedSessions = ldao.findAllLearningSessions(sess, userId);
        for (int j = 0; j < sessions.length; ++j) {
            Learner learner = (Learner)joinedSessions.get(new Long(sessions[j].getSid()));
            if (learner == null) {
                sessions[j].setStatus(1);
                continue;
            }
            if (learner.getStatus() == 4) {
                sessions[j].setStatus(4);
                continue;
            }
            if (learner.getStatus() == 1) {
                sessions[j].setStatus(1);
                continue;
            }
            if (learner.getStatus() == 2) {
                sessions[j].setStatus(2);
                continue;
            }
            if (learner.getStatus() != 3) continue;
            sessions[j].setStatus(2);
        }
    }

    private void updateLearnerStatus(PersistenceSession sess, long userId, LearningSessionData[] sessions) {
        LearnerDAO ldao = new LearnerDAO(sess);
        Map joinedSessions = ldao.findAllLearningSessions(userId);
        for (int j = 0; j < sessions.length; ++j) {
            Learner learner = (Learner)joinedSessions.get(new Long(sessions[j].getSid()));
            if (learner == null) {
                sessions[j].setStatus(1);
                continue;
            }
            if (learner.getStatus() == 4) {
                sessions[j].setStatus(4);
                continue;
            }
            if (learner.getStatus() == 1) {
                sessions[j].setStatus(1);
                continue;
            }
            if (learner.getStatus() == 2) {
                sessions[j].setStatus(2);
                continue;
            }
            if (learner.getStatus() != 3) continue;
            sessions[j].setStatus(2);
        }
    }

    private LearningSessionData[] filterOutUnavailable(LearningSessionData[] sessions) {
        ArrayList filtered = new ArrayList();
        CollectionUtils.addAll(filtered, (Object[])sessions);
        Iterator iter = filtered.iterator();
        while (iter.hasNext()) {
            LearningSessionData sess = (LearningSessionData)iter.next();
            if (sess.getStatus() != 1 || sess.isAvailable()) continue;
            iter.remove();
        }
        return filtered.toArray(new LearningSessionData[0]);
    }

    public DisplayTaskData join(String username, int lsessionId) throws UserNotFoundException, LearningSessionNotFoundException, ControllerException, SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)("join: " + username + ", " + lsessionId));
            UserData user = UserServiceDelegate.findCompleteUser(username);
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession lsession = lsDao.find(lsessionId);
            DisplayTaskData displayTaskData = lsession.join(sess, user);
            lsession.cacheLearningSessionUsers(String.valueOf(lsession.getSid()), user);
            lsDao.update(lsession);
            log.debug((Object)("user '" + username + "' joined learning session '" + lsessionId + "'."));
            sess.flush();
            DisplayTaskData displayTaskData2 = displayTaskData;
            return displayTaskData2;
        }
        catch (UserNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public void setOrganisation(long userId, long learningSessionId, long organisationId) throws LearningSessionNotFoundException, ControllerException, UserManagementException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)("setOrganisation: org id=" + organisationId));
            OrganisationCompleteData org = UserServiceDelegate.findOrganisation(organisationId, userId);
            if (org == null) {
                throw new ControllerException("organisation '" + organisationId + "' not found");
            }
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession learningSession = lsDao.find(learningSessionId);
            learningSession.setOrganisation(organisationId);
            lsDao.update(learningSession);
            sess.flush();
        }
        catch (UserManagementException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public String getServerURL() throws SystemException {
        try {
            ConfigurationServiceLocal service = ConfigurationServiceUtil.getLocalHome().create();
            String url = service.get(ConfigurationKeys.SERVER_URL);
            service.remove();
            log.debug((Object)("getServerURL: '" + url + "'"));
            if (url == null) {
                throw new SystemException("server URL not configured");
            }
            return url;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public ToolProxy findToolByType(String toolType) throws ControllerException, ToolNotFoundException {
        ToolProxy toolProxy = null;
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            ToolProxyDAO dao = new ToolProxyDAO(sess);
            toolProxy = dao.findByToolType(toolType);
            sess.flush();
            ToolProxy toolProxy2 = toolProxy;
            return toolProxy2;
        }
        catch (ToolNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public void installTool(ToolProxyData tool) {
        PersistenceSession sess = null;
        try {
            ToolProxy toolProxy = new ToolProxy(tool.getName(), tool.getType(), tool.getLearnerURL(), tool.getJndiName());
            sess = new PersistenceSession();
            ToolProxyDAO dao = new ToolProxyDAO(sess);
            dao.insert(toolProxy);
            sess.flush();
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public void handleGroupingContent(long taskInstanceId, GroupingContent content) throws UserNotFoundException, TaskInstanceNotFoundException, ControllerException, JDBCException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)("handleGroupingContent begin: " + content));
            sess = new PersistenceSession();
            TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            TaskInstance taskInstance = tiDao.find(taskInstanceId);
            LearnerGroup learnerGroup = taskInstance.getLearningSession().getLearnerGroup();
            if (learnerGroup.containsGroupSet(content.getGroupingId())) {
                learnerGroup.updateGroupSet(content);
            } else {
                learnerGroup.createGroupSet(content);
            }
            lsDao.updateCurrentLearningSession(taskInstance.getLearningSession());
            sess.flushWithJDBCException();
        }
        catch (JDBCException e) {
            throw e;
        }
        catch (TaskInstanceNotFoundException e) {
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public Object[] completeCurrentTask(long taskInstanceId, long userId) throws ControllerException, TaskInstanceNotFoundException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            Transaction tx = sess.startTransaction();
            TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
            TaskInstance taskInstance = tiDao.find(taskInstanceId);
            Learner learner = this.findLearner(sess, userId, taskInstance);
            taskInstance.complete(learner);
            tiDao.update(taskInstance);
            sess.commitTransaction(tx);
            Object[] objectArray = new Object[]{learner, taskInstance};
            return objectArray;
        }
        catch (TaskInstanceNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public boolean hasCompletedCurrentTask(Learner learner, TaskInstance taskInstance) throws TaskInstanceNotFoundException, ControllerException {
        boolean hasCompleted = true;
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
            sess.lockSession(learner, LockMode.READ);
            if (tiDao.isPartOfMultiTask(learner.getSid(), taskInstance.getSid())) {
                log.debug((Object)("given task instance is multi: " + taskInstance.getSid()));
                if (!this.hasCompletedMultiTask(learner, taskInstance, sess, tiDao)) {
                    hasCompleted = false;
                }
            } else {
                log.debug((Object)("given task instance is not multi: " + taskInstance.getSid()));
            }
            boolean bl = hasCompleted;
            return bl;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public TaskInstance getNextTaskInstance(Learner learner) throws ControllerException {
        PersistenceSession sess = null;
        TaskInstance nextTaskInstance = null;
        try {
            sess = new PersistenceSession();
            Transaction tx = sess.startTransaction();
            nextTaskInstance = learner.getNextTaskInstance(sess);
            sess.commitTransaction(tx);
            TaskInstance taskInstance = nextTaskInstance;
            return taskInstance;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            log.error((Object)("We got error, cause is - [" + e.getCause() + "] name is = [" + e.getMessage() + "]"));
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public DisplayTaskData gotoTask(long taskInstanceId, ShwaaUserData user) throws TaskInstanceNotFoundException, ControllerException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
            TaskInstance taskInstance = tiDao.find(taskInstanceId);
            Learner learner = taskInstance.getLearningSession().findLearner(user);
            learner.completeCurrentTask();
            DisplayTaskData displayTaskData = learner.toNextTask(sess, taskInstance);
            learner.setCurrentTaskInstance(taskInstance);
            LearnerDAO dao = new LearnerDAO(sess);
            dao.update(learner);
            sess.flush();
            DisplayTaskData displayTaskData2 = displayTaskData;
            return displayTaskData2;
        }
        catch (TaskInstanceNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public void exit(ShwaaUserData user, long learningSessionId) throws LearningSessionNotFoundException, ControllerException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession lsess = lsDao.find(learningSessionId);
            Learner learner = lsess.findLearner(user);
            if (learner == null) {
                throw new ControllerException("user '" + user.getLogin() + "' does not belong to the learning session '" + learningSessionId + "'");
            }
            learner.exit();
            LearnerDAO dao = new LearnerDAO(sess);
            dao.update(learner);
            sess.flush();
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public DisplayTaskData resume(ShwaaUserData user, long learningSessionId) throws LearningSessionNotFoundException, ControllerException, UserNotFoundException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession lsess = lsDao.find(learningSessionId);
            UserData userDetail = UserServiceDelegate.findCompleteUser(user.getLogin());
            lsess.cacheLearningSessionUsers(String.valueOf(lsess.getSid()), userDetail);
            if (lsess.getStatus() != 2) {
                throw new ControllerException("learning session '" + learningSessionId + "' is not active.");
            }
            Learner learner = lsess.findLearner(user);
            if (learner == null) {
                throw new ControllerException("user '" + user.getLogin() + "' does not belong to the learning session '" + learningSessionId + "'");
            }
            DisplayTaskData displayTaskData = learner.resume();
            if (displayTaskData != null) {
                TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
                tiDao.update(learner.getCurrentTaskInstance());
                LearnerDAO dao = new LearnerDAO(sess);
                dao.update(learner);
                sess.flush();
            }
            DisplayTaskData displayTaskData2 = displayTaskData;
            return displayTaskData2;
        }
        catch (UserNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public DisplayTaskData resume(long userId, String userName, long learningSessionId) throws LearningSessionNotFoundException, ControllerException, UserNotFoundException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession lsess = lsDao.find(learningSessionId);
            UserData userDetail = UserServiceDelegate.findCompleteUser(userName);
            lsess.cacheLearningSessionUsers(String.valueOf(lsess.getSid()), userDetail);
            if (lsess.getStatus() != 2) {
                throw new ControllerException("learning session '" + learningSessionId + "' is not active.");
            }
            Learner learner = lsess.findLearner(userId);
            if (learner == null) {
                throw new ControllerException("user '" + userName + "' does not belong to the learning session '" + learningSessionId + "'");
            }
            DisplayTaskData displayTaskData = learner.resume();
            if (displayTaskData != null) {
                TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
                tiDao.update(learner.getCurrentTaskInstance());
                LearnerDAO dao = new LearnerDAO(sess);
                dao.update(learner);
                sess.flush();
            }
            DisplayTaskData displayTaskData2 = displayTaskData;
            return displayTaskData2;
        }
        catch (UserNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public DisplayTaskData view(ShwaaUserData user, long taskInstanceId) throws TaskInstanceNotFoundException, ControllerException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
            TaskInstance taskInstance = tiDao.find(taskInstanceId);
            Learner learner = taskInstance.getLearningSession().findLearner(user);
            if (learner == null) {
                throw new ControllerException("user '" + user.getLogin() + "' does not belong to the task instance '" + taskInstanceId + "'");
            }
            DisplayTaskData displayTaskData = learner.view(taskInstance);
            tiDao.update(taskInstance);
            LearnerDAO dao = new LearnerDAO(sess);
            dao.update(learner);
            sess.flush();
            DisplayTaskData displayTaskData2 = displayTaskData;
            return displayTaskData2;
        }
        catch (TaskInstanceNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public TaskInstanceData[] getJournalTasks(long learningSessionId) throws ToolNotFoundException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"getJournalTasks");
            sess = new PersistenceSession();
            ToolProxyDAO dao = new ToolProxyDAO(sess);
            ToolProxy tool = dao.findByToolType("journal");
            TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
            TaskInstance[] tasks = tiDao.findAll(learningSessionId);
            sess.flush();
            ArrayList<TaskInstanceData> selectedTasks = new ArrayList<TaskInstanceData>();
            for (int i = 0; i < tasks.length; ++i) {
                try {
                    if (!"journal".equals(tasks[i].getToolType())) continue;
                    TaskInstanceData data = tasks[i].getData();
                    data.setUrl(tool.getUrl(tasks[i]));
                    selectedTasks.add(data);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("getJournalTasks: Unable to process task with sid " + tasks[i].getSid() + " due to exception"), (Throwable)e);
                }
            }
            TaskInstanceData[] taskInstanceDataArray = selectedTasks.toArray(new TaskInstanceData[0]);
            return taskInstanceDataArray;
        }
        catch (ToolNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public ActivityData[] getProgress(long userId, long learningSessionId) throws UserNotFoundException, LearningSessionNotFoundException, ControllerException {
        return this.getProgress(userId, learningSessionId, "view");
    }

    private ActivityData[] getProgress(long userId, long learningSessionId, String mode) throws UserNotFoundException, LearningSessionNotFoundException, ControllerException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"getProgress");
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession lsess = lsDao.find(learningSessionId);
            sess.flush();
            ShwaaUserData user = UserServiceDelegate.find(userId);
            Learner learner = lsess.findLearner(user);
            if (learner == null) {
                throw new ControllerException("learner '" + userId + "' not found");
            }
            log.debug((Object)"getProgress():precondition check done");
            ActivityInstance curActInstance = this.getCurrentActivityInstance(learner);
            List data = this.getPast(learner, curActInstance, mode);
            this.getPresent(learner, curActInstance, data, mode);
            this.getFuture(learner, curActInstance, data);
            ActivityData[] activityDataArray = data.toArray(new ActivityData[0]);
            return activityDataArray;
        }
        catch (UserNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    private List getPast(Learner learner, ActivityInstance currentActInstance, String mode) throws ControllerException {
        ArrayList<ActivityData> data = new ArrayList<ActivityData>();
        Iterator iter = learner.getPastActivities(currentActInstance).iterator();
        while (iter.hasNext()) {
            ActivityInstance instance = (ActivityInstance)iter.next();
            data.add(instance.getData(mode, learner));
        }
        return data;
    }

    private void getPresent(Learner learner, ActivityInstance currentActInstance, List data, String mode) throws ControllerException {
        if (currentActInstance != null) {
            ActivityData aData = currentActInstance.getData(mode, learner);
            aData.setStatus(2);
            data.add(aData);
        }
    }

    private ActivityInstance getCurrentActivityInstance(Learner learner) throws ControllerException {
        return learner.getCurrentActivityInstance();
    }

    private void getFuture(Learner learner, ActivityInstance currentActInstance, List data) throws ControllerException {
        Activity[] futureActs = learner.getFutureActivties(currentActInstance);
        for (int i = 0; i < futureActs.length; ++i) {
            data.add(ControllerDTOFactory.buildActivityData(futureActs[i]));
        }
    }

    public PersonalProgressData[] getAllProgress(long learningSessionId) throws UserNotFoundException, LearningSessionNotFoundException, ControllerException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"getAllProgress");
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession lsess = lsDao.find(learningSessionId);
            PersonalProgressData[] data = new PersonalProgressData[lsess.getLearners().size()];
            Iterator iter = lsess.getLearners().getUserIds();
            int i = 0;
            while (iter.hasNext()) {
                data[i++] = this.getPersonalProgress((Long)iter.next(), learningSessionId);
            }
            PersonalProgressData[] personalProgressDataArray = data;
            return personalProgressDataArray;
        }
        catch (UserNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    private PersonalProgressData getPersonalProgress(Long userId, long learningSessionId) throws UserNotFoundException, LearningSessionNotFoundException, ControllerException {
        ShwaaUserData user = UserServiceDelegate.find(userId);
        ActivityData[] activities = this.getProgress(userId, learningSessionId, "checkup");
        return new PersonalProgressData(user.getUid(), user.getLogin(), user.getFirstName(), user.getLastName(), activities);
    }

    public ActivityData getCurrentActivity(long userId, long learningSessionId) throws UserNotFoundException, LearningSessionNotFoundException, ControllerException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"getCurrentActivity");
            sess = new PersistenceSession();
            LearningSessionDAO lsDao = new LearningSessionDAO(sess);
            LearningSession lsession = lsDao.find(learningSessionId);
            ShwaaUserData user = UserServiceDelegate.find(userId);
            Learner learner = lsession.findLearner(user);
            if (learner == null) {
                throw new ControllerException("learner '" + userId + "' not found");
            }
            ActivityInstance currentActivity = learner.getCurrentActivityInstance();
            if (currentActivity == null) {
                ActivityData activityData = null;
                return activityData;
            }
            ActivityData activityData = currentActivity.getData("view", learner);
            return activityData;
        }
        catch (UserNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (LearningSessionNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    public DisplayTaskData moveToNextTask(Learner learner, TaskInstance nextTaskInstance) throws ControllerException, SystemException {
        PersistenceSession sess = null;
        DisplayTaskData displayTaskData = null;
        try {
            sess = new PersistenceSession();
            Transaction tx = sess.startTransaction();
            sess.lockSession(learner, LockMode.READ);
            learner.completeCurrentTask();
            if (nextTaskInstance != null) {
                sess.lockSession(nextTaskInstance, LockMode.READ);
            }
            displayTaskData = learner.toNextTask(sess, nextTaskInstance);
            learner.setCurrentTaskInstance(nextTaskInstance);
            LearnerDAO dao = new LearnerDAO(sess);
            dao.update(learner);
            sess.flushWithJDBCException();
            sess.commitTransaction(tx);
            DisplayTaskData displayTaskData2 = displayTaskData;
            return displayTaskData2;
        }
        catch (JDBCException e) {
            if (e.getErrorCode() == 1062) {
                log.debug((Object)"We got duplicates in updating learner");
            }
            if (displayTaskData != null) {
                log.debug((Object)"but it doesn't matter, because we've got the displayTaskData");
                DisplayTaskData displayTaskData3 = displayTaskData;
                return displayTaskData3;
            }
            log.debug((Object)"and we also failed to get the displayTaskData");
            throw new SystemException("JDBCException: " + e.getMessage());
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProgressStatus(long userId, long lsessionId) throws UserNotFoundException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            LearnerDAO dao = new LearnerDAO(sess);
            Learner learner = dao.find(userId, lsessionId);
            if (learner == null) {
                int n = 1;
                return n;
            }
            int n = learner.getStatus();
            return n;
        }
        finally {
            sess.close();
        }
    }

    public void updateLearnerStatus(Learner learner) throws ControllerException, SystemException {
        PersistenceSession sess = null;
        try {
            sess = new PersistenceSession();
            Transaction tx = sess.startTransaction();
            sess.lockSession(learner, LockMode.READ);
            LearnerDAO dao = new LearnerDAO(sess);
            dao.update(learner);
            sess.commitTransaction(tx);
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    private boolean hasCompletedMultiTask(Learner learner, TaskInstance taskInstance, PersistenceSession sess, TaskInstanceDAO tiDao) throws ControllerException {
        TaskInstance multiTask = tiDao.findMultiTask(learner.getSid(), taskInstance.getSid());
        log.debug((Object)("completeMultiTask: multi-task instance found '" + multiTask.getSid() + "'"));
        if (multiTask.hasCompleted(learner)) {
            log.debug((Object)"completeMultiTask: completed");
            return true;
        }
        log.debug((Object)"completeMultiTask: not completed");
        return false;
    }

    private Learner findLearner(PersistenceSession sess, long userId, TaskInstance task) throws ControllerException {
        Learner learner = task.getParticipant(userId);
        if (learner == null) {
            LearnerDAO learnerDao = new LearnerDAO(sess);
            learner = learnerDao.find(userId, task.getLearningSession().getSid());
            if (learner == null) {
                throw new ControllerException("learner not found: user id:" + userId + ", learningSessionId:" + task.getLearningSession().getSid());
            }
            task.participate(learner);
        }
        return learner;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

