/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.service;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSessionException;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.ToolProxy;
import com.webmcq.ld.controller.dao.LearningSessionNotFoundException;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dao.ToolNotFoundException;
import com.webmcq.ld.controller.dto.LearningSessionData;
import com.webmcq.ld.controller.tool.grouping.GroupingContent;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.service.interfaces.LearnerService;
import com.webmcq.ld.service.interfaces.LearnerServiceHome;
import com.webmcq.ld.util.EJBHomeFactory;
import com.webmcq.ld.util.exception.SystemException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import net.sf.hibernate.JDBCException;
import org.apache.log4j.Logger;

public class LearnerServiceDelegate {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$service$LearnerServiceDelegate == null ? (class$com$webmcq$ld$service$LearnerServiceDelegate = LearnerServiceDelegate.class$("com.webmcq.ld.service.LearnerServiceDelegate")) : class$com$webmcq$ld$service$LearnerServiceDelegate));
    static /* synthetic */ Class class$com$webmcq$ld$service$LearnerServiceDelegate;
    static /* synthetic */ Class class$com$webmcq$ld$service$interfaces$LearnerServiceHome;

    public static LearningSessionData[] getLearningSessions(long userId, long classId) throws LearningSessionException, SystemException {
        try {
            LearnerService service = LearnerServiceDelegate.getService();
            LearningSessionData[] data = service.getLearningSessionsLearner(userId);
            LearnerServiceDelegate.remove(service);
            if (classId == 0L) {
                return data;
            }
            ArrayList<LearningSessionData> list = new ArrayList<LearningSessionData>();
            for (int i = 0; i < data.length; ++i) {
                if (data[i].getOrganisationId() != classId) continue;
                list.add(data[i]);
            }
            return list.toArray(new LearningSessionData[0]);
        }
        catch (ControllerException e) {
            throw new LearningSessionException(e);
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
    }

    public static DisplayTaskData join(String username, int sessionId) throws LearningSessionException, SystemException, ControllerException {
        try {
            LearnerService service = LearnerServiceDelegate.getService();
            DisplayTaskData displayTaskData = service.join(username, sessionId);
            LearnerServiceDelegate.remove(service);
            return displayTaskData;
        }
        catch (RemoteException e) {
            throw new SystemException(e);
        }
        catch (UserNotFoundException e) {
            throw new LearningSessionException(e);
        }
        catch (LearningSessionNotFoundException e) {
            throw new LearningSessionException(e);
        }
    }

    public static ToolProxy findToolProxy(String tooltype) throws ToolNotFoundException, ControllerException {
        try {
            LearnerService service = LearnerServiceDelegate.getService();
            ToolProxy toolProxy = service.findToolByType(tooltype);
            LearnerServiceDelegate.remove(service);
            return toolProxy;
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public static DisplayTaskData moveToNextTask(long taskInstanceId, long userId) throws TaskInstanceNotFoundException, ControllerException {
        try {
            LearnerService service = LearnerServiceDelegate.getService();
            Object[] completeTaskObjects = service.completeCurrentTask(taskInstanceId, userId);
            Learner learner = (Learner)completeTaskObjects[0];
            TaskInstance taskInstance = (TaskInstance)completeTaskObjects[1];
            DisplayTaskData displayTaskData = null;
            if (service.hasCompletedCurrentTask(learner, taskInstance)) {
                displayTaskData = service.moveToNextTask(learner, service.getNextTaskInstance(learner));
            }
            LearnerServiceDelegate.remove(service);
            return displayTaskData;
        }
        catch (SystemException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    public static int getProgressStatus(String login, long lsessionId) throws UserNotFoundException {
        LearnerService service = LearnerServiceDelegate.getService();
        try {
            int n = service.getProgressStatus(UserServiceDelegate.findUserId(login), lsessionId);
            return n;
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        finally {
            LearnerServiceDelegate.remove(service);
        }
    }

    public static void handleGroupingContent(long taskInstanceId, GroupingContent content) throws UserNotFoundException, TaskInstanceNotFoundException, ControllerException {
        try {
            LearnerService service = LearnerServiceDelegate.getService();
            service.handleGroupingContent(taskInstanceId, content);
            LearnerServiceDelegate.remove(service);
        }
        catch (JDBCException e) {
            if (e.getErrorCode() == 1062) {
                log.error((Object)"We got duplicates in handling group");
                LearnerServiceDelegate.handleGroupingContent(taskInstanceId, content);
            }
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
    }

    private static LearnerService getService() {
        try {
            LearnerServiceHome home = (LearnerServiceHome)EJBHomeFactory.getInstance().lookup("ejb/service/LearnerService", class$com$webmcq$ld$service$interfaces$LearnerServiceHome == null ? (class$com$webmcq$ld$service$interfaces$LearnerServiceHome = LearnerServiceDelegate.class$("com.webmcq.ld.service.interfaces.LearnerServiceHome")) : class$com$webmcq$ld$service$interfaces$LearnerServiceHome);
            return home.create();
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private static void remove(LearnerService service) {
        try {
            service.remove();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

