/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.chat;

import com.webmcq.ld.tool.chat.interfaces.ChatGroupData;
import com.webmcq.ld.tool.chat.interfaces.ChatGroupPK;
import com.webmcq.ld.tool.chat.interfaces.ChatUserData;
import com.webmcq.ld.tool.chat.interfaces.ChatUserLocal;
import com.webmcq.ld.util.BaseEntityBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.CreateException;

public abstract class ChatGroupBean
extends BaseEntityBean {
    public abstract long getSid();

    public abstract void setSid(long var1);

    public abstract long getSessionId();

    public abstract void setSessionId(long var1);

    public abstract long getTaskGroupId();

    public abstract void setTaskGroupId(long var1);

    public abstract String getTitle();

    public abstract void setTitle(String var1);

    public abstract String getDescription();

    public abstract void setDescription(String var1);

    public abstract String getContent();

    public abstract void setContent(String var1);

    public abstract String getChatServerDNS();

    public abstract void setChatServerDNS(String var1);

    public abstract int getPortNumber();

    public abstract void setPortNumber(int var1);

    public abstract String getChatGroupId();

    public abstract void setChatGroupId(String var1);

    public abstract int getNumOfUsers();

    public abstract void setNumOfUsers(int var1);

    public void setNumOfUsersField() {
        Collection users = this.getUsers();
        int size = users.size();
        this.setNumOfUsers(size);
    }

    public abstract Date getDateCreated();

    public abstract void setDateCreated(Date var1);

    public abstract Date getDateModified();

    public abstract void setDateModified(Date var1);

    public abstract int getIsReusable();

    public abstract void setIsReusable(int var1);

    public abstract Collection getUsers();

    public abstract void setUsers(Collection var1);

    public void addUser(ChatUserLocal user) {
        Collection users = this.getUsers();
        users.add(user);
        Date date = user.getDateCreated();
        this.setDateModified(date);
        this.setNumOfUsersField();
    }

    public void removeUser(ChatUserLocal user) {
        Collection users = this.getUsers();
        users.remove(user);
    }

    public ArrayList getUserList() {
        Collection users = this.getUsers();
        if (users.size() <= 0) {
            return null;
        }
        ArrayList userList = new ArrayList();
        Iterator i = users.iterator();
        while (i.hasNext()) {
            userList.add(i.next());
        }
        return userList;
    }

    public ArrayList getUserDataList() {
        Collection users = this.getUsers();
        if (users.size() <= 0) {
            return null;
        }
        ArrayList<ChatUserData> userDataList = new ArrayList<ChatUserData>();
        Iterator i = users.iterator();
        while (i.hasNext()) {
            ChatUserLocal user = (ChatUserLocal)i.next();
            ChatUserData userData = user.getData();
            userDataList.add(userData);
        }
        return userDataList;
    }

    public ChatGroupPK ejbCreate(long sessionId, String title, String description) throws CreateException {
        long nextId = this.nextId();
        this.setSid(nextId);
        this.setSessionId(sessionId);
        this.setTitle(title);
        this.setDescription(description);
        this.setChatServerDNS(null);
        this.setPortNumber(9800);
        String chatGroupId = "ChatGroup" + nextId;
        this.setChatGroupId(chatGroupId);
        this.setDateCreated(new Date());
        this.setNumOfUsers(0);
        return null;
    }

    public void ejbPostCreate(long sessionId, String title, String description) {
    }

    public abstract ChatGroupData getData();
}

