/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.chat.flashserver;

import com.webmcq.ld.tool.chat.flashserver.ChatDaemonThread;
import com.webmcq.ld.tool.chat.flashserver.ChatRoom;
import com.webmcq.ld.tool.chat.flashserver.ChatUser;
import com.webmcq.ld.tool.chat.flashserver.FlashPacket;
import com.webmcq.ld.tool.chat.flashserver.GroupMember;
import com.webmcq.ld.tool.chat.flashserver.RequestHandler;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class LeaveRequestHandler
extends RequestHandler {
    protected static final Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$chat$flashserver$LeaveRequestHandler == null ? (class$com$webmcq$ld$tool$chat$flashserver$LeaveRequestHandler = LeaveRequestHandler.class$("com.webmcq.ld.tool.chat.flashserver.LeaveRequestHandler")) : class$com$webmcq$ld$tool$chat$flashserver$LeaveRequestHandler));
    static /* synthetic */ Class class$com$webmcq$ld$tool$chat$flashserver$LeaveRequestHandler;

    public LeaveRequestHandler(ChatDaemonThread server) {
        super(server);
    }

    public FlashPacket process(FlashPacket packet, SelectionKey key, SocketChannel socket) {
        log.debug((Object)"LEAVE_REQUEST");
        String chatgroup = packet.getChatroom();
        String roomIdString = packet.getChatroomId();
        String nickname = packet.getFrom();
        String memberIdString = packet.getMemberId();
        long chatRoomId = -1L;
        long memberId = -1L;
        GroupMember member = null;
        ChatRoom chatRoom = null;
        FlashPacket response = null;
        ChatUser user = (ChatUser)key.attachment();
        member = user.findMembership(chatgroup);
        if (member == null) {
            log.error((Object)"  membership not found");
            response = this.membershipNotFoundError(packet);
            log.error((Object)("  response=" + response));
            return response;
        }
        log.debug((Object)("got the member object Nickname:" + member.getNickname()));
        chatRoom = member.getChatRoom();
        if (chatRoom == null) {
            log.error((Object)"  chatroom not attached");
            response = this.roomNotFoundError(packet);
            log.error((Object)("  response=" + response));
            return response;
        }
        log.debug((Object)"got the room object");
        chatRoom.announceMemberLeaving(packet);
        member.setPresence("away");
        chatRoom.savePacket(packet);
        response = this.leaveComplete(packet);
        log.debug((Object)"LEAVE_REQUEST completed");
        return response;
    }

    protected FlashPacket membershipNotFoundError(FlashPacket packet) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("LEAVE_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("ERROR");
        response.setStatusCode("501");
        response.setBodyText("membership record not found");
        return response;
    }

    protected FlashPacket roomNotFoundError(FlashPacket packet) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("LEAVE_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("ERROR");
        response.setStatusCode("502");
        response.setBodyText("membership has no room attatched");
        return response;
    }

    protected FlashPacket leaveComplete(FlashPacket packet) {
        FlashPacket response = new FlashPacket();
        try {
            BeanUtils.copyProperties((Object)response, (Object)packet);
        }
        catch (IllegalAccessException ie) {
            log.error((Object)ie);
        }
        catch (InvocationTargetException ie) {
            log.error((Object)ie);
        }
        response.setType("LEAVE_RESPONSE");
        String to = packet.getFrom();
        response.setTo(to);
        response.setFrom(this.hostName);
        response.setStatus("SUCCESS");
        response.setStatusCode("200");
        return response;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

