/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.jrnl.web;

import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.jrnl.JrnlEntryBean;
import com.webmcq.ld.tool.jrnl.JrnlException;
import com.webmcq.ld.tool.jrnl.interfaces.JrnlEntryData;
import com.webmcq.ld.tool.jrnl.interfaces.JrnlService;
import com.webmcq.ld.tool.jrnl.interfaces.JrnlServiceUtil;
import com.webmcq.ld.util.WDDXProcessor;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.SequencedCollection;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class JournalAction
extends ToolAction {
    public static String JSP_INPUT_ERROR_TAG = "error";
    public static String JSP_INPUT_ENTRY_TAG = "entry";
    public static String JSP_INPUT_ENTRY_SET_TAG = "entrySet";
    public static String JSP_INPUT_SEQUENCE_MAP_TAG = "sequenceMap";
    public static String JSP_OUTPUT_TITLE_TAG = "title";
    public static String JSP_OUTPUT_BODY_TAG = "body";
    public static String JSP_OUTPUT_SCOPE_TAG = "scope";
    public static String JSP_OUTPUT_SAVE_TAG = "save";
    public static String JSP_OUTPUT_SAVE_JOURNAL_TAG = "saveJournal";
    public static String JSP_SEQUENCE_ID_TAG = "sequenceId";
    public static String JSP_SEQUENCE_TITLE_TAG = "sequenceTitle";
    public static String JSP_ENTRY_ID_TAG = "entryId";
    public static String JSP_OUTPUT_USER_TAG = "username";
    public static String JSP_INPUT_LEARNERS_TAG = "learnerList";
    public static String JSP_INPUT_EDIT = "edit";
    public static String JSP_TASK_ID_TAG = "sessionId";
    public static String JSP_OUTPUT_FINISH_TAG = "finish";
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$jrnl$web$JournalAction == null ? (class$com$webmcq$ld$tool$jrnl$web$JournalAction = JournalAction.class$("com.webmcq.ld.tool.jrnl.web.JournalAction")) : class$com$webmcq$ld$tool$jrnl$web$JournalAction));
    static /* synthetic */ Class class$com$webmcq$ld$tool$jrnl$web$JournalAction;

    public ActionForward dispatch(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String mode = WebUtil.readStrParam(req, "mode");
        log.debug((Object)("dispatch journal access mode: " + mode));
        if ("run".equals(mode) || "resume".equals(mode)) {
            return this.getTaskEntryInternal(mapping, form, req, res, true, null, null, this.getUserId(req));
        }
        if ("view".equals(mode)) {
            return this.getTaskEntryInternal(mapping, form, req, res, false, null, null, this.getUserId(req));
        }
        if ("checkup".equals(mode)) {
            long userId = WebUtil.readLongParam(req, "userId");
            return this.getTaskEntryInternal(mapping, form, req, res, false, null, null, userId);
        }
        throw new ServletException("unrecognized access mode: '" + mode + "'");
    }

    private long getUserId(HttpServletRequest req) throws ServletException {
        try {
            String username = WebUtil.getUsername(req);
            return UserServiceDelegate.findUserId(username);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward getHeadings(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        return this.getEntrySetPrivate(mapping, form, req, res, true, null, null);
    }

    public ActionForward getViewAll(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        return this.getEntrySetPrivate(mapping, form, req, res, false, null, null);
    }

    public ActionForward getMonitorViewAll(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            Long sequenceId = this.getLongParam(req, JSP_SEQUENCE_ID_TAG);
            String error = null;
            if (sequenceId == null) {
                error = "Activity sequence id missing. Cannot get journal entries";
            }
            SequencedCollection entryData = null;
            String username = req.getParameter(JSP_OUTPUT_USER_TAG);
            if (username == null) {
                error = error == null ? "Username missing or user cannot be found. Cannot get journal entries" : error + "Username missing or user cannot be found. Cannot get journal entries";
                entryData = new LinkedList();
            } else {
                long userId = UserServiceDelegate.findUserId(username);
                JrnlService service = JrnlServiceUtil.getHome().create();
                entryData = service.getEntriesByUser(userId, sequenceId, JrnlEntryBean.SCOPE_TEACHER);
            }
            this.setParametersEntryListScreens(mapping, req, false, error, sequenceId, entryData);
            return mapping.findForward("learner_journal");
        }
        catch (CreateException e) {
            log.debug((Object)"Exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            log.debug((Object)"Exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward getEntry(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            JrnlService service;
            String error = null;
            JrnlEntryData entry = null;
            Long entryId = this.getLongParam(req, JSP_ENTRY_ID_TAG);
            Long sequenceId = this.getLongParam(req, JSP_SEQUENCE_ID_TAG);
            log.debug((Object)("getEntry entryId=" + entryId + " sequenceId " + sequenceId));
            if (entryId != null && (entry = (service = JrnlServiceUtil.getHome().create()).getEntryBySid(entryId)) == null) {
                log.error((Object)("Unable to find entry, looking for entryId " + entryId));
                error = "Unable to find requested journal entry";
            }
            if (entry == null) {
                entry = new JrnlEntryData();
                entry.setEditable(true);
                entry.setScope(JrnlEntryBean.SCOPE_PRIVATE);
                entry.setSequenceId(sequenceId);
            }
            return mapping.findForward(this.setParametersDetailScreen(req, error, entry, sequenceId));
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward getTaskEntry(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        ActionForward result = this.dispatch(mapping, form, req, res);
        log.debug((Object)("Returning " + result.toString()));
        return result;
    }

    public ActionForward getSequences(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            log.debug((Object)("getSequences userId: " + userId));
            JrnlService service = JrnlServiceUtil.getHome().create();
            SortedMap sequenceData = service.getSequencesByUser(userId, JrnlEntryBean.SCOPE_PRIVATE);
            if (sequenceData != null) {
                req.setAttribute(JSP_INPUT_SEQUENCE_MAP_TAG, (Object)sequenceData);
            } else {
                req.setAttribute(JSP_INPUT_SEQUENCE_MAP_TAG, new TreeMap());
            }
            return mapping.findForward("sequences");
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward getLearners(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            Long sequenceId = this.getLongParam(req, JSP_SEQUENCE_ID_TAG);
            log.debug((Object)("getLearners sequenceId: " + sequenceId));
            JrnlService service = JrnlServiceUtil.getHome().create();
            SortedSet learners = service.getLearners(sequenceId, JrnlEntryBean.SCOPE_TEACHER);
            req.setAttribute(JSP_INPUT_LEARNERS_TAG, (Object)learners);
            String sequenceTitle = req.getParameter(JSP_SEQUENCE_TITLE_TAG);
            if (sequenceTitle == null) {
                sequenceTitle = "Name Missing";
                log.warn((Object)("Sequence title lost from request for journal entry, sequence id=" + sequenceId));
            }
            req.setAttribute(JSP_SEQUENCE_TITLE_TAG, (Object)sequenceTitle);
            if (sequenceId != null) {
                req.setAttribute(JSP_SEQUENCE_ID_TAG, (Object)sequenceId);
            } else {
                req.setAttribute(JSP_SEQUENCE_ID_TAG, (Object)new Long(0L));
            }
            return mapping.findForward("all_learners");
        }
        catch (CreateException e) {
            log.error((Object)"Exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            log.error((Object)"Exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward putTaskEntry(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            JrnlService service = JrnlServiceUtil.getHome().create();
            String error = null;
            if (req.getParameter(JSP_OUTPUT_FINISH_TAG) != null) {
                return this.completeSession(mapping, form, req, res);
            }
            try {
                this.putEntry(req, service, req.getParameter(JSP_OUTPUT_SCOPE_TAG));
            }
            catch (JrnlException e) {
                error = e.getMessage();
            }
            if (error == null && req.getParameter(JSP_OUTPUT_SAVE_JOURNAL_TAG) != null) {
                return this.completeSession(mapping, form, req, res);
            }
            return this.getTaskEntryInternal(mapping, form, req, res, true, service, error, this.getUserId(req));
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward putStandaloneEntry(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            Long sequenceId = this.getLongParam(req, JSP_SEQUENCE_ID_TAG);
            JrnlService service = JrnlServiceUtil.getHome().create();
            String scope = req.getParameter(JSP_OUTPUT_SAVE_JOURNAL_TAG) != null ? JrnlEntryBean.SCOPE_TEACHER : JrnlEntryBean.SCOPE_PRIVATE;
            JrnlEntryData updatedEntry = null;
            try {
                updatedEntry = this.putEntry(req, service, scope);
                return mapping.findForward(this.setParametersDetailScreen(req, null, updatedEntry, sequenceId));
            }
            catch (JrnlException e) {
                if (updatedEntry == null) {
                    updatedEntry = new JrnlEntryData();
                }
                return mapping.findForward(this.setParametersDetailScreen(req, e.getMessage(), updatedEntry, sequenceId));
            }
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward putQuickNoteEntry(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            JrnlService service = JrnlServiceUtil.getHome().create();
            boolean errorOccured = false;
            try {
                this.putEntry(req, service, JrnlEntryBean.SCOPE_PRIVATE);
            }
            catch (JrnlException e) {
                errorOccured = true;
                log.warn((Object)"Journal save returned an error. Unable to show error to user", (Throwable)e);
            }
            res.getWriter().write(errorOccured ? "response=0" : "response=1");
            return null;
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
    }

    public ActionForward completeSession(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            if (WebUtil.isTokenValid(req, "transactionKeyJournal")) {
                WebUtil.resetToken(req, "transactionKeyJournal");
                req.getSession().removeAttribute("transactionDoneJnrl");
                log.debug((Object)"completeSession");
                String param = req.getParameter("sessionId");
                long sessionId = Long.parseLong(param);
                String username = WebUtil.getUsername(req);
                long userId = UserServiceDelegate.findUserId(username);
                JrnlService service = JrnlServiceUtil.getHome().create();
                DisplayTaskData displayTaskData = service.completeSession(userId, sessionId);
                ActionForward action = this.displayTask(displayTaskData, mapping, form, req, res);
                req.getSession().setAttribute("transactionDoneJnrl", (Object)action);
                return action;
            }
            return this.duplicateSubmission(mapping, req, "transactionDoneJnrl");
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (SystemException e) {
            return mapping.findForward("error");
        }
        catch (Exception e) {
            log.error((Object)"General exception occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    private ActionForward getEntrySetPrivate(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res, boolean headingsOnly, JrnlService inputService, String errorsSoFar) throws IOException, ServletException {
        try {
            JrnlService service;
            Long sequenceId = this.getLongParam(req, JSP_SEQUENCE_ID_TAG);
            String username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            log.debug((Object)("getList sequenceId: " + sequenceId));
            if (sequenceId == null) {
                String newError = "Sequence id missing. Cannot get journal entries";
                if (errorsSoFar != null) {
                    newError = newError + "; " + errorsSoFar;
                }
            }
            if ((service = inputService) == null) {
                service = JrnlServiceUtil.getHome().create();
            }
            SortedSet entryData = service.getEntriesByUser(userId, sequenceId, JrnlEntryBean.SCOPE_PRIVATE);
            return mapping.findForward(this.setParametersEntryListScreens(mapping, req, headingsOnly, errorsSoFar, sequenceId, entryData));
        }
        catch (CreateException e) {
            log.debug((Object)"Exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            log.debug((Object)"Exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    private String setParametersEntryListScreens(ActionMapping mapping, HttpServletRequest req, boolean headingsOnly, String errors, Long sequenceId, Collection entryData) {
        String sequenceTitle = req.getParameter(JSP_SEQUENCE_TITLE_TAG);
        if (sequenceTitle == null) {
            sequenceTitle = "Name Missing";
            log.warn((Object)("Sequence title lost from request for journal entry, sequence id=" + sequenceId));
        }
        req.setAttribute(JSP_SEQUENCE_TITLE_TAG, (Object)sequenceTitle);
        if (errors != null) {
            req.setAttribute(JSP_INPUT_ERROR_TAG, (Object)errors);
        }
        if (entryData != null) {
            req.setAttribute(JSP_INPUT_ENTRY_SET_TAG, (Object)entryData);
        }
        if (sequenceId != null) {
            req.setAttribute(JSP_SEQUENCE_ID_TAG, (Object)sequenceId);
        } else {
            req.setAttribute(JSP_SEQUENCE_ID_TAG, (Object)new Long(0L));
        }
        if (headingsOnly) {
            return "headings";
        }
        return "view_all";
    }

    private ActionForward getTaskEntryInternal(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res, boolean editMode, JrnlService inputService, String errorsSoFar, long userId) throws IOException, ServletException {
        try {
            log.debug((Object)"getTaskEntryInternal");
            String error = errorsSoFar;
            JrnlEntryData entry = null;
            Long taskId = this.getLongParam(req, JSP_TASK_ID_TAG);
            if (taskId == null) {
                String newError = "Task Instance id missing. Cannot get journal entry";
                if (error != null) {
                    error = error + "; " + newError;
                }
            } else {
                JrnlService service = inputService;
                if (service == null) {
                    service = JrnlServiceUtil.getHome().create();
                }
                if ((entry = service.getEntryByUserTask(userId, taskId)) == null) {
                    entry = service.createNewTaskEntry(userId, taskId);
                }
            }
            String sequenceTitle = req.getParameter(JSP_SEQUENCE_TITLE_TAG);
            if (sequenceTitle == null) {
                sequenceTitle = "Name Missing";
                log.warn((Object)("Sequence title lost from request for journal entry, task id=" + taskId));
            }
            req.setAttribute(JSP_SEQUENCE_TITLE_TAG, (Object)sequenceTitle);
            if (error != null) {
                req.setAttribute(JSP_INPUT_ERROR_TAG, (Object)error);
            }
            if (entry != null) {
                req.setAttribute(JSP_INPUT_ENTRY_TAG, (Object)entry);
                req.setAttribute(JSP_SEQUENCE_ID_TAG, (Object)entry.getSequenceId());
            } else {
                req.setAttribute(JSP_SEQUENCE_ID_TAG, (Object)new Long(0L));
            }
            req.setAttribute(JSP_INPUT_EDIT, (Object)new Boolean(editMode));
            log.debug((Object)("Entry is " + (entry != null ? entry.toString() : "null")));
            WebUtil.saveToken(req, "transactionKeyJournal", this.generateToken(req));
            return mapping.findForward("entry_as_task");
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    private String setParametersDetailScreen(HttpServletRequest req, String error, JrnlEntryData entry, Long sequenceId) {
        String sequenceTitle = req.getParameter(JSP_SEQUENCE_TITLE_TAG);
        if (sequenceTitle == null) {
            sequenceTitle = "Name Missing";
            log.warn((Object)("Sequence title lost from request for journal entry, sequence id=" + sequenceId));
        }
        req.setAttribute(JSP_SEQUENCE_TITLE_TAG, (Object)sequenceTitle);
        if (entry != null) {
            req.setAttribute(JSP_INPUT_ENTRY_TAG, (Object)entry);
        }
        if (error != null) {
            req.setAttribute(JSP_INPUT_ERROR_TAG, (Object)error);
        }
        if (sequenceId != null) {
            req.setAttribute(JSP_SEQUENCE_ID_TAG, (Object)sequenceId);
        } else {
            req.setAttribute(JSP_SEQUENCE_ID_TAG, (Object)new Long(0L));
        }
        return "detail";
    }

    private JrnlEntryData putEntry(HttpServletRequest req, JrnlService service, String scope) throws IOException, ServletException, JrnlException {
        try {
            Long entryId = this.getLongParam(req, JSP_ENTRY_ID_TAG);
            Long taskId = this.getLongParam(req, JSP_TASK_ID_TAG);
            String username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            Long sequenceId = this.getLongParam(req, JSP_SEQUENCE_ID_TAG);
            if (log.isDebugEnabled()) {
                log.debug((Object)("putEntry entry sid: " + entryId + " task id: " + taskId + " userid: " + userId + " sequenceId: " + sequenceId));
            }
            String title = req.getParameter(JSP_OUTPUT_TITLE_TAG);
            String body = StringUtils.trim((String)req.getParameter(JSP_OUTPUT_BODY_TAG));
            body = WDDXProcessor.replaceNewline(body);
            log.debug((Object)("putEntry body is " + body));
            String localScope = scope;
            if (localScope == null) {
                localScope = req.getParameter(JSP_OUTPUT_SCOPE_TAG);
            }
            if (body == null || body.length() == 0) {
                throw new JrnlException("Invalid entry - please enter some text as the body of the entry");
            }
            if (service == null) {
                // empty if block
            }
            service = JrnlServiceUtil.getHome().create();
            JrnlEntryData updatedEntry = service.putEntry(entryId, userId, sequenceId, taskId, title, body, localScope);
            return updatedEntry;
        }
        catch (CreateException e) {
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            throw new ServletException(e.getMessage());
        }
        catch (JrnlException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"General exception occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    private Long getLongParam(HttpServletRequest req, String parameterName) {
        Long retValue = null;
        String stringValue = req.getParameter(parameterName);
        if (stringValue != null) {
            try {
                retValue = new Long(stringValue);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return retValue;
    }

    public ActionForward getAllJournalEntries(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            Long sequenceId = this.getLongParam(req, JSP_SEQUENCE_ID_TAG);
            JrnlService service = JrnlServiceUtil.getHome().create();
            TreeMap entryData = service.getAllJournalEntries(sequenceId);
            req.setAttribute(JSP_SEQUENCE_ID_TAG, (Object)sequenceId);
            String sequenceTitle = req.getParameter(JSP_SEQUENCE_TITLE_TAG);
            if (sequenceTitle == null) {
                sequenceTitle = "Name Missing";
                log.warn((Object)("Sequence title lost from request for journal entry, sequence id=" + sequenceId));
            }
            req.setAttribute(JSP_SEQUENCE_TITLE_TAG, (Object)sequenceTitle);
            req.getSession().setAttribute(JSP_INPUT_ENTRY_SET_TAG, (Object)entryData);
            return mapping.findForward("all_entries");
        }
        catch (CreateException e) {
            log.debug((Object)"Exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (NamingException e) {
            log.debug((Object)"Exception thrown", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"General exception occured ", (Throwable)e);
            throw new ServletException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

