/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.reportsubmission;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.ConfigurationServiceDelegate;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.reportsubmission.ReportSubmissionException;
import com.webmcq.ld.tool.reportsubmission.UserSummaryData;
import com.webmcq.ld.tool.reportsubmission.interfaces.LearnerReportData;
import com.webmcq.ld.tool.reportsubmission.interfaces.LearnerReportLocal;
import com.webmcq.ld.tool.reportsubmission.interfaces.LearnerReportUtil;
import com.webmcq.ld.tool.reportsubmission.interfaces.ReportReviewLocal;
import com.webmcq.ld.tool.reportsubmission.interfaces.ReportReviewUtil;
import com.webmcq.ld.tool.reportsubmission.interfaces.SubmissionInfoData;
import com.webmcq.ld.tool.reportsubmission.interfaces.SubmissionInfoLocal;
import com.webmcq.ld.tool.reportsubmission.interfaces.SubmissionInfoUtil;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.EJBUtil;
import com.webmcq.ld.util.SendEmail;
import com.webmcq.ld.util.exception.SystemException;
import java.io.File;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class ReportSubmissionServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$reportsubmission$ReportSubmissionServiceBean == null ? (class$com$webmcq$ld$tool$reportsubmission$ReportSubmissionServiceBean = ReportSubmissionServiceBean.class$("com.webmcq.ld.tool.reportsubmission.ReportSubmissionServiceBean")) : class$com$webmcq$ld$tool$reportsubmission$ReportSubmissionServiceBean));
    transient SubmissionInfoLocal m_info = null;
    static /* synthetic */ Class class$com$webmcq$ld$tool$reportsubmission$ReportSubmissionServiceBean;

    public void ejbCreate() throws CreateException {
    }

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            Content content = null;
            if (inputContentId != null) {
                content = ContentServiceDelegate.getContent(inputContentId);
            }
            long sessionOwnerUserId = taskInstance.getOwnerId();
            this.createSession((SimpleTaskVO)task, taskInstance, group, outputContentId, content, sessionOwnerUserId);
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ToolException(e);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw new SystemException(e);
        }
    }

    private void createSession(SimpleTaskVO task, TaskInstanceData instance, GroupData group, Long outputContentId, Content content, long ownerUserId) {
        try {
            Collection entries = SubmissionInfoUtil.getLocalHome().findByTaskInstanceId((int)instance.getSid());
            SubmissionInfoLocal entry = (SubmissionInfoLocal)EJBUtil.findSingle(entries);
            if (entry != null) {
                log.warn((Object)("Session for task instance " + instance.toString() + " already exists. Not creating a new set of submission data."));
            } else {
                entry = SubmissionInfoUtil.getLocalHome().create();
                entry.setTaskInstanceId(instance.getSid());
                entry.setOutputContentId(outputContentId);
                String sessionOwnerEmailAddress = this.getEmailAddress(ownerUserId);
                entry.setAddress(sessionOwnerEmailAddress);
                entry.setReceiverId(new Long(ownerUserId));
                if (content != null) {
                    entry.setBody(content.getBody());
                    entry.setDescription(content.getDescription());
                    entry.setTitle(content.getTitle());
                } else {
                    entry.setBody("");
                    entry.setDescription("");
                    entry.setTitle("Upload File");
                }
                this.setupDirectories(instance.getSid(), entry);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Created LearnerReport with task instance id" + entry.getTaskInstanceId() + " info object is " + entry.getData().toString()));
                }
            }
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public String getEmailAddress(long userId) {
        try {
            UserData user = UserServiceDelegate.findCompleteUser(userId);
            return user.getEmail();
        }
        catch (UserNotFoundException e) {
            return null;
        }
    }

    private void setupEJBS(int taskInstanceId) {
        if (this.m_info == null || this.m_info.getTaskInstanceId() != (long)taskInstanceId) {
            this.m_info = this.findSingleInfo(taskInstanceId);
        }
    }

    private SubmissionInfoLocal findSingleInfo(int taskInstanceId) {
        Collection entries = null;
        SubmissionInfoLocal entry = null;
        try {
            entries = SubmissionInfoUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            entry = (SubmissionInfoLocal)EJBUtil.findSingle(entries);
        }
        catch (FinderException e) {
            log.warn((Object)("Error occured setting up submission information ejb - ejb not found. Returning null. Task instance " + taskInstanceId), (Throwable)e);
            entry = null;
        }
        catch (NamingException e) {
            log.error((Object)("Error occured setting up submission information ejb. Task instance " + taskInstanceId), (Throwable)e);
            throw new EJBException((Exception)e);
        }
        return entry;
    }

    private SubmissionInfoLocal getInfo() {
        return this.m_info;
    }

    public SubmissionInfoData getInfoByTaskInstance(int taskInstanceId) {
        this.setupEJBS(taskInstanceId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning " + (this.getInfo() != null ? this.getInfo().getData().toString() : "null")));
        }
        return this.getInfo() != null ? this.getInfo().getData() : null;
    }

    public Long getNextFileNumber(int taskInstanceId) throws ReportSubmissionException {
        this.setupEJBS(taskInstanceId);
        return this.getInfo() != null ? new Long(this.getInfo().getFileSequenceNumber()) : null;
    }

    public String createReportItem(int taskInstanceId, long userId, String username, String description, String originalFilename, String filename, String filenameNoPath) throws ReportSubmissionException {
        LearnerReportData reportEntry = null;
        String errorMessage = null;
        try {
            this.setupEJBS(taskInstanceId);
            SubmissionInfoLocal infoEntry = this.getInfo();
            reportEntry = this.createDatabaseEntry(userId, description, originalFilename, filename, filenameNoPath, infoEntry);
            if (reportEntry != null) {
                if (!this.sendSubmissionEmail(username, userId, reportEntry, infoEntry)) {
                    errorMessage = "Unable to send file via email. Report not submitted. ";
                } else {
                    this.setFileEmailed(reportEntry.getSid(), infoEntry.getReceiverId());
                }
            }
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        return errorMessage;
    }

    private LearnerReportData createDatabaseEntry(long userId, String description, String originalFilename, String filename, String filenameNoPath, SubmissionInfoLocal infoEntry) throws CreateException, NamingException, ReportSubmissionException {
        if (infoEntry != null) {
            LearnerReportLocal reportEntry = LearnerReportUtil.getLocalHome().create();
            reportEntry.setDateSubmitted(new Date());
            reportEntry.setSubmitterUserId(new Long(userId));
            reportEntry.setTaskInstanceId(infoEntry.getTaskInstanceId());
            reportEntry.setOriginalFilename(originalFilename);
            reportEntry.setFilename(filename);
            reportEntry.setFilenameNoPath(filenameNoPath);
            reportEntry.setFileDescription(description);
            ReportReviewLocal reportReview = ReportReviewUtil.getLocalHome().create();
            reportReview.setTaskInstanceId(infoEntry.getTaskInstanceId());
            reportReview.setReportSent(false);
            reportReview.setReviewerUserId(infoEntry.getReceiverId());
            reportReview.setAddress(infoEntry.getAddress());
            reportEntry.addReview(reportReview);
            return reportEntry.getData();
        }
        log.error((Object)("Unable to create report record as general information record is missing. Task instance id=" + infoEntry.getTaskInstanceId() + " userId=" + userId + " description " + description + " originalFilename " + originalFilename));
        throw new ReportSubmissionException("Unable to create report record as general information record is missing");
    }

    private boolean sendSubmissionEmail(String username, long userId, LearnerReportData reportEntry, SubmissionInfoLocal info) throws CreateException, NamingException, ReportSubmissionException {
        boolean sent = false;
        if (info.getAddress() != null && info.getAddress().length() != 0) {
            String submittersEmailAddress = this.getEmailAddress(userId);
            boolean emailed = this.emailFile(info.getAddress(), submittersEmailAddress, username, reportEntry);
            if (!emailed) {
                String message = "Unable to send uploaded file " + reportEntry.getFilename() + " for user " + username + " email sender reported error occured.";
                log.error((Object)(message + " taskInstanceId=" + info.getTaskInstanceId()));
            } else {
                sent = true;
            }
        } else {
            String message = "Unable to send uploaded file " + reportEntry.getFilename() + " for user " + username + " as email address of receiver is missing.";
            log.error((Object)(message + " taskInstanceId=" + info.getTaskInstanceId() + " info=" + info.toString()));
        }
        return sent;
    }

    private boolean emailFile(String toEmailAddress, String submitterEmailAddress, String submitterUsername, LearnerReportData reportData) {
        long taskInstanceId = reportData.getTaskInstanceId();
        String description = reportData.getFileDescription();
        String filename = reportData.getFilename();
        String shortfilename = reportData.getFilenameNoPath();
        String[] mailParameters = submitterEmailAddress != null ? new String[5] : new String[4];
        String[] attachment = new String[3];
        mailParameters[0] = toEmailAddress;
        mailParameters[1] = null;
        mailParameters[2] = "Report submitted by " + submitterUsername;
        if (submitterEmailAddress != null) {
            mailParameters[4] = submitterEmailAddress;
        }
        StringBuffer mailBody = new StringBuffer(400);
        mailBody.append("The attached file '");
        mailBody.append(shortfilename);
        mailBody.append("' was submitted by ");
        mailBody.append(submitterUsername);
        mailBody.append(". The description of the file given by ");
        mailBody.append(submitterUsername);
        mailBody.append(" was: '");
        mailBody.append(description);
        mailBody.append("'. Report was submitted ");
        Date dateSubmitted = reportData.getDateSubmitted();
        mailBody.append(DateFormat.getDateTimeInstance(1, 1).format(dateSubmitted));
        mailParameters[3] = mailBody.toString();
        attachment[0] = filename;
        attachment[1] = shortfilename;
        attachment[2] = description;
        LinkedList<String[]> attachmentList = new LinkedList<String[]>();
        attachmentList.add(attachment);
        SendEmail emailSender = new SendEmail();
        String result = emailSender.sendemail(mailParameters, attachmentList);
        return result.equals("1");
    }

    public void setFileEmailed(int reportSid, long recipientUserId) {
        try {
            Collection entries = LearnerReportUtil.getLocalHome().findBySid(reportSid);
            LearnerReportLocal entry = (LearnerReportLocal)EJBUtil.findSingle(entries);
            if (entry != null) {
                entry.setReviewSent(recipientUserId);
            }
        }
        catch (FinderException e) {
            log.error((Object)("Trying to set report as sent but no report record exists - reportSid = " + reportSid));
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public SortedMap getUploadedFileInfoByTaskInstance(int taskInstanceId) {
        try {
            Collection entries = LearnerReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            return this.convertToDataEntries(entries);
        }
        catch (FinderException e) {
            return null;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public SortedMap getUploadedFileInfoByTaskInstanceLearner(int taskInstanceId, long userId) {
        try {
            Collection entries = LearnerReportUtil.getLocalHome().findByTaskInstanceIdLearner(taskInstanceId, userId);
            return this.convertToDataEntries(entries);
        }
        catch (FinderException e) {
            return null;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public Map getLearnerNameData(int taskInstanceId) {
        try {
            Collection entries = LearnerReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            if (entries != null) {
                HashMap<Long, UserSummaryData> userMap = new HashMap<Long, UserSummaryData>();
                Iterator iter = entries.iterator();
                while (iter.hasNext()) {
                    LearnerReportLocal report = (LearnerReportLocal)iter.next();
                    boolean needsMarking = report.needsMarking();
                    Long userId = report.getSubmitterUserId();
                    if (userId != null && !userMap.containsKey(userId)) {
                        ShwaaUserData user = UserServiceDelegate.find(userId);
                        UserSummaryData userData = new UserSummaryData(user.getUid(), user.getLogin(), user.getFirstName(), user.getLastName(), needsMarking);
                        userMap.put(userId, userData);
                        continue;
                    }
                    if (!needsMarking) continue;
                    UserSummaryData userData = (UserSummaryData)userMap.get(userId);
                    userData.setReportsNeedMarking(true);
                }
                return userMap;
            }
        }
        catch (UserNotFoundException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            return null;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        return null;
    }

    public Map getSingleLearnerNameData(int taskInstanceId, Long userId) throws UserNotFoundException {
        if (userId != null) {
            HashMap<Long, UserSummaryData> userMap = new HashMap<Long, UserSummaryData>();
            ShwaaUserData user = UserServiceDelegate.find(userId);
            boolean needsMarking = false;
            try {
                Collection entries = LearnerReportUtil.getLocalHome().findByTaskInstanceIdLearner(taskInstanceId, userId);
                Iterator iter = entries.iterator();
                while (iter.hasNext() && !needsMarking) {
                    LearnerReportLocal report = (LearnerReportLocal)iter.next();
                    needsMarking = report.needsMarking();
                }
            }
            catch (FinderException e) {
            }
            catch (NamingException e) {
                throw new EJBException((Exception)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            UserSummaryData userData = new UserSummaryData(user.getUid(), user.getLogin(), user.getFirstName(), user.getLastName(), needsMarking);
            userMap.put(userId, userData);
            return userMap;
        }
        return null;
    }

    public SortedMap getUploadedFileInfoByReportSid(int reportSid) {
        try {
            Collection entries = LearnerReportUtil.getLocalHome().findBySid(reportSid);
            return this.convertToDataEntries(entries);
        }
        catch (FinderException e) {
            return null;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public DisplayTaskData completeSession(long userId, int taskInstanceId) throws ReportSubmissionException {
        DisplayTaskData displayTaskData = null;
        this.setupEJBS(taskInstanceId);
        if (this.getInfo() == null) {
            throw new ReportSubmissionException("no such session found");
        }
        try {
            displayTaskData = LearnerServiceDelegate.moveToNextTask(taskInstanceId, userId);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (TaskInstanceNotFoundException e) {
            throw new ReportSubmissionException("Task Instance not found", e);
        }
        catch (ControllerException e) {
            throw new ReportSubmissionException("Controller reported an error", e);
        }
        return displayTaskData;
    }

    private SortedMap convertToDataEntries(Collection entries) {
        if (entries != null) {
            TreeMap<Integer, Object[]> results = new TreeMap<Integer, Object[]>();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Object[] entry = new Object[3];
                LearnerReportLocal report = (LearnerReportLocal)iter.next();
                entry[0] = report.getData();
                entry[1] = report.getReviewData();
                results.put(new Integer(report.getSid()), entry);
            }
            return results;
        }
        return null;
    }

    private void setupDirectories(long taskInstanceId, SubmissionInfoLocal entry) {
        String homeDirectory = ConfigurationServiceDelegate.get(ConfigurationKeys.LAMS_HOME);
        if (homeDirectory == null) {
            throw new RuntimeException("No home directory set up for LAMS. Unable to do report submission. Session id=" + taskInstanceId);
        }
        entry.setTempDirName(null);
        File finalUploadDir = new File(homeDirectory, "reports");
        finalUploadDir = new File(finalUploadDir.getPath(), "task" + Long.toString(taskInstanceId));
        entry.setFinalDirName(finalUploadDir.getPath());
        this.checkMakeDirectory(finalUploadDir, "Creating new directory for uploaded files for taskInstance " + taskInstanceId + ": ");
    }

    private void checkMakeDirectory(File directory, String logMessage) {
        if (!directory.exists()) {
            log.info((Object)(logMessage + directory));
            boolean created = directory.mkdirs();
            if (!created) {
                log.error((Object)("Unable to create directory " + directory.toString()));
                throw new RuntimeException("Unable to create directory " + directory.toString());
            }
        }
        if (!directory.canWrite()) {
            log.error((Object)("Unable to write to directory " + directory.toString()));
            throw new RuntimeException("Unable to write to directory " + directory.toString());
        }
    }

    public void markReport(int taskInstanceId, int reportSid, long markerUserId, String mark, String comment, String responseFilename) throws ReportSubmissionException {
        try {
            this.setupEJBS(taskInstanceId);
            if (this.getInfo() == null) {
                throw new ReportSubmissionException("no such session found");
            }
            Collection entries = LearnerReportUtil.getLocalHome().findBySid(reportSid);
            LearnerReportLocal entry = (LearnerReportLocal)EJBUtil.findSingle(entries);
            if (entry == null) {
                throw new ReportSubmissionException("No such report found");
            }
            ReportReviewLocal review = entry.setReviewMarks(markerUserId, mark, comment, responseFilename);
            if (review.getDateMarkReleased() != null && entry.getSubmitterUserId() != null) {
                this.sendMarkEmail(entry.getSubmitterUserId(), this.getInfo().getTitle(), entry.getFilenameNoPath(), review, true);
            }
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public boolean releaseAllMarks(int taskInstanceId) throws ReportSubmissionException {
        boolean emailSentOkay = true;
        try {
            this.setupEJBS(taskInstanceId);
            if (this.getInfo() == null) {
                throw new ReportSubmissionException("no such session found");
            }
            Collection entries = LearnerReportUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            if (entries == null) {
                log.warn((Object)("Releasing marks for reports with taskInstanceId=" + taskInstanceId + " not such reports exist"));
            }
            if (entries != null) {
                Iterator iter = entries.iterator();
                while (iter.hasNext()) {
                    LearnerReportLocal report = (LearnerReportLocal)iter.next();
                    Collection reviews = report.getReviews();
                    Iterator iter2 = reviews.iterator();
                    while (iter2.hasNext()) {
                        boolean sent;
                        ReportReviewLocal review = (ReportReviewLocal)iter2.next();
                        boolean isNewRelease = review.releaseMark();
                        if (!isNewRelease || report.getSubmitterUserId() == null || (sent = this.sendMarkEmail(report.getSubmitterUserId(), this.getInfo().getTitle(), report.getFilenameNoPath(), review, false))) continue;
                        emailSentOkay = false;
                    }
                }
            }
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        return emailSentOkay;
    }

    private boolean sendMarkEmail(long userId, String taskTitle, String filename, ReportReviewLocal review, boolean isUpdate) {
        String emailAddress = this.getEmailAddress(userId);
        if (emailAddress == null) {
            log.error((Object)("Unable to send marks email to learner - no email address exists. User Id=" + userId + " task title=" + taskTitle + " filename=" + filename));
            return false;
        }
        String[] mailParameters = new String[4];
        mailParameters[0] = emailAddress;
        mailParameters[1] = null;
        mailParameters[2] = "Report for " + taskTitle + (isUpdate ? " altered" : " marked");
        StringBuffer mailBody = new StringBuffer(400);
        if (isUpdate) {
            mailBody.append("The mark/comments for the report, submitted to marker as '");
            mailBody.append(filename);
            mailBody.append("' have been changed.\n\nThe new mark is: ");
        } else {
            mailBody.append("The report, submitted to marker as '");
            mailBody.append(filename);
            mailBody.append("' has been marked.\n\nThe mark is: ");
        }
        mailBody.append(review.getMark());
        mailBody.append("\n\nThe marker commented:\n");
        mailBody.append(review.getReviewersComment());
        mailParameters[3] = mailBody.toString();
        SendEmail emailSender = new SendEmail();
        String result = emailSender.sendemail(mailParameters, null);
        return result.equals("1");
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

