/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.survey.web;

import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.tool.survey.ISurveyService;
import com.webmcq.ld.tool.survey.SurveyManager;
import com.webmcq.ld.tool.survey.entity.SurQuestionVO;
import com.webmcq.ld.tool.survey.entity.SurSurveyVO;
import com.webmcq.ld.tool.survey.web.ReportForm;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class ReportAction
extends ToolAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$survey$web$ReportAction == null ? (class$com$webmcq$ld$tool$survey$web$ReportAction = ReportAction.class$("com.webmcq.ld.tool.survey.web.ReportAction")) : class$com$webmcq$ld$tool$survey$web$ReportAction));
    private static final String VIEW_REPORT = "view";
    private static final String VIEW_EMPTY_REPORT = "empty";
    private static final String VIEW_QUESTION = "question";
    private static final String VIEW_CHART = "viewchart";
    private static final String PARAM_MODE = "mode";
    private static final String PARAM_CHART_TYPE = "chartType";
    private static final String ATTR_MODE = "mode";
    private static final String PARAM_QUESTION_ID = "questionId";
    private static final String REPORT_NAME = "lams_survey";
    private static final String ATTR_CHART_TYPE = "chartType";
    private static final String ATTR_QUESTION = "question";
    static /* synthetic */ Class class$com$webmcq$ld$tool$survey$web$ReportAction;

    public ActionForward loadMonitorReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        int totalNumberofUserResponsed;
        SurSurveyVO survey;
        long lsessionId;
        ReportForm reportForm = (ReportForm)form;
        ISurveyService surveyService = SurveyManager.getSurveyService(request);
        String mode = WebUtil.readStrParam(request, "mode");
        if (reportForm != null) {
            long taskinstanceId = (Long)reportForm.get("sessionId");
            request.setAttribute("sessionId", (Object)new Long(taskinstanceId));
            lsessionId = WebUtil.retrieveLearningSessionIdFromSession(request, mode);
            survey = surveyService.retrieveSurvey(taskinstanceId);
            totalNumberofUserResponsed = surveyService.countTotalNumberOfUserResponsed(survey);
            if (totalNumberofUserResponsed == 0) {
                return mapping.findForward(VIEW_EMPTY_REPORT);
            }
        } else {
            log.error((Object)"Fail to load the survey report for monitor!");
            throw new SystemException("Fail to load the survey report for monitor!");
        }
        LearningSession curLession = surveyService.getCurrentLearningSession(lsessionId);
        int surveyClassSize = surveyService.getSurveyClassSize(curLession.getOrganisationId(), WebUtil.getUsername(request));
        reportForm.buildReportForm(request, survey, curLession, surveyClassSize, totalNumberofUserResponsed);
        request.getSession().setAttribute("ReportForm", (Object)reportForm);
        request.getSession().setAttribute("mode", (Object)mode);
        return mapping.findForward(VIEW_REPORT);
    }

    public ActionForward loadQuestionReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String questionId = WebUtil.readStrParam(request, PARAM_QUESTION_ID);
        ReportForm reportForm = (ReportForm)form;
        SurQuestionVO curQuestion = reportForm.getQuestionFromSurvey(questionId);
        request.getSession().setAttribute("question", (Object)curQuestion);
        return mapping.findForward("question");
    }

    public ActionForward exportReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ReportForm reportForm = (ReportForm)form;
        response.setContentType("application/vnd.ms-excel");
        PrintWriter out = response.getWriter();
        out.print(reportForm.buildXLSReport());
        response.setHeader("Content-disposition", "attachment;filename=lams_survey.xls");
        return null;
    }

    public ActionForward viewChart(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String chartType = WebUtil.readStrParam(request, "chartType");
        String questionId = WebUtil.readStrParam(request, PARAM_QUESTION_ID);
        ReportForm reportForm = (ReportForm)form;
        SurQuestionVO curQuestion = reportForm.getQuestionFromSurvey(questionId);
        request.getSession().setAttribute("question", (Object)curQuestion);
        request.setAttribute("chartType", (Object)chartType);
        return mapping.findForward(VIEW_CHART);
    }

    public ActionForward loadChartPic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        SurQuestionVO question = (SurQuestionVO)request.getSession().getAttribute("question");
        String chartType = WebUtil.readStrParam(request, "chartType");
        ServletOutputStream out = response.getOutputStream();
        JFreeChart chart = null;
        if (chartType.equals("piechart")) {
            chart = question.createPieChart();
        } else if (chartType.equals("columnchart")) {
            chart = question.createColumnChart();
        }
        if (chart != null) {
            response.setContentType("image/png");
            ChartUtilities.writeChartAsPNG((OutputStream)out, (JFreeChart)chart, (int)400, (int)300);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

