/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.urlcontent.dto;

import com.webmcq.ld.tool.urlcontent.URLContentException;
import com.webmcq.ld.tool.urlcontent.dto.URLData;
import com.webmcq.ld.tool.urlcontent.dto.URLDataComparator;
import com.webmcq.ld.tool.urlcontent.interfaces.URLContentData;
import com.webmcq.ld.tool.urlcontent.interfaces.URLEntryInstructionLocal;
import com.webmcq.ld.tool.urlcontent.interfaces.URLEntryLocal;
import com.webmcq.ld.tool.urlcontent.interfaces.URLLearnerLocal;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class URLContentDTOFactory {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$urlcontent$dto$URLContentDTOFactory == null ? (class$com$webmcq$ld$tool$urlcontent$dto$URLContentDTOFactory = URLContentDTOFactory.class$("com.webmcq.ld.tool.urlcontent.dto.URLContentDTOFactory")) : class$com$webmcq$ld$tool$urlcontent$dto$URLContentDTOFactory));
    static /* synthetic */ Class class$com$webmcq$ld$tool$urlcontent$dto$URLContentDTOFactory;

    public static SortedSet createLearnerEntriesSet(Collection urlEntries, URLLearnerLocal learner) throws URLContentException {
        log.debug((Object)"Converting entries to data");
        TreeSet<URLData> items = new TreeSet<URLData>(new URLDataComparator());
        if (urlEntries == null) {
            return items;
        }
        Iterator iter = urlEntries.iterator();
        while (iter.hasNext()) {
            URLEntryLocal urlEntry = (URLEntryLocal)iter.next();
            boolean isDone = learner != null ? learner.isEntryDone(urlEntry.getSid()) : false;
            items.add(URLContentDTOFactory.createURLData(urlEntry, isDone, 0));
        }
        log.debug((Object)("Returning items " + items.toString()));
        return items;
    }

    private static boolean isDone(Integer[] sids, int intCheckSid) {
        Integer checkSid = new Integer(intCheckSid);
        if (sids != null) {
            for (int i = 0; i < sids.length; ++i) {
                if (!checkSid.equals(sids[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static URLData createURLData(URLEntryLocal entryBean, boolean done, int instructionNumber) throws URLContentException {
        URLEntryInstructionLocal requestedInstruction = null;
        URLEntryInstructionLocal possibleInstruction = null;
        log.debug((Object)("instructions " + entryBean.getInstructions()));
        Iterator iter = entryBean.getInstructions().iterator();
        while (requestedInstruction == null && iter.hasNext()) {
            log.debug((Object)"in loop");
            URLEntryInstructionLocal element = (URLEntryInstructionLocal)iter.next();
            if (element.getOrderIndex() == instructionNumber) {
                requestedInstruction = element;
                continue;
            }
            if (element.getOrderIndex() <= instructionNumber || possibleInstruction != null && element.getOrderIndex() >= possibleInstruction.getOrderIndex()) continue;
            possibleInstruction = element;
        }
        if (requestedInstruction == null) {
            requestedInstruction = possibleInstruction;
        }
        log.debug((Object)("requestedInstruction" + requestedInstruction));
        if (log.isDebugEnabled()) {
            log.debug((Object)("asked for instruction " + instructionNumber));
            if (requestedInstruction != null) {
                log.debug((Object)(" got instruction " + requestedInstruction.getData().toString()));
            } else {
                log.debug((Object)" got instruction none");
            }
        }
        URLData data = new URLData(entryBean.getSid(), entryBean.getURL(), entryBean.getTitle(), done, entryBean.getOrderIndex(), requestedInstruction != null ? requestedInstruction.getData() : null, entryBean.getMaxOrderIndex(), entryBean.getContributerUsername(), entryBean.getPreferDownload());
        log.debug((Object)("New Entry is" + data.toString()));
        return data;
    }

    public static URLData createDummyURLData(int entryId) {
        return new URLData(entryId, "", "Data Missing", true, 0, null, -1, "", true);
    }

    public static URLContentData createDummyURLContentData(int taskInstanceId) {
        return new URLContentData(-1, taskInstanceId, "unknown", "Data Missing", "Data Missing", false, false, false, false, 0, new Boolean(false));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

