/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.voterank.dto;

import com.webmcq.ld.tool.voterank.interfaces.PollContentData;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PollContentNominationResultsData
implements Serializable {
    static final long serialVersionUID = 8688331907000168601L;
    public static String RESULTS_NONE = "No results set up";
    public static String RESULTS_INDIVIDUAL = "Individual Voter";
    public static String RESULTS_SUMMARY = "Summary Results";
    protected Collection nominees;
    protected Collection results;
    protected String resultsDescription;
    protected PollContentData pollInfo;

    public PollContentNominationResultsData() {
        this.resultsDescription = RESULTS_NONE;
    }

    public PollContentNominationResultsData(PollContentData contentData, Collection nominees, Collection results, boolean summaryResults) {
        this.pollInfo = contentData;
        this.nominees = nominees;
        this.setResults(results, summaryResults);
    }

    public PollContentNominationResultsData(PollContentNominationResultsData otherData) {
        this.pollInfo = otherData.pollInfo;
        this.nominees = otherData.nominees;
        this.results = otherData.results;
        this.resultsDescription = otherData.resultsDescription;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object pOther) {
        if (pOther instanceof PollContentNominationResultsData) {
            PollContentNominationResultsData lTest = (PollContentNominationResultsData)pOther;
            boolean lEquals = true;
            if (this.pollInfo == null) {
                lEquals = lEquals && lTest.pollInfo == null;
            } else {
                boolean bl = lEquals = lEquals && this.pollInfo.equals(lTest.pollInfo);
            }
            if (this.nominees == null) {
                lEquals = lEquals && lTest.nominees == null;
            } else {
                boolean bl = lEquals = lEquals && ((Object)this.nominees).equals(lTest.nominees);
            }
            if (this.results == null) {
                lEquals = lEquals && lTest.results == null;
            } else {
                boolean bl = lEquals = lEquals && ((Object)this.results).equals(lTest.results);
            }
            lEquals = this.resultsDescription == null ? lEquals && lTest.resultsDescription == null : lEquals && this.resultsDescription.equals(lTest.resultsDescription);
            return lEquals;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + (this.nominees != null ? ((Object)this.nominees).hashCode() : 0);
        result = 37 * result + (this.results != null ? ((Object)this.results).hashCode() : 0);
        result = 37 * result + (this.resultsDescription != null ? this.resultsDescription.hashCode() : 0);
        return result;
    }

    public Collection getNominees() {
        return this.nominees;
    }

    public void setNominees(Collection nominees) {
        this.nominees = nominees;
    }

    public void setResults(Collection results, boolean summaryResults) {
        if (results != null) {
            this.results = results;
            this.resultsDescription = summaryResults ? RESULTS_SUMMARY : RESULTS_INDIVIDUAL;
        } else {
            this.resultsDescription = RESULTS_NONE;
        }
    }

    public Collection getResults() {
        return this.results;
    }

    public String getResultsDescription() {
        return this.resultsDescription;
    }

    public PollContentData getPollInfo() {
        return this.pollInfo;
    }

    public void setPollInfo(PollContentData pollInfo) {
        this.pollInfo = pollInfo;
    }

    public int getSid() {
        return this.pollInfo.getSid();
    }

    public long getTaskInstanceId() {
        return this.pollInfo.getTaskInstanceId();
    }

    public String getTitle() {
        return this.pollInfo.getTitle();
    }

    public String getContent() {
        return this.pollInfo.getContent();
    }

    public String getDescription() {
        return this.pollInfo.getDescription();
    }

    public int getMaxToChoose() {
        return this.pollInfo.getMaxToChoose();
    }

    public String getVoteMethod() {
        return this.pollInfo.getVoteMethod();
    }

    public boolean getAllowPollNominations() {
        return this.pollInfo.getAllowPollNominations();
    }

    public int getCompletionStatus() {
        return this.pollInfo.getCompletionStatus();
    }

    public Long getOutputContentId() {
        return this.pollInfo.getOutputContentId();
    }

    public boolean getProgressiveDisplay() {
        return this.pollInfo.getProgressiveDisplay();
    }

    public int getNumVoters() {
        return this.pollInfo.getNumVoters();
    }

    public int getNumVotersVoted() {
        return this.pollInfo.getNumVotersVoted();
    }
}

