/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.usermanagement;

import com.webmcq.ld.usermanagement.Rights;
import com.webmcq.ld.usermanagement.interfaces.OrganisationData;
import com.webmcq.ld.usermanagement.interfaces.OrganisationLocal;
import com.webmcq.ld.usermanagement.interfaces.OrganisationMembershipLocal;
import com.webmcq.ld.usermanagement.interfaces.OrganisationMembershipUtil;
import com.webmcq.ld.usermanagement.interfaces.OrganisationPK;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserLocal;
import com.webmcq.ld.util.BaseEntityBean;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class OrganisationBean
extends BaseEntityBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$usermanagement$OrganisationBean == null ? (class$com$webmcq$ld$usermanagement$OrganisationBean = OrganisationBean.class$("com.webmcq.ld.usermanagement.OrganisationBean")) : class$com$webmcq$ld$usermanagement$OrganisationBean));
    public static final long INVALID_ORGANISATION_ID = -1L;
    static /* synthetic */ Class class$com$webmcq$ld$usermanagement$OrganisationBean;

    public abstract Long getSid();

    public abstract void setSid(Long var1);

    public abstract String getName();

    public abstract void setName(String var1);

    public abstract String getDescription();

    public abstract void setDescription(String var1);

    public OrganisationPK ejbCreate() throws CreateException {
        this.setSid(new Long(this.nextId()));
        return null;
    }

    public void ejbPostCreate() {
    }

    public abstract Set getMembership();

    public abstract void setMembership(Set var1);

    public OrganisationMembershipLocal updateMembership(ShwaaUserLocal user, Integer right, boolean homeAccount) throws NamingException, CreateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateMembership: user" + (user != null ? user.getData().toString() : "null") + " right " + right));
        }
        Set members = this.getMembership();
        Integer newRight = right != null ? right : Rights.MEMBERSHIP;
        Iterator iter = members.iterator();
        OrganisationMembershipLocal member = null;
        while (member == null && iter.hasNext()) {
            OrganisationMembershipLocal element = (OrganisationMembershipLocal)iter.next();
            if (!element.getUser().equals(user)) continue;
            log.debug((Object)"member matched, updating right and homeAccount!");
            element.setRight(newRight);
            element.setAccountHome(homeAccount);
            member = element;
        }
        if (member == null) {
            log.debug((Object)"Adding new user");
            member = OrganisationMembershipUtil.getLocalHome().create();
            member.setRight(newRight);
            member.setAccountHome(homeAccount);
            members.add(member);
            user.getMemberships().add(member);
        }
        return member;
    }

    public abstract Set getChildOrganisations();

    public abstract void setChildOrganisations(Set var1);

    public abstract OrganisationLocal getParentOrganisation();

    public abstract void setParentOrganisation(OrganisationLocal var1);

    public abstract OrganisationData getData();

    public abstract boolean getAccountOrganisation();

    public abstract void setAccountOrganisation(boolean var1);

    public String getRightDescription(Long userId) {
        Integer right = this.getRight(userId);
        if (right != null) {
            return Rights.convertRight(right);
        }
        return null;
    }

    public Integer getRight(Long userId) {
        if (userId == null) {
            return null;
        }
        Integer right = null;
        Iterator iter = this.getMembership().iterator();
        while (right == null && iter.hasNext()) {
            OrganisationMembershipLocal element = (OrganisationMembershipLocal)iter.next();
            if (element.getUser().getUid() != userId) continue;
            right = element.getRight();
        }
        return right;
    }

    public abstract boolean getVisible();

    public abstract void setVisible(boolean var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

