/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.usermanagement;

import com.webmcq.ld.usermanagement.Rights;
import com.webmcq.ld.usermanagement.UserManagementAuthorisationException;
import com.webmcq.ld.usermanagement.UserManagementException;
import com.webmcq.ld.usermanagement.interfaces.OrganisationLocal;
import com.webmcq.ld.usermanagement.interfaces.OrganisationMembershipLocal;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserLocal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

class OrganisationRights
extends Rights {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$usermanagement$OrganisationRights == null ? (class$com$webmcq$ld$usermanagement$OrganisationRights = OrganisationRights.class$("com.webmcq.ld.usermanagement.OrganisationRights")) : class$com$webmcq$ld$usermanagement$OrganisationRights));
    static /* synthetic */ Class class$com$webmcq$ld$usermanagement$OrganisationRights;

    OrganisationRights() {
    }

    public static void checkRightsAddUserToOrganisation(OrganisationLocal org, ShwaaUserLocal adminUser) throws UserManagementAuthorisationException, UserManagementException {
        OrganisationRights.checkModifyOrganisation(org, adminUser);
    }

    public static OrganisationLocal checkRightsSelectOrganisation(Long organisationId, ShwaaUserLocal adminUser) throws UserManagementAuthorisationException, UserManagementException {
        Iterator iter = adminUser.getMemberships().iterator();
        boolean authorised = false;
        OrganisationLocal org = null;
        while (org == null && iter.hasNext()) {
            OrganisationMembershipLocal currMembership = (OrganisationMembershipLocal)iter.next();
            if (!currMembership.getOrganisation().getSid().equals(organisationId)) continue;
            org = currMembership.getOrganisation();
            if (!Rights.canSelect(currMembership.getRight())) continue;
            authorised = true;
        }
        if (!authorised) {
            throw new UserManagementAuthorisationException("error.authorisation");
        }
        return org;
    }

    public static void checkModifyOrganisation(OrganisationLocal org, ShwaaUserLocal adminUser) throws UserManagementAuthorisationException {
        Iterator iter = adminUser.getMemberships().iterator();
        boolean authorised = false;
        while (org != null && iter.hasNext()) {
            OrganisationMembershipLocal currMembership = (OrganisationMembershipLocal)iter.next();
            if (!currMembership.getOrganisation().getSid().equals(org.getSid()) || !Rights.canModify(currMembership.getRight())) continue;
            authorised = true;
        }
        if (!authorised) {
            throw new UserManagementAuthorisationException("error.authorisation");
        }
    }

    public static void checkModifyOrganisations(Set organisationIdSet, ShwaaUserLocal adminUser) throws UserManagementAuthorisationException {
        Iterator iter = adminUser.getMemberships().iterator();
        HashSet copySet = new HashSet(organisationIdSet);
        while (copySet.size() > 0 && iter.hasNext()) {
            OrganisationMembershipLocal currMembership = (OrganisationMembershipLocal)iter.next();
            Long currSid = currMembership.getOrganisation().getSid();
            if (!copySet.contains(currSid)) continue;
            if (!Rights.canModify(currMembership.getRight())) {
                log.error((Object)("Failed authorisation for modification user " + adminUser.getData().toString() + " for organisation id " + currSid));
                throw new UserManagementAuthorisationException("error.authorisation");
            }
            copySet.remove(currSid);
        }
        if (copySet.size() > 0) {
            log.error((Object)("Failed authorisation for modification user " + adminUser.getData().toString() + " for organisation id(s) " + ((Object)copySet).toString()));
            throw new UserManagementAuthorisationException("error.authorisation");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

