/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.usermanagement;

import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.OrganisationCompleteData;
import com.webmcq.ld.usermanagement.Rights;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.UserManagementAuthorisationException;
import com.webmcq.ld.usermanagement.UserManagementException;
import com.webmcq.ld.usermanagement.UserMembershipData;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.usermanagement.interfaces.UserManagementService;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.ws.ExtServerOrgMap;
import com.webmcq.ld.ws.ExtServerOrgMapManager;
import com.webmcq.ld.ws.ExtUserLoginMap;
import com.webmcq.ld.ws.ExtUserLoginMapManager;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.struts.upload.FormFile;

public class UserImporter {
    private static final short USERNAME = 0;
    private static final short PASSWORD = 1;
    private static final short FIRST_NAME = 2;
    private static final short LAST_NAME = 3;
    private static final short ROLE = 4;
    private static final short JOB_TITLE = 5;
    private static final short DEPARTMENT = 6;
    private static final short ORGANISATION = 7;
    private static final short ADDRESS = 8;
    private static final short PHONE = 9;
    private static final short FAX = 10;
    private static final short MOBILE = 11;
    private static final short EMAIL = 12;
    private static final short STATUS = 13;
    private static final short RIGHT = 14;
    private static final short SERVERID = 14;
    private static final int MAX_EMPTY_ROWS = 1;
    private static final String SEPERATOR = "|";
    private static final String SPACE = "&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String ROLE_AUTHOR = "author";
    private static final String ROLE_STAFF = "staff";
    private static final String ROLE_ADMIN = "administrator";
    private static final String ROLE_LEARNER = "learner";
    private static final String STATUS_DISABLED = "disabled";
    private static final String RIGHT_MODIFICATION = "modification";
    private static final String RIGHT_SELECTION = "selection";
    private static final String RIGHT_MEMBERSHIP = "membership";
    private static final String NO_AUTHORISATION = "<br>You are not authorised to select the user!";
    private static final String ROW = "Row ";
    private static final String FAIL_CREATE = ": Failed to create ";
    private static final String SUCCESS_CREATE = " user(s) have been created successfully!";
    private static final String SUCCESS_ADD = " user(s) have been added successfully!";
    private static final String SUCCESS_UPDATE = " user(s) have been created or updated successfully!";
    private static final String GREEN_FONT = "<font size=2 color=green>";
    private static final String RED_FONT = "<font size=2 color=red>";
    private static final String SKIP = ": Skipped. Error was: ";
    private static final String USERNAME_REQUIRED = "Username is required.";
    private static final String USER_NOT_EXIST = " does not exist! ";
    private static final String MEMBERSHIP_EXIST = " is already a member of the current org: ";
    private static final String FIRSTNAME_REQUIRED = "First name is required.";
    private static final String LASTNAME_REQUIRED = "Last name is required.";
    private static final String ROLE_REQUIRED = "Role is required.";
    private static final String PASSWORD_REQUIRED = "Password is required.";
    private static final String SERVERID_REQUIRED = "ServerId is required.";
    private static final String[] ERROR_MESSAGES = new String[]{"Username is required.", "Password is required.", "First name is required.", "Last name is required.", "Role is required.", "", "", "", "", "", "", "", "", "", "ServerId is required."};

    public static String importUsers(FileItem fileItem, OrganisationCompleteData orgData, Long adminUserId) throws Exception {
        if (orgData.isAccountOrganisation()) {
            return UserImporter.createUsersInAccountOrg(fileItem, orgData, adminUserId);
        }
        return UserImporter.importUsersInSessionClass(fileItem, orgData, adminUserId);
    }

    public static String importUsersFromForeignServer(FormFile file, Long adminUserId, boolean updating) throws Exception {
        POIFSFileSystem fs = new POIFSFileSystem(file.getInputStream());
        String message = "<ul>";
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        UserManagementService service = UserServiceDelegate.getService();
        int count = 0;
        HSSFCell cell = null;
        for (int i = startRow + 1; i < endRow + 1; ++i) {
            OrganisationCompleteData orgData = null;
            boolean emptyRow = true;
            boolean hasError = false;
            HSSFRow row = sheet.getRow(i);
            UserData user = null;
            String foreign_username = null;
            ExtServerOrgMap serverOrgMap = null;
            ExtUserLoginMap userLoginMap = null;
            cell = row.getCell((short)14);
            String msgForRow = "<li>";
            if (cell == null || UserImporter.getCellContent(cell).length() == 0) {
                msgForRow = UserImporter.buildMsgForRow(i, 14, msgForRow, hasError);
                message = message + msgForRow + "</font></li>";
                continue;
            }
            serverOrgMap = ExtServerOrgMapManager.getExtServerOrgMapById(UserImporter.getCellContent(cell));
            long orgId = serverOrgMap.getOrgid();
            orgData = service.getOrganisation(new Long(orgId), adminUserId);
            emptyRow = false;
            cell = row.getCell((short)0);
            if (cell == null || UserImporter.getCellContent(cell).length() == 0) {
                msgForRow = UserImporter.buildMsgForRow(i, 0, msgForRow, hasError);
                hasError = true;
            } else {
                foreign_username = UserImporter.getCellContent(cell);
                emptyRow = false;
                if (updating) {
                    try {
                        userLoginMap = ExtUserLoginMapManager.getExtUserLoginMapByUsernameAndServerId(foreign_username, serverOrgMap.getServerid());
                        if (userLoginMap == null) {
                            String login = StringUtils.trimToEmpty((String)serverOrgMap.getPrefix()) + "_" + foreign_username;
                            userLoginMap = new ExtUserLoginMap(foreign_username, login, serverOrgMap.getServerid());
                            user = new UserData();
                            user.setLogin(login);
                        }
                        user = UserServiceDelegate.findCompleteUser(userLoginMap.getLogin());
                    }
                    catch (UserNotFoundException e) {
                        throw new SystemException(e);
                    }
                } else {
                    user = new UserData();
                    user.setLogin(StringUtils.trimToEmpty((String)serverOrgMap.getPrefix()) + "_" + foreign_username);
                }
            }
            String password = null;
            cell = row.getCell((short)1);
            if (cell == null || UserImporter.getCellContent(cell).length() == 0) {
                msgForRow = UserImporter.buildMsgForRow(i, 1, msgForRow, hasError);
                hasError = true;
            } else {
                password = UserImporter.getCellContent(cell);
                emptyRow = false;
            }
            cell = row.getCell((short)2);
            if (cell == null || UserImporter.getCellContent(cell).length() == 0) {
                msgForRow = UserImporter.buildMsgForRow(i, 2, msgForRow, hasError);
                hasError = true;
            } else {
                user.setFirstName(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            cell = row.getCell((short)3);
            if (cell == null || UserImporter.getCellContent(cell).length() == 0) {
                msgForRow = UserImporter.buildMsgForRow(i, 3, msgForRow, hasError);
                hasError = true;
            } else {
                user.setLastName(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            cell = row.getCell((short)4);
            if (cell == null || UserImporter.getCellContent(cell).length() == 0) {
                msgForRow = UserImporter.buildMsgForRow(i, 4, msgForRow, hasError);
                hasError = true;
            } else {
                user.setRoles(UserImporter.parseRoles(UserImporter.getCellContent(cell)));
                emptyRow = false;
            }
            cell = row.getCell((short)5);
            if (cell != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setJobTitle(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)6)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setDepartment(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)7)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setOrganisation(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)8)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setAddress(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)9)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setPhone(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)10)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setFax(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)11)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setMobile(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)12)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setEmail(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)13)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setDisabled(UserImporter.parseStatus(UserImporter.getCellContent(cell)));
                emptyRow = false;
            }
            if (emptyRow) break;
            if (hasError) {
                message = message + msgForRow + "</font></li>";
                continue;
            }
            try {
                Long userId = service.updateUser(user, password, false, adminUserId, orgData.getSid());
                user.setSid(userId);
                user.setMemberships(UserImporter.parseRight(RIGHT_SELECTION, user, orgData, adminUserId, service));
                if (userLoginMap.getSid() == null) {
                    ExtUserLoginMapManager.saveOrUpdateExtUserLoginMap(userLoginMap);
                }
                ++count;
                message = message + UserImporter.buildSuccessMsgForRow(i, msgForRow, user, userLoginMap) + "</font></li>";
                continue;
            }
            catch (Exception e) {
                msgForRow = msgForRow + RED_FONT + ROW + i + FAIL_CREATE + user.getLogin() + SKIP + e.getMessage();
                message = message + msgForRow + "</font></li>";
            }
        }
        service.remove();
        return count + SUCCESS_UPDATE + message + "</ul><hr/>";
    }

    private static String buildSuccessMsgForRow(int row, String oldMsg, UserData user, ExtUserLoginMap map) {
        String roles = "";
        Iterator iter = user.getRoles().iterator();
        while (iter.hasNext()) {
            UserRole role = (UserRole)iter.next();
            roles = roles + SEPERATOR + role.getName();
        }
        return oldMsg + GREEN_FONT + ROW + row + ": " + map.getForeignUsername() + SPACE + roles.substring(1) + SPACE + user.getFullName() + SPACE + map.getServerid();
    }

    private static String buildMsgForRow(int row, int column, String oldMsg, boolean hasError) {
        if (hasError) {
            return oldMsg + ERROR_MESSAGES[column];
        }
        return oldMsg + RED_FONT + ROW + row + SKIP + ERROR_MESSAGES[column];
    }

    private static String createUsersInAccountOrg(FileItem fileItem, OrganisationCompleteData orgData, Long adminUserId) throws Exception {
        UserManagementService service = UserServiceDelegate.getService();
        String message = "<ul>";
        POIFSFileSystem fs = new POIFSFileSystem(fileItem.getInputStream());
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        int count = 0;
        HSSFCell cell = null;
        for (int i = startRow + 1; i < endRow + 1; ++i) {
            boolean emptyRow = true;
            boolean hasError = false;
            HSSFRow row = sheet.getRow(i);
            UserData user = new UserData();
            user.setSid(null);
            cell = row.getCell((short)0);
            String msgForRow = "<li>";
            if (cell == null || UserImporter.getCellContent(cell).length() == 0) {
                msgForRow = UserImporter.buildMsgForRow(i, 0, msgForRow, hasError);
                hasError = true;
            } else {
                user.setLogin(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            String password = null;
            cell = row.getCell((short)1);
            if (cell == null || UserImporter.getCellContent(cell).length() == 0) {
                msgForRow = UserImporter.buildMsgForRow(i, 1, msgForRow, hasError);
                hasError = true;
            } else {
                password = UserImporter.getCellContent(cell);
                emptyRow = false;
            }
            cell = row.getCell((short)2);
            if (cell == null || UserImporter.getCellContent(cell).length() == 0) {
                msgForRow = UserImporter.buildMsgForRow(i, 2, msgForRow, hasError);
                hasError = true;
            } else {
                user.setFirstName(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            cell = row.getCell((short)3);
            if (cell == null || UserImporter.getCellContent(cell).length() == 0) {
                msgForRow = UserImporter.buildMsgForRow(i, 3, msgForRow, hasError);
                hasError = true;
            } else {
                user.setLastName(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            cell = row.getCell((short)4);
            if (cell == null || UserImporter.getCellContent(cell).length() == 0) {
                msgForRow = UserImporter.buildMsgForRow(i, 4, msgForRow, hasError);
                hasError = true;
            } else {
                user.setRoles(UserImporter.parseRoles(UserImporter.getCellContent(cell)));
                emptyRow = false;
            }
            cell = row.getCell((short)5);
            if (cell != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setJobTitle(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)6)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setDepartment(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)7)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setOrganisation(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)8)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setAddress(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)9)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setPhone(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)10)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setFax(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)11)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setMobile(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)12)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setEmail(UserImporter.getCellContent(cell));
                emptyRow = false;
            }
            if ((cell = row.getCell((short)13)) != null && UserImporter.getCellContent(cell).length() > 0) {
                user.setDisabled(UserImporter.parseStatus(UserImporter.getCellContent(cell)));
                emptyRow = false;
            }
            if (emptyRow) break;
            if (hasError) {
                message = message + msgForRow + "</font></li>";
                continue;
            }
            try {
                Long newUserId = service.updateUser(user, password, false, adminUserId, orgData.getSid());
                user.setSid(newUserId);
                HSSFCell rightCell = row.getCell((short)14);
                if (rightCell != null) {
                    rightCell.setCellType(1);
                    user.setMemberships(UserImporter.parseRight(rightCell.getStringCellValue(), user, orgData, adminUserId, service));
                } else {
                    user.setMemberships(UserImporter.parseRight(RIGHT_SELECTION, user, orgData, adminUserId, service));
                }
                ++count;
                continue;
            }
            catch (Exception e) {
                msgForRow = msgForRow + RED_FONT + ROW + i + FAIL_CREATE + user.getLogin() + SKIP + e.getMessage();
                message = message + msgForRow;
            }
        }
        service.remove();
        return count + SUCCESS_CREATE + message + "</ul><hr/>";
    }

    private static String importUsersInSessionClass(FileItem fileItem, OrganisationCompleteData orgData, Long adminUserId) throws Exception {
        UserManagementService service = UserServiceDelegate.getService();
        String message = "<ul>";
        POIFSFileSystem fs = new POIFSFileSystem(fileItem.getInputStream());
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        int startRow = sheet.getFirstRowNum();
        int endRow = sheet.getLastRowNum();
        int count = 0;
        int emptyRowCount = 0;
        HSSFCell cell = null;
        SortedSet memberships = null;
        try {
            SortedSet adminMemberships = service.getCompleteUser(adminUserId).getMemberships();
            for (int i = startRow + 1; i < endRow + 1; ++i) {
                boolean emptyRow = true;
                boolean hasError = false;
                HSSFRow row = sheet.getRow(i);
                UserData user = null;
                cell = row.getCell((short)0);
                String msgForRow = "<li>";
                if (cell != null && UserImporter.getCellContent(cell).length() > 0) {
                    user = service.getCompleteUser(UserImporter.getCellContent(cell));
                    if (user == null) {
                        msgForRow = msgForRow + RED_FONT + ROW + i + SKIP + cell.getStringCellValue() + USER_NOT_EXIST;
                        hasError = true;
                    } else {
                        memberships = user.getMemberships();
                        Iterator iter = memberships.iterator();
                        boolean authorised = false;
                        while (iter.hasNext()) {
                            UserMembershipData membership = (UserMembershipData)iter.next();
                            Iterator iter2 = adminMemberships.iterator();
                            while (iter2.hasNext()) {
                                UserMembershipData adminMembership = (UserMembershipData)iter2.next();
                                if (!adminMembership.getOrgId().equals(membership.getOrgId()) || !Rights.canSelect(adminMembership.getRight())) continue;
                                authorised = true;
                                break;
                            }
                            if (!authorised) continue;
                            break;
                        }
                        if (!authorised) {
                            msgForRow = msgForRow + RED_FONT + ROW + i + SKIP + UserImporter.getCellContent(cell) + NO_AUTHORISATION;
                            hasError = true;
                        }
                    }
                    emptyRowCount = 0;
                    emptyRow = false;
                }
                if (emptyRow) {
                    if (++emptyRowCount <= 1) {
                        msgForRow = msgForRow + RED_FONT + ROW + i + SKIP + USERNAME_REQUIRED;
                        message = message + msgForRow;
                        continue;
                    }
                    break;
                }
                if (hasError) {
                    message = message + msgForRow + "</font></li>";
                    continue;
                }
                try {
                    UserMembershipData membership = new UserMembershipData(user, orgData, Rights.SELECTION, false);
                    if (memberships.add(membership)) {
                        user.setMemberships(memberships);
                        ++count;
                        service.updateUserMembership(user.getSid(), orgData.getSid(), Rights.SELECTION, false, adminUserId);
                        continue;
                    }
                    msgForRow = msgForRow + RED_FONT + ROW + i + SKIP + user.getLogin() + MEMBERSHIP_EXIST + orgData.getName();
                    message = message + msgForRow;
                    continue;
                }
                catch (Exception e) {
                    msgForRow = msgForRow + RED_FONT + ROW + i + FAIL_CREATE + user.getLogin() + SKIP + e.getMessage();
                    message = message + msgForRow;
                }
            }
        }
        catch (RemoteException e) {
            message = e.getMessage();
        }
        service.remove();
        return count + SUCCESS_ADD + message + "</ul><hr/>";
    }

    private static String getCellContent(HSSFCell cell) {
        try {
            cell.setCellType(1);
            return StringUtils.trimToEmpty((String)cell.getStringCellValue());
        }
        catch (NumberFormatException e) {
            cell.setCellType(0);
            double d = cell.getNumericCellValue();
            return new Long(new Double(d).longValue()).toString();
        }
    }

    public static HashSet parseRoles(String roleDescription) {
        String role;
        HashSet<UserRole> roles = new HashSet<UserRole>();
        int fromIndex = 0;
        int index = roleDescription.indexOf(SEPERATOR, fromIndex);
        while (index != -1) {
            role = roleDescription.substring(fromIndex, index);
            if (role.equals(ROLE_AUTHOR)) {
                roles.add(UserRole.AUTHOR);
            } else if (role.equals(ROLE_STAFF)) {
                roles.add(UserRole.STAFF);
            } else if (role.equals(ROLE_ADMIN)) {
                roles.add(UserRole.ADMINISTRATOR);
            } else if (role.equals(ROLE_LEARNER)) {
                roles.add(UserRole.LEARNER);
            }
            fromIndex = index + 1;
            index = roleDescription.indexOf(SEPERATOR, fromIndex);
        }
        role = roleDescription.substring(fromIndex, roleDescription.length());
        if (role.equals(ROLE_AUTHOR)) {
            roles.add(UserRole.AUTHOR);
        } else if (role.equals(ROLE_STAFF)) {
            roles.add(UserRole.STAFF);
        } else if (role.equals(ROLE_ADMIN)) {
            roles.add(UserRole.ADMINISTRATOR);
        } else if (role.equals(ROLE_LEARNER)) {
            roles.add(UserRole.LEARNER);
        }
        return roles;
    }

    private static Boolean parseStatus(String status) {
        return new Boolean(status.equals(STATUS_DISABLED));
    }

    private static TreeSet parseRight(String right, UserData user, OrganisationCompleteData orgData, Long adminUserId, UserManagementService service) throws UserManagementException, UserManagementAuthorisationException, RemoteException {
        Integer rightInt = Rights.SELECTION;
        if (right.equals(RIGHT_MODIFICATION)) {
            rightInt = Rights.MODIFICATION;
        } else if (right.equals(RIGHT_MEMBERSHIP)) {
            rightInt = Rights.MEMBERSHIP;
        }
        UserMembershipData membership = new UserMembershipData(user.getSid(), user.getLogin(), user.getFirstName(), user.getLastName(), orgData.getSid(), orgData.getName(), orgData.getDescription(), true, rightInt, true);
        TreeSet<UserMembershipData> memberships = new TreeSet<UserMembershipData>();
        memberships.add(membership);
        orgData.getUsers().put(user, membership);
        service.updateUserMembership(user.getSid(), orgData.getSid(), rightInt, true, adminUserId);
        return memberships;
    }
}

