/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.usermanagement.sysadmin.web;

import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.ConfigurationServiceDelegate;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.LcwUser;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.usermanagement.sysadmin.web.LcwUserActionForm;
import com.webmcq.ld.util.Codec;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LcwUserRegisterAction
extends Action {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$usermanagement$sysadmin$web$LcwUserRegisterAction == null ? (class$com$webmcq$ld$usermanagement$sysadmin$web$LcwUserRegisterAction = LcwUserRegisterAction.class$("com.webmcq.ld.usermanagement.sysadmin.web.LcwUserRegisterAction")) : class$com$webmcq$ld$usermanagement$sysadmin$web$LcwUserRegisterAction));
    static /* synthetic */ Class class$com$webmcq$ld$usermanagement$sysadmin$web$LcwUserRegisterAction;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            request.getSession(true).removeAttribute("LcwUserActionForm");
            return mapping.findForward("login");
        }
        ShwaaUserData shwaaUser = null;
        try {
            shwaaUser = UserServiceDelegate.find(request.getRemoteUser());
        }
        catch (UserNotFoundException e) {
            log.error((Object)e);
            return mapping.findForward("error");
        }
        LcwUserActionForm userForm = (LcwUserActionForm)form;
        if (UserServiceDelegate.getLcwUserByEmail(userForm.getEmail()) != null) {
            String errorMsg = "This email is already registered.";
            request.setAttribute("errorMsg", (Object)errorMsg);
            return new ActionForward(mapping.getInput());
        }
        String lcwServerURL = ConfigurationServiceDelegate.get(ConfigurationKeys.LCW_SERVER_URL);
        String roles = "";
        UserData userData = UserServiceDelegate.findCompleteUser(userForm.getUserId());
        Iterator iter = userData.getRoles().iterator();
        while (iter.hasNext()) {
            UserRole role = (UserRole)iter.next();
            roles = roles + role.getName() + ",";
        }
        roles = roles.substring(0, roles.length() - 1);
        String urlString = lcwServerURL + "lams/register?fnx=" + Codec.encode(userForm.getFirstName()) + "&lnx=" + Codec.encode(userForm.getLastName()) + "&ex=" + Codec.encode(userForm.getEmail()) + "&fltx=" + Codec.encode(userForm.getPassword()) + "&rx=" + Codec.encode(roles);
        log.debug((Object)("====>urlString: " + urlString));
        URL url = new URL(urlString);
        HttpURLConnection httpConnection = null;
        try {
            httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setDoInput(true);
            httpConnection.connect();
        }
        catch (IOException e) {
            log.debug((Object)e);
            String errorMsg = "LAMS Community Website is not available now:-(";
            request.setAttribute("errorMsg", (Object)errorMsg);
            return new ActionForward(mapping.getInput());
        }
        log.debug((Object)("=====>register LCW; response code: " + httpConnection.getResponseCode()));
        log.debug((Object)("=====>register LCW; response message: " + httpConnection.getResponseMessage()));
        if (httpConnection.getResponseCode() < 200 || httpConnection.getResponseCode() >= 400) {
            String errMsg = "LCW Server Error--Response Code:" + httpConnection.getResponseCode() + " Response Message:" + httpConnection.getResponseMessage();
            request.setAttribute("errorMsg", (Object)errMsg);
            return new ActionForward(mapping.getInput());
        }
        InputStream in = httpConnection.getInputStream();
        log.debug((Object)("=====>available bytes in inputstream: " + in.available()));
        BufferedInputStream bufIn = new BufferedInputStream(in);
        log.debug((Object)("=====>available bytes in buffered inputstream: " + bufIn.available()));
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(bufIn));
        char[] chars = new char[in.available()];
        bufReader.read(chars, 0, in.available());
        String inputString = new String(chars);
        log.info((Object)("=====>Input String: " + inputString));
        in.close();
        bufIn.close();
        if (inputString.indexOf("ERROR_START:") != -1) {
            int istart = inputString.indexOf("ERROR_START:");
            int iend = inputString.indexOf(":ERROR_END");
            String errorMsg = inputString.substring(istart + 12, iend);
            request.setAttribute("errorMsg", (Object)errorMsg);
            return new ActionForward(mapping.getInput());
        }
        LcwUser lcwUser = new LcwUser();
        lcwUser.setUserId(shwaaUser.getUid());
        lcwUser.setCreatedDate(new Date());
        lcwUser.setLastModified(lcwUser.getCreatedDate());
        lcwUser.setOptout(false);
        lcwUser.setEmail(userForm.getEmail());
        lcwUser.setPassword(Codec.encode(userForm.getPassword()));
        lcwUser.setFirstName(userForm.getFirstName());
        lcwUser.setLastName(userForm.getLastName());
        try {
            UserServiceDelegate.saveLcwUser(lcwUser);
        }
        catch (Exception e) {
            log.error((Object)e);
            String errorMsg = "Error happened when update database.Please contact sysadmin.";
            request.setAttribute("errorMsg", (Object)errorMsg);
            return new ActionForward(mapping.getInput());
        }
        return mapping.findForward("lcwLogin");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

