/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.ws;

import com.webmcq.ld.service.StaffServiceDelegate;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.OrganisationCompleteData;
import com.webmcq.ld.usermanagement.interfaces.UserManagementService;
import com.webmcq.ld.ws.ExtCourseClassMap;
import com.webmcq.ld.ws.ExtCourseClassMapManager;
import com.webmcq.ld.ws.ExtUserLoginMap;
import com.webmcq.ld.ws.ExtUserLoginMapManager;
import com.webmcq.ld.ws.LearningSessionManager;
import com.webmcq.ld.ws.UserManagementServiceDelegate;
import java.rmi.RemoteException;
import javax.ejb.RemoveException;
import org.apache.log4j.Logger;
import org.lamsfoundation.ld.security.Authenticator;

public class LearningSessionServiceSoapBindingImpl
implements LearningSessionManager {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$ws$LearningSessionServiceSoapBindingImpl == null ? (class$com$webmcq$ld$ws$LearningSessionServiceSoapBindingImpl = LearningSessionServiceSoapBindingImpl.class$("com.webmcq.ld.ws.LearningSessionServiceSoapBindingImpl")) : class$com$webmcq$ld$ws$LearningSessionServiceSoapBindingImpl));
    static /* synthetic */ Class class$com$webmcq$ld$ws$LearningSessionServiceSoapBindingImpl;

    public long createLearningSession(String serverId, String datetime, String hashValue, String username, long ldId, String courseId, String title, String desc, String type) throws RemoteException {
        try {
            Authenticator.authenticate(datetime, username, serverId, hashValue);
            long classId = this.getClassId(serverId, courseId);
            String login = this.getLogin(serverId, username);
            if (type.equalsIgnoreCase("preview")) {
                classId = this.createPreviewClass(login);
            }
            long id = StaffServiceDelegate.createLearningSession(login, new Long(ldId).intValue(), classId, title, desc, type);
            StaffServiceDelegate.start(new Long(id).intValue());
            log.debug((Object)("learning session created:" + id));
            return id;
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private Long createPreviewClass(String login) throws Exception {
        Long adminUserId = UserServiceDelegate.find(login).getUid();
        OrganisationCompleteData ocd = new OrganisationCompleteData(new Long(-1L), "Preview Class", "This is a preview Class", false, null, true, false);
        UserManagementService service = UserServiceDelegate.getService();
        Long organisationID = service.updateOrganisation(ocd, false, adminUserId);
        service.updateUserMembership(adminUserId, organisationID, new Integer(0), false, adminUserId);
        log.debug((Object)("preview class created:" + organisationID));
        try {
            service.remove();
        }
        catch (RemoveException e) {
            log.debug((Object)e);
        }
        return organisationID;
    }

    public boolean deleteLearningSession(String serverId, String datetime, String hashValue, String username, long lsId) throws RemoteException {
        try {
            Authenticator.authenticate(datetime, username, serverId, hashValue);
            String login = this.getLogin(serverId, username);
            log.debug((Object)(login + " is removing learning session:" + lsId));
            return StaffServiceDelegate.removeLearningSession(lsId);
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private String getLogin(String serverId, String username) throws Exception {
        String login;
        ExtUserLoginMap map = ExtUserLoginMapManager.getExtUserLoginMapByUsernameAndServerId(username, serverId);
        if (map == null) {
            try {
                login = UserManagementServiceDelegate.getUserDataAndCreateUser(serverId, username);
            }
            catch (Exception e) {
                throw new RemoteException(e.getMessage(), e);
            }
        } else {
            login = map.getLogin();
        }
        return login;
    }

    private long getClassId(String serverId, String courseId) throws Exception {
        long classId;
        ExtCourseClassMap map = ExtCourseClassMapManager.getExtCourseClassMapByCourseIdAndServerId(courseId, serverId);
        if (map == null) {
            try {
                classId = UserManagementServiceDelegate.createClass(serverId, courseId, null, null);
            }
            catch (Exception e) {
                throw new RemoteException(e.getMessage(), e);
            }
        } else {
            classId = map.getClassid();
        }
        return classId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

