/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.ws;

import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.ConfigurationServiceDelegate;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.OrganisationCompleteData;
import com.webmcq.ld.usermanagement.Rights;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.UserImporter;
import com.webmcq.ld.usermanagement.interfaces.UserManagementService;
import com.webmcq.ld.ws.ExtCourseClassMap;
import com.webmcq.ld.ws.ExtCourseClassMapManager;
import com.webmcq.ld.ws.ExtServerOrgMap;
import com.webmcq.ld.ws.ExtServerOrgMapManager;
import com.webmcq.ld.ws.ExtUserLoginMap;
import com.webmcq.ld.ws.ExtUserLoginMapManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import javax.ejb.RemoveException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.ld.util.CSVUtil;
import org.lamsfoundation.ld.util.HashUtil;
import org.lamsfoundation.ld.util.RandomPasswordGenerator;

public class UserManagementServiceDelegate {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$ws$UserManagementServiceDelegate == null ? (class$com$webmcq$ld$ws$UserManagementServiceDelegate = UserManagementServiceDelegate.class$("com.webmcq.ld.ws.UserManagementServiceDelegate")) : class$com$webmcq$ld$ws$UserManagementServiceDelegate));
    static /* synthetic */ Class class$com$webmcq$ld$ws$UserManagementServiceDelegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createOrganisationForDemoServer(String name, String description, boolean account) throws Exception {
        UserManagementService service = UserServiceDelegate.getService();
        try {
            if (name == null || name.trim().length() == 0) {
                name = "Third Party Organisation";
            }
            if (description == null || description.trim().length() == 0) {
                description = "This is an organisation created by web service endpoint";
            }
            OrganisationCompleteData org = new OrganisationCompleteData(new Long(-1L), name, description, account, null, true, false);
            Long organisationID = service.updateOrganisation(org, false, new Long(0L));
            log.debug((Object)("organisation created:" + organisationID));
            long l = organisationID;
            return l;
        }
        finally {
            try {
                service.remove();
            }
            catch (RemoveException e) {
                log.debug((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createUserForDemoServer(String username, String password, String email, String roles, String firstName, String lastName, long orgId) throws Exception {
        UserData user = new UserData();
        user.setSid(null);
        user.setLogin(username);
        user.setEmail(email);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setDisabled(new Boolean(false));
        if (StringUtils.trimToEmpty((String)roles).length() == 0) {
            user.setRoles(UserImporter.parseRoles(ConfigurationServiceDelegate.get(ConfigurationKeys.DEFAULT_ROLES)));
        } else {
            user.setRoles(UserImporter.parseRoles(roles));
        }
        UserManagementService service = UserServiceDelegate.getService();
        try {
            Long uid = service.updateUser(user, password, false, new Long(0L), null);
            service.updateUserMembership(uid, new Long(orgId), Rights.SELECTION, true, new Long(0L));
            log.debug((Object)("user created:" + user.getLogin()));
            long l = uid;
            return l;
        }
        finally {
            try {
                service.remove();
            }
            catch (RemoveException e) {
                log.debug((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteUserForDemoServer(long userid) throws Exception {
        UserManagementService service = UserServiceDelegate.getService();
        try {
            boolean bl = service.deleteUser(UserServiceDelegate.find(userid).getLogin());
            return bl;
        }
        finally {
            try {
                service.remove();
            }
            catch (RemoveException e) {
                log.debug((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteOrganisationForDemoServer(long orgId, boolean recursive, boolean rebuildTree) throws Exception {
        UserManagementService service = UserServiceDelegate.getService();
        try {
            boolean bl = service.deleteOrganisation(orgId, recursive, rebuildTree);
            return bl;
        }
        finally {
            try {
                service.remove();
            }
            catch (RemoveException e) {
                log.debug((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addMembershipForDemoServer(long userid, long classId) throws Exception {
        UserManagementService service = UserServiceDelegate.getService();
        try {
            Long userId = new Long(userid);
            service.updateUserMembership(userId, new Long(classId), Rights.SELECTION, false, new Long(0L));
            log.debug((Object)("adding user:" + userid + " to class:" + classId));
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                service.remove();
            }
            catch (RemoveException e) {
                log.debug((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createClass(String serverId, String courseid, String name, String description) throws Exception {
        ExtCourseClassMap map = ExtCourseClassMapManager.getExtCourseClassMapByCourseIdAndServerId(courseid, serverId);
        if (map != null) {
            return map.getClassid();
        }
        UserManagementService service = UserServiceDelegate.getService();
        try {
            if (name == null || name.trim().length() == 0) {
                name = "3rd Party Class for course:" + courseid + " on server:" + serverId;
            }
            if (description == null || description.trim().length() == 0) {
                description = "This is a class created by web service endpoint";
            }
            OrganisationCompleteData org = new OrganisationCompleteData(new Long(-1L), name, description, false, null, true, false);
            Long organisationID = service.updateOrganisation(org, false, new Long(0L));
            log.debug((Object)("class created:" + organisationID));
            map = new ExtCourseClassMap();
            map.setClassid(organisationID);
            map.setCourseid(courseid);
            map.setServerid(serverId);
            ExtCourseClassMapManager.saveOrUpdateExtCourseClassMap(map);
            long l = organisationID;
            return l;
        }
        finally {
            try {
                service.remove();
            }
            catch (RemoveException e) {
                log.debug((Object)e);
            }
        }
    }

    public static String createUser(String serverId, String username, String password, String roles, String firstName, String lastName) throws Exception {
        ExtUserLoginMap map = ExtUserLoginMapManager.getExtUserLoginMapByUsernameAndServerId(username, serverId);
        if (map != null) {
            return map.getLogin();
        }
        UserData user = new UserData();
        user.setSid(null);
        ExtServerOrgMap map2 = ExtServerOrgMapManager.getExtServerOrgMapById(serverId);
        if (map2 == null) {
            throw new Exception("Your server:" + serverId + " is not registered in LAMS!");
        }
        user.setLogin(UserManagementServiceDelegate.buildLogin(map2, username));
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setDisabled(new Boolean(false));
        if (StringUtils.trimToEmpty((String)roles).length() == 0) {
            user.setRoles(UserImporter.parseRoles(ConfigurationServiceDelegate.get(ConfigurationKeys.DEFAULT_ROLES)));
        } else {
            user.setRoles(UserImporter.parseRoles(roles));
        }
        return UserManagementServiceDelegate.createUserFromUserData(map2, user, username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteUser(String serverId, String username) throws Exception {
        ExtUserLoginMap map = ExtUserLoginMapManager.getExtUserLoginMapByUsernameAndServerId(username, serverId);
        if (map == null) {
            return false;
        }
        String login = map.getLogin();
        UserManagementService service = UserServiceDelegate.getService();
        try {
            log.debug((Object)("deleting user:" + login));
            ExtUserLoginMapManager.deleteExtUserLoginMap(map);
            boolean bl = service.deleteUser(login);
            return bl;
        }
        finally {
            try {
                service.remove();
            }
            catch (RemoveException e) {
                log.debug((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteOrganisation(String serverId, boolean recursive, boolean rebuildTree) throws Exception {
        ExtServerOrgMap map = ExtServerOrgMapManager.getExtServerOrgMapById(serverId);
        if (map == null) {
            return false;
        }
        long orgId = map.getOrgid();
        UserManagementService service = UserServiceDelegate.getService();
        try {
            ExtServerOrgMapManager.deleteExtServerOrgMap(map);
            log.debug((Object)("deleting organisation:" + orgId + " recusive:" + recursive + " rebuildTree:" + rebuildTree));
            boolean bl = service.deleteOrganisation(orgId, recursive, rebuildTree);
            return bl;
        }
        finally {
            try {
                service.remove();
            }
            catch (RemoveException e) {
                log.debug((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addMembership(String serverId, String username, String courseid) throws Exception {
        ExtUserLoginMap map = ExtUserLoginMapManager.getExtUserLoginMapByUsernameAndServerId(username, serverId);
        if (map == null) {
            throw new Exception("The user:" + username + " has not been created in LAMS!");
        }
        ExtCourseClassMap map2 = ExtCourseClassMapManager.getExtCourseClassMapByCourseIdAndServerId(courseid, serverId);
        if (map2 == null) {
            throw new Exception("The class for the course:" + courseid + " has not been created in LAMS!");
        }
        UserManagementService service = UserServiceDelegate.getService();
        try {
            Long userId = service.getUserId(map.getLogin());
            service.updateUserMembership(userId, new Long(map2.getClassid()), Rights.SELECTION, false, new Long(0L));
            log.debug((Object)("adding user:" + map.getLogin() + " to class:" + map2.getClassid()));
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                service.remove();
            }
            catch (RemoveException e) {
                log.debug((Object)e);
            }
        }
    }

    public static String getUserDataAndCreateUser(String serverId, String username) throws Exception {
        ExtServerOrgMap map = ExtServerOrgMapManager.getExtServerOrgMapById(serverId);
        if (map == null) {
            throw new Exception("Your server:" + serverId + " has not been registered in LAMS!");
        }
        UserData user = UserManagementServiceDelegate.getUserDataFromExtServer(map, username);
        return UserManagementServiceDelegate.createUserFromUserData(map, user, username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createUserFromUserData(ExtServerOrgMap map, UserData user, String username) throws Exception {
        UserManagementService service = UserServiceDelegate.getService();
        try {
            String password = RandomPasswordGenerator.nextPassword(8);
            Long uid = service.updateUser(user, password, false, new Long(0L), null);
            service.updateUserMembership(uid, new Long(map.getOrgid()), Rights.SELECTION, true, new Long(0L));
            log.debug((Object)("user created:" + user.getLogin()));
            ExtUserLoginMap map2 = new ExtUserLoginMap();
            map2.setForeignUsername(username);
            map2.setLogin(user.getLogin());
            map2.setServerid(map.getServerid());
            ExtUserLoginMapManager.saveOrUpdateExtUserLoginMap(map2);
            String string = user.getLogin();
            return string;
        }
        finally {
            try {
                service.remove();
            }
            catch (RemoveException e) {
                log.debug((Object)e);
            }
        }
    }

    private static String hash(ExtServerOrgMap map, String username, String date) throws NoSuchAlgorithmException {
        String serverId = map.getServerid();
        String serverKey = map.getServerkey();
        String plaintext = date.trim().toLowerCase() + username.trim().toLowerCase() + serverId.trim().toLowerCase() + serverKey.trim().toLowerCase();
        return HashUtil.sha1(plaintext);
    }

    private static UserData getUserDataFromExtServer(ExtServerOrgMap map, String username) throws Exception {
        String userDataCallbackUrl = map.getUserinfoUrl();
        String timestamp = Long.toString(new Date().getTime());
        String hash = UserManagementServiceDelegate.hash(map, username, timestamp);
        userDataCallbackUrl = userDataCallbackUrl.replaceAll("%username%", username);
        userDataCallbackUrl = userDataCallbackUrl.replaceAll("%timestamp%", timestamp);
        userDataCallbackUrl = userDataCallbackUrl.replaceAll("%hash%", hash);
        log.debug((Object)userDataCallbackUrl);
        URL url = new URL(userDataCallbackUrl);
        URLConnection conn = url.openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            throw new Exception("Fail to fetch user data from external server:" + map.getServerid() + "- Invalid connection type");
        }
        HttpURLConnection httpConn = (HttpURLConnection)conn;
        if (httpConn.getResponseCode() != 200) {
            throw new Exception("Fail to fetch user data from external server:" + map.getServerid() + " - Unexpected return HTTP Status");
        }
        InputStream is = url.openConnection().getInputStream();
        BufferedReader isReader = new BufferedReader(new InputStreamReader(is));
        String str = isReader.readLine();
        if (str == null) {
            throw new Exception("Fail to fetch user data from external server:" + map.getServerid() + " - No data returned from external server");
        }
        String[] vals = CSVUtil.parse(str);
        UserData user = new UserData();
        user.setLogin(UserManagementServiceDelegate.buildLogin(map, vals[0]));
        user.setFirstName(vals[1]);
        user.setLastName(vals[2]);
        user.setJobTitle(vals[3]);
        user.setDepartment(vals[4]);
        user.setOrganisation(vals[5]);
        user.setAddress(vals[6]);
        user.setPhone(vals[7]);
        user.setFax(vals[8]);
        user.setMobile(vals[9]);
        user.setEmail(vals[10]);
        user.setRoles(UserImporter.parseRoles(ConfigurationServiceDelegate.get(ConfigurationKeys.DEFAULT_ROLES)));
        return user;
    }

    private static String buildLogin(ExtServerOrgMap map, String username) {
        return StringUtils.trimToEmpty((String)map.getPrefix()) + "_" + username;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

