/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.ActivityDefnVO;
import com.webmcq.ld.activities.LdItem;
import com.webmcq.ld.activities.LearningDesignDefnValidator;
import com.webmcq.ld.activities.MultiTaskVO;
import com.webmcq.ld.activities.OptionalActivityDefnVO;
import com.webmcq.ld.activities.TransitionDefnVO;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.util.UTCDate;
import com.webmcq.ld.util.WDDXProcessor;
import com.webmcq.ld.util.WDDXProcessorConversionException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class LearningDesignDefnVO
extends LdItem
implements Serializable {
    private static Logger logger = Logger.getLogger((String)(class$com$webmcq$ld$activities$LearningDesignDefnVO == null ? (class$com$webmcq$ld$activities$LearningDesignDefnVO = LearningDesignDefnVO.class$("com.webmcq.ld.activities.LearningDesignDefnVO")) : class$com$webmcq$ld$activities$LearningDesignDefnVO).getName());
    static final long serialVersionUID = 5474754876455652344L;
    public static final String LD_OBJECT_TYPE = "LearningDesign";
    public static final String LD_LIST_OBJECT_TYPE = "LearningDesignList";
    public static final String LIBPACKAGE_OBJECT_TYPE = "LibraryPackage";
    public static final String NO_ACTIVITIESTRANSITIONS_FOUND_ERROR = "No activitiesTransitions was found: ";
    public static final int ACCESS_OWNER = -1;
    public static final int ACCESS_PUBLIC = 0;
    protected Set activities;
    protected Set transitions;
    protected String description;
    protected String title;
    protected int maxId;
    protected Integer firstActivityId;
    protected String objectType;
    protected Set contentSids;
    protected Set optionalActivities;
    protected boolean validDesign;
    protected boolean readOnly;
    protected String dateReadOnly;
    protected long readAccess;
    protected long writeAccess;
    protected Long owner;
    protected String helpText;
    static /* synthetic */ Class class$com$webmcq$ld$activities$LearningDesignDefnVO;

    public LearningDesignDefnVO() throws Exception {
    }

    public LearningDesignDefnVO(String objectType) throws Exception {
        this.setObjectType(LIBPACKAGE_OBJECT_TYPE.equals(objectType) ? LIBPACKAGE_OBJECT_TYPE : LD_OBJECT_TYPE);
        this.setReadOnly(false);
    }

    public String theObjectType() {
        return this.getObjectType();
    }

    public ActivityDefnVO selectActivity(int id) {
        Set theActivities = this.getActivities();
        Iterator it = theActivities.iterator();
        while (it.hasNext()) {
            ActivityDefnVO activity = (ActivityDefnVO)it.next();
            if (activity.getId() != id) continue;
            return activity;
        }
        return null;
    }

    public TransitionDefnVO selectTransition(int id) {
        Set theTransitions = this.getTransitions();
        Iterator it = theTransitions.iterator();
        while (it.hasNext()) {
            TransitionDefnVO transition = (TransitionDefnVO)it.next();
            if (transition.getId() != id) continue;
            return transition;
        }
        return null;
    }

    public Set getActivities() {
        return this.activities;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMaxId() {
        return this.maxId;
    }

    public String getTitle() {
        return this.title;
    }

    public Set getTransitions() {
        return this.transitions;
    }

    public void setActivities(Set activities) {
        this.activities = activities;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMaxId(int maxId) {
        this.maxId = maxId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTransitions(Set transitions) {
        this.transitions = transitions;
    }

    public Integer getFirstActivityId() {
        return this.firstActivityId;
    }

    public void setFirstActivityId(Integer newId) {
        this.firstActivityId = newId;
    }

    public Integer calculateFirstActivity() {
        Integer firstId = null;
        HashSet candidates = new HashSet();
        if (this.getActivities() != null) {
            candidates.addAll(this.getActivities());
        }
        if (this.getOptionalActivities() != null) {
            candidates.addAll(this.getOptionalActivities());
        }
        Set nonFirstActivities = this.getAllSubsequentActivityIds();
        Set actsFromOptAct = this.getAllActivityIdsInOptionalActivities();
        if (actsFromOptAct != null) {
            nonFirstActivities.addAll(actsFromOptAct);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking for first activity candidates " + ((Object)candidates).toString() + " known not to be first " + nonFirstActivities.toString()));
        }
        Iterator iter = candidates.iterator();
        while (iter.hasNext() && firstId == null) {
            LdItem item = (LdItem)iter.next();
            Integer itemId = new Integer(item.getId());
            if (nonFirstActivities.contains(itemId)) continue;
            firstId = itemId;
        }
        return firstId;
    }

    protected Set getAllSubsequentActivityIds() {
        Set transitions = this.getTransitions();
        Iterator iter = transitions.iterator();
        HashSet<Integer> taskIds = new HashSet<Integer>();
        while (iter.hasNext()) {
            TransitionDefnVO transition = (TransitionDefnVO)iter.next();
            taskIds.add(new Integer(transition.getToTaskActivityId()));
        }
        return taskIds;
    }

    protected Set getAllActivityIdsInOptionalActivities() {
        HashSet<Integer> activityIds = null;
        Set optActs = this.getOptionalActivities();
        if (optActs != null) {
            activityIds = new HashSet<Integer>();
            Iterator iter = optActs.iterator();
            while (iter.hasNext()) {
                OptionalActivityDefnVO optAct = (OptionalActivityDefnVO)iter.next();
                Set activities = optAct.getActivities();
                if (activities == null) continue;
                Iterator iter2 = activities.iterator();
                while (iter2.hasNext()) {
                    LdItem lditem = (LdItem)iter2.next();
                    activityIds.add(new Integer(lditem.getId()));
                }
            }
        }
        return activityIds;
    }

    public Set[] calculateSubsequentTransitionsActivities(Integer currentActivityId) {
        HashSet<TransitionDefnVO> resultTransitions = new HashSet<TransitionDefnVO>();
        HashSet<Integer> resultActivityIds = new HashSet<Integer>();
        Set transitions = this.getTransitions();
        if (transitions != null) {
            Iterator iter = transitions.iterator();
            while (iter.hasNext()) {
                TransitionDefnVO transition = (TransitionDefnVO)iter.next();
                int fromId = transition.getFromTaskActivityId();
                if ((long)fromId != currentActivityId.longValue()) continue;
                resultTransitions.add(transition);
                resultActivityIds.add(new Integer(transition.getToTaskActivityId()));
            }
        }
        Set[] retValue = new Set[]{resultTransitions, resultActivityIds};
        return retValue;
    }

    public Integer calculateSingleSubsequentTransitionId(Integer currentId) {
        Integer id = null;
        Set transitions = this.getTransitions();
        if (transitions != null) {
            Iterator iter = transitions.iterator();
            while (iter.hasNext() && id == null) {
                TransitionDefnVO transition = (TransitionDefnVO)iter.next();
                int fromId = transition.getFromTaskActivityId();
                if (fromId != currentId) continue;
                id = new Integer(transition.getId());
            }
        }
        return id;
    }

    public Hashtable allTasks(boolean bySid) {
        Hashtable result = new Hashtable();
        Set activities = this.getActivities();
        if (activities != null) {
            Iterator actIter = activities.iterator();
            while (actIter.hasNext()) {
                ActivityDefnVO activity = (ActivityDefnVO)actIter.next();
                Set tasks = activity.getTasks();
                if (tasks == null) continue;
                Iterator taskIter = tasks.iterator();
                while (taskIter.hasNext()) {
                    this.addAllTasksToResult(result, (AbstractTaskVO)taskIter.next(), bySid);
                }
            }
        }
        return result;
    }

    private void addAllTasksToResult(Hashtable result, AbstractTaskVO task, boolean bySid) {
        MultiTaskVO multi;
        Set subTasks;
        if (bySid) {
            result.put(task.getSid(), task);
        } else {
            result.put(new Integer(task.getId()), task);
        }
        if (task.theTaskType() == 2 && (subTasks = (multi = (MultiTaskVO)task).getSubTasks()) != null) {
            Iterator iter = subTasks.iterator();
            while (iter.hasNext()) {
                this.addAllTasksToResult(result, (AbstractTaskVO)iter.next(), bySid);
            }
        }
    }

    public Hashtable allTasksWithContent(boolean bySid) {
        Hashtable result = new Hashtable();
        Set activities = this.getActivities();
        if (activities != null) {
            Iterator actIter = activities.iterator();
            while (actIter.hasNext()) {
                ActivityDefnVO activity = (ActivityDefnVO)actIter.next();
                Set tasks = activity.getTasks();
                if (tasks == null) continue;
                Iterator taskIter = tasks.iterator();
                while (taskIter.hasNext()) {
                    this.addContentTasksToResult(result, (AbstractTaskVO)taskIter.next(), bySid);
                }
            }
        }
        return result;
    }

    private void addContentTasksToResult(Hashtable result, AbstractTaskVO task, boolean bySid) {
        switch (task.theTaskType()) {
            case 2: {
                MultiTaskVO multi = (MultiTaskVO)task;
                Set subTasks = multi.getSubTasks();
                if (subTasks == null) break;
                Iterator iter = subTasks.iterator();
                while (iter.hasNext()) {
                    this.addContentTasksToResult(result, (AbstractTaskVO)iter.next(), bySid);
                }
                break;
            }
            default: {
                if (bySid) {
                    result.put(task.getSid(), task);
                    break;
                }
                result.put(new Integer(task.getId()), task);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        buf.append("Learning Design VO ");
        buf.append(" sid=");
        buf.append(this.getSid());
        buf.append(" id=");
        buf.append(this.getId());
        buf.append(" title=");
        buf.append(this.getTitle());
        buf.append(" description=");
        buf.append(this.getDescription());
        buf.append(" maxId=");
        buf.append(this.getMaxId());
        buf.append(" firstActivityId=");
        buf.append(this.getFirstActivityId());
        Set val = this.getActivities();
        buf.append(" activities=");
        buf.append(val != null ? val.toString() : "null");
        val = this.getTransitions();
        buf.append(" transitions=");
        buf.append(val != null ? val.toString() : "null");
        val = this.getContentSids();
        buf.append(" contentSids=");
        buf.append(val != null ? val.toString() : "null");
        val = this.getOptionalActivities();
        buf.append(" optional activity ids=");
        buf.append(val != null ? val.toString() : "null");
        return buf.toString();
    }

    public Set getContentSids() {
        return this.contentSids;
    }

    public void setContentSids(Set content) {
        this.contentSids = content;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public Set getOptionalActivities() {
        return this.optionalActivities;
    }

    public void setOptionalActivities(Set optionalActivities) {
        this.optionalActivities = optionalActivities;
    }

    public OptionalActivityDefnVO selectOptionalActivity(int id) {
        Set theActivities = this.getOptionalActivities();
        Iterator it = theActivities.iterator();
        while (it.hasNext()) {
            OptionalActivityDefnVO activity = (OptionalActivityDefnVO)it.next();
            if (activity.getId() != id) continue;
            return activity;
        }
        return null;
    }

    public boolean isValidDesign() {
        return this.validDesign;
    }

    private void setValidDesign(boolean validDesign) {
        this.validDesign = validDesign;
    }

    public String validate() {
        logger.debug((Object)("Validating learning design " + this.getTitle()));
        LearningDesignDefnValidator validator = new LearningDesignDefnValidator(this);
        String messages = validator.validate();
        if (messages != null && messages.length() > 0) {
            this.setValidDesign(false);
        } else {
            this.setValidDesign(true);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("validDesign set to " + this.isValidDesign() + " validation messages " + messages));
        }
        return messages;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getDateReadOnly() {
        return this.dateReadOnly;
    }

    private void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    private void setDateReadOnly(String dateReadOnly) {
        this.dateReadOnly = dateReadOnly;
    }

    public void setReadOnly() {
        if (!this.readOnly) {
            this.setReadOnly(true);
            UTCDate utcDate = new UTCDate();
            this.setDateReadOnly(utcDate.toString());
        }
    }

    public void unlockDesign() {
        this.setReadOnly(false);
    }

    public void setUpdateable() {
        this.setReadOnly(false);
        this.setDateReadOnly(null);
    }

    public long getReadAccess() {
        return this.readAccess;
    }

    public void setReadAccess(long accessScope) {
        this.readAccess = accessScope;
    }

    public long getWriteAccess() {
        return this.writeAccess;
    }

    public void setWriteAccess(long accessScope) {
        this.writeAccess = accessScope;
    }

    public Long getOwner() {
        return this.owner;
    }

    public void setOwner(Long userId) {
        this.owner = userId;
    }

    public boolean hasWriteAccess(Long userId) {
        return this.checkAccess(userId, this.getWriteAccess());
    }

    public boolean hasReadAccess(Long userId) {
        return this.checkAccess(userId, this.getReadAccess());
    }

    private boolean checkAccess(Long userId, long accessValue) {
        if (accessValue == 0L) {
            return true;
        }
        if (userId != null) {
            if (accessValue == -1L && userId.equals(this.getOwner())) {
                return true;
            }
            try {
                UserData user = UserServiceDelegate.findCompleteUser(userId);
                if (user != null && user.isInOrganisation(new Long(accessValue))) {
                    return true;
                }
            }
            catch (UserNotFoundException e) {
                // empty catch block
            }
        }
        return false;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helptext) {
        this.helpText = helptext;
    }

    public boolean equals(Object pOther) {
        if (pOther instanceof LearningDesignDefnVO) {
            LearningDesignDefnVO lTest = (LearningDesignDefnVO)pOther;
            boolean lEquals = super.equals(pOther);
            if (this.description == null) {
                lEquals = lEquals && lTest.description == null;
            } else {
                boolean bl = lEquals = lEquals && this.description.equals(lTest.description);
            }
            lEquals = this.title == null ? lEquals && lTest.title == null : lEquals && this.title.equals(lTest.title);
            boolean bl = lEquals = lEquals && this.maxId == lTest.maxId;
            if (this.firstActivityId == null) {
                lEquals = lEquals && lTest.firstActivityId == null;
            } else {
                boolean bl2 = lEquals = lEquals && this.firstActivityId.equals(lTest.firstActivityId);
            }
            if (this.objectType == null) {
                lEquals = lEquals && lTest.objectType == null;
            } else {
                boolean bl3 = lEquals = lEquals && this.objectType.equals(lTest.objectType);
            }
            lEquals = this.owner == null ? lEquals && lTest.owner == null : lEquals && this.owner.equals(lTest.owner);
            return lEquals;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 37 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 37 * result + this.maxId;
        result = 37 * result + (this.firstActivityId != null ? this.firstActivityId.hashCode() : 0);
        result = 37 * result + (this.dateReadOnly != null ? this.dateReadOnly.hashCode() : 0);
        return result;
    }

    public void populateFromWDDXHashtable(Hashtable packageHashtable) throws WDDXProcessorConversionException {
        Vector newActivitiesTransitions;
        Vector newContent;
        this.title = (String)packageHashtable.get("title");
        this.description = (String)packageHashtable.get("description");
        this.maxId = WDDXProcessor.convertToInt("maxId", packageHashtable.get("sid"));
        this.firstActivityId = WDDXProcessor.convertToInteger("firstActivityId", packageHashtable.get("sid"));
        this.id = WDDXProcessor.convertToInt("LdItem id", packageHashtable.get("id"));
        this.owner = null;
        this.setHelpText((String)packageHashtable.get("helpText"));
        Integer readAccess = WDDXProcessor.convertToInteger("readAccess", packageHashtable.get("readAccess"));
        this.readAccess = readAccess == null ? (this.objectType.equals(LIBPACKAGE_OBJECT_TYPE) ? 0L : -1L) : (long)readAccess.intValue();
        this.writeAccess = readAccess == null ? -1L : (long)readAccess.intValue();
        if (this.getContentSids() == null) {
            this.setContentSids(new HashSet());
        }
        if ((newContent = (Vector)packageHashtable.get("content")) != null) {
            this.processContent(newContent);
        }
        if ((newActivitiesTransitions = (Vector)packageHashtable.get("activitiesTransitions")) == null) {
            logger.error((Object)(NO_ACTIVITIESTRANSITIONS_FOUND_ERROR + this.sid));
            throw new WDDXProcessorConversionException(NO_ACTIVITIESTRANSITIONS_FOUND_ERROR + this.sid);
        }
        this.processActivitiesTransitions(newActivitiesTransitions);
        this.processOptionalActivities();
        this.firstActivityId = this.calculateFirstActivity();
        this.setGroupToTaskLinks();
        this.setOutputTasksAsReplaceWithDynamic();
        this.generateTransitionTitles();
    }

    private void generateTransitionTitles() {
    }

    private void setOutputTasksAsReplaceWithDynamic() {
    }

    private void setGroupToTaskLinks() {
    }

    private void processOptionalActivities() {
    }

    private void processActivitiesTransitions(Vector newActivitiesTransitions) {
    }

    private void processContent(Vector newContent) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

