/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.authoring;

import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.interfaces.ContentRepository;
import com.webmcq.ld.content.interfaces.ContentRepositoryHome;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.util.exception.SystemException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;

public class ContentDelegate {
    private static Logger m_logger = Logger.getLogger((String)(class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectStorer == null ? (class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectStorer = ContentDelegate.class$("com.webmcq.ld.activities.authoring.LDWDDXValueObjectStorer")) : class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectStorer).getName());
    private Map m_currentContentsByCreationToolKey = null;
    private Map m_currentContentsBySid = null;
    private ContentRepository m_contentManager = null;
    static /* synthetic */ Class class$com$webmcq$ld$activities$authoring$LDWDDXValueObjectStorer;

    public ContentDelegate(Collection currentSids) {
        this.buildContentSet(currentSids);
    }

    private ContentRepository getContentManager() throws SystemException {
        if (this.m_contentManager == null) {
            try {
                InitialContext ctx = new InitialContext();
                ContentRepositoryHome home = (ContentRepositoryHome)ctx.lookup("ejb/content/ContentRepository");
                this.m_contentManager = home.create();
            }
            catch (Exception e) {
                m_logger.error((Object)"Exception received getting content repository", (Throwable)e);
                throw new SystemException(e);
            }
        }
        return this.m_contentManager;
    }

    private void buildContentSet(Collection contentSids) throws RuntimeException {
        this.m_currentContentsByCreationToolKey = new HashMap();
        this.m_currentContentsBySid = new HashMap();
        if (contentSids == null) {
            return;
        }
        Long contentSid = null;
        try {
            Iterator iter = contentSids.iterator();
            while (iter.hasNext()) {
                contentSid = (Long)iter.next();
                ContentRepository manager = this.getContentManager();
                Content content = manager.getContent(contentSid);
                this.m_currentContentsByCreationToolKey.put(content.getCreationToolKey(), content);
                this.m_currentContentsBySid.put(content.getSid(), content);
            }
        }
        catch (RemoteException e) {
            m_logger.error((Object)("RemoteException exception received while trying to get content, sid =" + contentSid), (Throwable)e);
            throw new SystemException(e);
        }
        catch (ControllerException e) {
            m_logger.error((Object)("Controller exception received while trying to get content, sid =" + contentSid), (Throwable)e);
            throw new SystemException(e);
        }
    }

    public Content insertContent(Content content) {
        m_logger.debug((Object)("insertContent: content=" + content.toString()));
        try {
            this.getContentManager().setContent(content);
            return content;
        }
        catch (RemoteException e) {
            m_logger.error((Object)("RemoteException exception received while trying to store new content object: " + content.toString()), (Throwable)e);
            throw new SystemException(e);
        }
        catch (ControllerException e) {
            m_logger.error((Object)("ControllerException exception received while trying to store new  content object: " + content.toString()), (Throwable)e);
            throw new SystemException(e);
        }
    }

    public void updateContent(Content content) {
        m_logger.debug((Object)("updateContent: content=" + content.toString()));
        try {
            this.getContentManager().setContent(content.getSid(), content);
        }
        catch (RemoteException e) {
            m_logger.error((Object)("RemoteException exception received while trying to store new  content object: " + content.toString()), (Throwable)e);
            throw new SystemException(e);
        }
        catch (ControllerException e) {
            m_logger.error((Object)("ControllerException exception received while trying to store new  content object: " + content.toString()), (Throwable)e);
            throw new SystemException(e);
        }
    }

    public Map getCurrentContentsAsMapByCreationToolKey() {
        return this.m_currentContentsByCreationToolKey;
    }

    public Map getCurrentContentsAsMapBySid() {
        return this.m_currentContentsBySid;
    }

    public void refreshCurrentContents(Collection currentSids) {
        m_logger.debug((Object)("refreshCurrentContents: rebuilding contents for " + currentSids));
        this.m_currentContentsBySid = null;
        this.m_currentContentsByCreationToolKey = null;
        this.buildContentSet(currentSids);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

