/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.authoring;

import com.webmcq.ld.activities.authoring.interfaces.LDAuthoringService;
import com.webmcq.ld.activities.authoring.interfaces.LDAuthoringServiceHome;
import com.webmcq.ld.controller.ToolProxy;
import com.webmcq.ld.service.AuthorServiceDelegate;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.usermanagement.OrganisationCompleteData;
import com.webmcq.ld.util.ObjectMessage;
import com.webmcq.ld.util.WDDXProcessor;
import com.webmcq.ld.util.WebUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class RequestLDServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger((String)(class$com$webmcq$ld$activities$authoring$RequestLDServlet == null ? (class$com$webmcq$ld$activities$authoring$RequestLDServlet = RequestLDServlet.class$("com.webmcq.ld.activities.authoring.RequestLDServlet")) : class$com$webmcq$ld$activities$authoring$RequestLDServlet).getName());
    public final String ID_PARAMETER = "ID";
    public final String LIST_PARAMETER = "LIST";
    public final String LIST_VALUE_ALL = "ALL";
    public final String LIST_VALUE_VALID = "VALID";
    public final String LIBRARY_PARAMETER = "LIBRARY";
    public final String DELETE_LD_PARAMETER = "DELETELD";
    public final String DELETE_LIBRARY_ACTIVITY_PARAMETER = "DELETELIBACTIVITY";
    public final String DELETE_LIBRARY_PARAMETER = "DELETELIB";
    public final String HOMEORG_PARAMETER = "HOMEORG";
    public final String TOOLURL_PARAMETER = "TOOLURL";
    static /* synthetic */ Class class$com$webmcq$ld$activities$authoring$RequestLDServlet;
    static /* synthetic */ Class class$com$webmcq$ld$activities$authoring$interfaces$LDAuthoringServiceHome;

    protected void doGet(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        this.doPost(arg0, arg1);
    }

    protected LDAuthoringService getService() throws NamingException, RemoteException, CreateException {
        InitialContext lContext = new InitialContext();
        LDAuthoringServiceHome home = (LDAuthoringServiceHome)PortableRemoteObject.narrow((Object)lContext.lookup("java:comp/env/ejb/activities/LDAuthoringService"), (Class)(class$com$webmcq$ld$activities$authoring$interfaces$LDAuthoringServiceHome == null ? (class$com$webmcq$ld$activities$authoring$interfaces$LDAuthoringServiceHome = RequestLDServlet.class$("com.webmcq.ld.activities.authoring.interfaces.LDAuthoringServiceHome")) : class$com$webmcq$ld$activities$authoring$interfaces$LDAuthoringServiceHome));
        LDAuthoringService service = home.create();
        return service;
    }

    protected void doPost(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        PrintWriter tempWriter = arg1.getWriter();
        String wddxPacket = null;
        String errorMessage = null;
        String username = null;
        try {
            username = WebUtil.getUsername(arg0);
        }
        catch (Exception e) {
            logger.error((Object)"doPost: exception caught, trying to convert to an error message for client ", (Throwable)e);
            String string = errorMessage = e.getMessage() != null ? e.getMessage() : "No username found";
        }
        if (username == null) {
            if (errorMessage == null) {
                errorMessage = "Unable to process request - username missing";
            }
        } else {
            try {
                wddxPacket = this.process(arg0, username);
            }
            catch (Exception e) {
                logger.error((Object)"doPost: exception caught, trying to convert to an error message for client ", (Throwable)e);
                String string = errorMessage = e.getMessage() != null ? e.getMessage() : "Error occured but no message supplied. See system log for details";
            }
        }
        if (errorMessage != null) {
            try {
                wddxPacket = WDDXProcessor.serialize(errorMessage);
            }
            catch (Exception e) {
                logger.error((Object)("doPost: unable to send error packet to client. Error was " + errorMessage), (Throwable)e);
                throw new ServletException(errorMessage);
            }
        }
        tempWriter.println(wddxPacket);
    }

    protected String process(HttpServletRequest arg0, String username) throws Exception {
        String wddxPacket = null;
        if (arg0.getParameter("LIST") != null) {
            boolean validOnly = arg0.getParameter("LIST") == "VALID";
            LDAuthoringService service = this.getService();
            wddxPacket = service.learningDesignListWDDX(validOnly, username);
            service.remove();
        } else if (arg0.getParameter("ID") != null) {
            Long learningDesignId = null;
            try {
                learningDesignId = new Long(arg0.getParameter("ID"));
            }
            catch (Exception e) {
                throw new Exception("Invalid Parameter for ID - can't convert to number. Value was " + arg0.getParameter("ID"));
            }
            LDAuthoringService service = this.getService();
            wddxPacket = service.learningDesignRequestWDDX(learningDesignId, username);
            service.remove();
        } else if (arg0.getParameter("LIBRARY") != null) {
            LDAuthoringService service = this.getService();
            wddxPacket = service.libraryContentsRequestWDDX(null, username);
            service.remove();
        } else if (arg0.getParameter("DELETELD") != null) {
            Long id = null;
            try {
                id = new Long(arg0.getParameter("DELETELD"));
            }
            catch (Exception e) {
                throw new Exception("Invalid Parameter for delete - can't convert to number. Value was " + arg0.getParameter("DELETELD"));
            }
            LDAuthoringService service = this.getService();
            wddxPacket = service.deleteLearningDesignWDDX(id, username);
            service.remove();
        } else if (arg0.getParameter("DELETELIBACTIVITY") != null) {
            Long id = null;
            try {
                id = new Long(arg0.getParameter("DELETELIBACTIVITY"));
            }
            catch (Exception e) {
                throw new Exception("Invalid Parameter for delete - can't convert to number. Value was " + arg0.getParameter("DELETELIBACTIVITY"));
            }
            LDAuthoringService service = this.getService();
            wddxPacket = service.deleteLibraryPackageWDDX(id, username);
            service.remove();
        } else if (arg0.getParameter("HOMEORG") != null) {
            wddxPacket = this.getHomeOrganisation(username);
        } else if (arg0.getParameter("TOOLURL") != null) {
            wddxPacket = this.getToolUrls(username);
            logger.debug((Object)"After call");
        } else {
            throw new Exception("No valid parameters. Should be ID=(number) or LIST=(anything) or LIBRARY=(anything) or DELETELD=(number) orDELETELIBACTIVITY=(number)");
        }
        logger.debug((Object)("Returning packet " + wddxPacket));
        return wddxPacket;
    }

    private String getHomeOrganisation(String username) throws IOException, ServletException {
        OrganisationCompleteData homeOrg = null;
        logger.debug((Object)"getHomeOrganisation");
        try {
            long adminUserId = UserServiceDelegate.findUserId(username);
            homeOrg = UserServiceDelegate.findHomeOrganisation(adminUserId);
            if (homeOrg == null) {
                logger.warn((Object)("No organisations found for user " + adminUserId));
                homeOrg = new OrganisationCompleteData(new Long(-1L), "", "", true, null, null, null, new Long(-1L), true, true);
            }
        }
        catch (UserNotFoundException e) {
            logger.error((Object)"User not found exception occured ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        ObjectMessage oMsg = new ObjectMessage(homeOrg, "getHomeOrganisation");
        return WDDXProcessor.serialize(oMsg);
    }

    private String getToolUrls(String username) throws IOException, ServletException {
        Vector<String> vector = new Vector<String>();
        List proxies = AuthorServiceDelegate.getToolProxies();
        if (proxies != null) {
            Iterator iter = proxies.iterator();
            while (iter.hasNext()) {
                ToolProxy element = (ToolProxy)iter.next();
                vector.add(element.getType());
                vector.add(element.getLearnerUrl());
                logger.debug((Object)("addded " + element.getType() + " " + element.getLearnerUrl()));
            }
        }
        ObjectMessage oMsg = new ObjectMessage(vector, "getToolUrls");
        String packet = null;
        packet = WDDXProcessor.serialize(oMsg);
        logger.debug((Object)("Returning packet " + packet));
        return packet;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

