/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.runtimeaccess.tree;

import com.webmcq.ld.activities.runtimeaccess.tree.AbstractStrategy;
import com.webmcq.ld.activities.runtimeaccess.tree.DesignItem;
import com.webmcq.ld.activities.runtimeaccess.tree.DesignItemsDTO;
import com.webmcq.ld.activities.runtimeaccess.tree.TransitionLeaf;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class SequentialStrategy
extends AbstractStrategy
implements Serializable {
    private static Logger log = Logger.getLogger((String)(class$com$webmcq$ld$activities$runtimeaccess$tree$SequentialStrategy == null ? (class$com$webmcq$ld$activities$runtimeaccess$tree$SequentialStrategy = SequentialStrategy.class$("com.webmcq.ld.activities.runtimeaccess.tree.SequentialStrategy")) : class$com$webmcq$ld$activities$runtimeaccess$tree$SequentialStrategy).getName());
    static final long serialVersionUID = 7643976206679993577L;
    private Long m_firstSid;
    private Map m_cache;
    private LinkedList m_cacheLinearSequence;
    static /* synthetic */ Class class$com$webmcq$ld$activities$runtimeaccess$tree$SequentialStrategy;
    static /* synthetic */ Class class$com$webmcq$ld$activities$runtimeaccess$tree$TransitionLeaf;
    static /* synthetic */ Class class$com$webmcq$ld$activities$runtimeaccess$tree$DesignLeaf;

    public SequentialStrategy(long firstSid) {
        this.m_firstSid = new Long(firstSid);
        this.m_cache = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatedChildren() {
        Map map = this.m_cache;
        synchronized (map) {
            this.m_cache.clear();
        }
        this.m_cacheLinearSequence = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DesignItemsDTO getCachedValue(DesignItem currentChildItem) {
        DesignItemsDTO value = null;
        Long sid = currentChildItem != null ? currentChildItem.getSid() : new Long(0L);
        Map map = this.m_cache;
        synchronized (map) {
            value = (DesignItemsDTO)this.m_cache.get(sid);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCachedValue(DesignItem currentChildItem, DesignItemsDTO nextItem) {
        Long sid;
        Long l = sid = currentChildItem != null ? currentChildItem.getSid() : new Long(0L);
        if (nextItem != null) {
            Map map = this.m_cache;
            synchronized (map) {
                this.m_cache.put(sid, nextItem);
            }
        } else {
            log.warn((Object)("setCachedValue: Trying to cache a step in the sequence but nextItem is null  input sid " + sid));
        }
    }

    public DesignItemsDTO getNextItems(DesignItem currentChild) {
        DesignItemsDTO nextDTO;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNextItems: childrenBySid is " + (this.getChildrenBySid() != null ? this.getChildrenBySid().toString() : "null")));
        }
        if ((nextDTO = this.getNextDesignItemsDTO(currentChild, this.getFollowingTransition())) != null) {
            return nextDTO;
        }
        log.error((Object)("No next item found. We seem to have a problem - children were " + (this.getChildrenBySid() != null ? this.getChildrenBySid().toString() : "null") + " - current child was " + currentChild.toString()));
        return DesignItemsDTO.getEmptyVersion();
    }

    public List getLinearSequence() {
        if (this.m_cacheLinearSequence == null) {
            LinkedList<DesignItem> list = new LinkedList<DesignItem>();
            SortedMap childrenBySid = this.getChildrenBySid();
            DesignItem item = null;
            if (childrenBySid == null) {
                log.warn((Object)("Trying to get linear sequence but no children exist. Node is " + (this.m_node != null ? this.m_node.toString() : "null")));
                return list;
            }
            item = (DesignItem)childrenBySid.get(this.m_firstSid);
            if (item == null) {
                log.error((Object)("No first item found. We seem to have a problem - empty container? First sid" + this.m_firstSid + ", children mapping" + (childrenBySid != null ? childrenBySid.toString() : "null")));
            } else {
                TransitionLeaf transitionAfterActivity = this.getFollowingTransition();
                while (item != null) {
                    list.add(item);
                    DesignItemsDTO dto = this.getNextDesignItemsDTO(item, transitionAfterActivity);
                    item = null;
                    if (dto != null) {
                        DesignItem[] items = dto.getItems();
                        if (items == null || items.length <= 0) continue;
                        item = items[0];
                        continue;
                    }
                    item = null;
                }
            }
            this.m_cacheLinearSequence = list;
        }
        return this.m_cacheLinearSequence;
    }

    private DesignItemsDTO getNextDesignItemsDTO(DesignItem currentChild, TransitionLeaf transitionAfterContainer) {
        DesignItemsDTO nextDTO = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNextItem(): currentChild is " + (currentChild != null ? currentChild.toString() : "null")));
        }
        if ((nextDTO = this.getCachedValue(currentChild)) == null) {
            DesignItem item = this.calculateNextItem(currentChild, transitionAfterContainer);
            nextDTO = item != null ? new DesignItemsDTO(new DesignItem[]{item}, 1) : DesignItemsDTO.getEmptyVersion();
            this.setCachedValue(currentChild, nextDTO);
        }
        return nextDTO;
    }

    private DesignItem calculateNextItem(DesignItem currentChild, TransitionLeaf transitionAfterContainer) {
        DesignItem nextItem = null;
        SortedMap childrenBySid = this.getChildrenBySid();
        if (childrenBySid == null) {
            log.warn((Object)("Trying to get next item but no children exist. Node is " + (this.m_node != null ? this.m_node.toString() : "null")));
            return null;
        }
        if (currentChild == null) {
            nextItem = (DesignItem)childrenBySid.get(this.m_firstSid);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking for next item, currentChild is null. First item sid is " + this.m_firstSid + " item found " + (nextItem != null ? nextItem.toString() : "null")));
            }
        } else if ((class$com$webmcq$ld$activities$runtimeaccess$tree$TransitionLeaf == null ? (class$com$webmcq$ld$activities$runtimeaccess$tree$TransitionLeaf = SequentialStrategy.class$("com.webmcq.ld.activities.runtimeaccess.tree.TransitionLeaf")) : class$com$webmcq$ld$activities$runtimeaccess$tree$TransitionLeaf).isInstance(currentChild)) {
            TransitionLeaf transition = (TransitionLeaf)currentChild;
            Long nextSid = transition.getNextItemSid();
            if (nextSid != null) {
                nextItem = (DesignItem)childrenBySid.get(nextSid);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking for next item, currentChild is a transition. Next item sid " + nextSid + " item found " + (nextItem != null ? nextItem.toString() : "null")));
            }
        } else {
            Iterator iter = childrenBySid.values().iterator();
            while (nextItem == null && iter.hasNext()) {
                DesignItem element;
                if (!(class$com$webmcq$ld$activities$runtimeaccess$tree$TransitionLeaf == null ? SequentialStrategy.class$("com.webmcq.ld.activities.runtimeaccess.tree.TransitionLeaf") : class$com$webmcq$ld$activities$runtimeaccess$tree$TransitionLeaf).isInstance(element = (DesignItem)iter.next())) continue;
                nextItem = this.processTransition(currentChild, childrenBySid, (TransitionLeaf)element);
            }
            if (nextItem == null && transitionAfterContainer != null && transitionAfterContainer.isSync()) {
                nextItem = transitionAfterContainer;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Looking for next item using transitions. Next item found" + (nextItem != null ? nextItem.toString() : "null")));
            }
        }
        return nextItem;
    }

    private DesignItem processTransition(DesignItem currentChild, Map childrenBySid, TransitionLeaf transition) {
        Long currentChildSid;
        DesignItem nextItem = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("processTransition: currentChild " + currentChild + " transition " + (transition != null ? transition.toString() : "null")));
        }
        if ((currentChildSid = currentChild.getSid()) != null && currentChildSid.equals(transition.getPreviousItemSid())) {
            if (transition.isSync() && (class$com$webmcq$ld$activities$runtimeaccess$tree$DesignLeaf == null ? (class$com$webmcq$ld$activities$runtimeaccess$tree$DesignLeaf = SequentialStrategy.class$("com.webmcq.ld.activities.runtimeaccess.tree.DesignLeaf")) : class$com$webmcq$ld$activities$runtimeaccess$tree$DesignLeaf).isAssignableFrom(currentChild.getClass())) {
                nextItem = transition;
            } else {
                Long nextSid = transition.getNextItemSid();
                nextItem = (DesignItem)childrenBySid.get(nextSid);
            }
        }
        return nextItem;
    }

    public long getFirstSid() {
        return this.m_firstSid;
    }

    public void setFirstSid(long firstSid) {
        this.m_firstSid = new Long(firstSid);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

