/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.content;

import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.ContentDAO;
import com.webmcq.ld.content.ContentException;
import com.webmcq.ld.content.ContentGroup;
import com.webmcq.ld.content.ControlContent;
import com.webmcq.ld.content.LDContentKey;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.util.BaseSessionBean;
import org.apache.log4j.Logger;

public abstract class ContentRepositoryBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$content$ContentRepositoryBean == null ? (class$com$webmcq$ld$content$ContentRepositoryBean = ContentRepositoryBean.class$("com.webmcq.ld.content.ContentRepositoryBean")) : class$com$webmcq$ld$content$ContentRepositoryBean));
    static /* synthetic */ Class class$com$webmcq$ld$content$ContentRepositoryBean;

    public Content getContent(long contentId) throws ControllerException {
        log.debug((Object)"getContent: contentId");
        Content content = ContentDAO.find(contentId);
        if (content.theContentType().equals("control")) {
            ContentGroup cGroup = ((ControlContent)content).getContentGroup();
            log.debug((Object)("content group found: '" + cGroup + "'"));
            if (cGroup.isEmpty()) {
                throw new ControllerException("no content in content group");
            }
            content = (Content)cGroup.iterator().next();
            return content;
        }
        return content;
    }

    public Content[] getContents(long contentId) throws ControllerException {
        log.debug((Object)"getContent: contentId");
        Content content = ContentDAO.find(contentId);
        if (content.theContentType().equals("control")) {
            ContentGroup cGroup = ((ControlContent)content).getContentGroup();
            log.debug((Object)("content group found: '" + cGroup + "'"));
            if (cGroup.isEmpty()) {
                return new Content[0];
            }
            return cGroup.getContentsArray();
        }
        return new Content[]{content};
    }

    public void setContent(long contentId, Content content) throws ControllerException {
        log.debug((Object)"setContent: contentId, content");
        Content existing = ContentDAO.find(contentId);
        if (existing.theContentType().equals("control")) {
            ControlContent cContent = (ControlContent)existing;
            ContentGroup cGroup = cContent.getContentGroup();
            cGroup.addContent(content);
            ContentDAO.store(cGroup);
        } else {
            content.setSid(new Long(contentId));
            ContentDAO.store(content);
        }
    }

    public long setContent(Content content) throws ControllerException {
        log.debug((Object)"setContent: content");
        ContentDAO.insert(content);
        return content.getSid();
    }

    public long issueContentId(long learningDesignId, long contentId, long learningSessionId) {
        log.debug((Object)"issueContentId: learningDesignId, contentId, learningSessionId");
        LDContentKey key = new LDContentKey(learningDesignId, contentId, learningSessionId);
        Long id = ContentDAO.findContentId(key);
        if (id == null) {
            ContentDAO.insert(key);
            return key.getContentId();
        }
        return id;
    }

    public Long getContentId(LDContentKey contentKey) throws ContentException {
        log.debug((Object)("getContentId: " + contentKey));
        return ContentDAO.findContentId(contentKey);
    }

    public void deleteContent(long contentId) throws ControllerException {
        ContentDAO.remove(contentId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

