/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.activities.ActivityDefnVO;
import com.webmcq.ld.activities.OptionalActivityDefnVO;
import com.webmcq.ld.controller.AbstractActivity;
import com.webmcq.ld.controller.Activity;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.OptionalTask;
import com.webmcq.ld.controller.SingleActivity;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.preview.ActivityIterator;
import com.webmcq.ld.controller.preview.OptionalActivityIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;

public class OptionalActivity
extends AbstractActivity {
    private OptionalActivityDefnVO definition;
    private List activities;

    public OptionalActivity(long learningDesignId, OptionalActivityDefnVO definition) {
        super(learningDesignId, definition.getSid(), definition.getTitle(), definition.getDescription());
        this.definition = definition;
        this.activities = new ArrayList();
        this.buildMemberActivities();
    }

    private void buildMemberActivities() {
        Iterator iter = this.definition.getActivities().iterator();
        while (iter.hasNext()) {
            ActivityDefnVO act = (ActivityDefnVO)iter.next();
            this.activities.add(new SingleActivity(this.getLearningDesignId(), act));
        }
    }

    public Task nextTask(Task currentTask) throws ControllerException {
        if (currentTask == null) {
            return new OptionalTask(this.definition.getDummyTask());
        }
        if (currentTask instanceof OptionalTask) {
            return null;
        }
        Activity parent = currentTask.getActivity();
        if (!this.isMemberActivity(parent)) {
            throw new ControllerException("given task does not belong to this activity: " + currentTask);
        }
        return parent.nextTask(currentTask);
    }

    public boolean isMemberActivity(Activity activity) {
        try {
            this.getMemberActivity(activity.getSid());
            return true;
        }
        catch (ControllerException e) {
            return false;
        }
    }

    public Activity getMemberActivity(long id) throws ControllerException {
        Iterator iter = this.activities.iterator();
        while (iter.hasNext()) {
            Activity activity = (Activity)iter.next();
            if (activity.getSid() != id) continue;
            return activity;
        }
        throw new ControllerException("activity not found '" + id + "'");
    }

    public Activity[] getMemberActivities() {
        return this.activities.toArray(new Activity[this.activities.size()]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int getType() {
        return 1002;
    }

    public OptionalActivityIterator getIterator() {
        return new OptionalActivityIterator(this);
    }

    public ActivityIterator iterator() {
        return null;
    }

    public int getMinRequired() {
        return this.definition.getMinNumberComplete();
    }
}

