/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.SingleTask;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.ToolProxy;
import com.webmcq.ld.controller.dao.ToolNotFoundException;
import com.webmcq.ld.controller.design.TaskManager;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.controller.learner.Group;
import com.webmcq.ld.util.exception.SystemException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class SingleTaskInstance
extends TaskInstance {
    private boolean complete;
    private Set completedLearners;
    private ToolProxy toolProxy;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$SingleTaskInstance == null ? (class$com$webmcq$ld$controller$SingleTaskInstance = SingleTaskInstance.class$("com.webmcq.ld.controller.SingleTaskInstance")) : class$com$webmcq$ld$controller$SingleTaskInstance));
    static /* synthetic */ Class class$com$webmcq$ld$controller$SingleTaskInstance;

    protected SingleTaskInstance() {
    }

    public SingleTaskInstance(LearningSession lsession, Group group, Task task) {
        super(lsession, group);
        this.complete = false;
        this.completedLearners = new HashSet();
        this.setTask(task);
    }

    public Task getTask() {
        return TaskManager.getSingleTask(this.getTaskSid());
    }

    private void setTask(Task task) {
        if (task == null) {
            this.setTaskSid(0L);
        } else {
            this.setTaskSid(task.getSid());
        }
    }

    public TaskInstanceData getData() {
        return new TaskInstanceData(this.getSid(), this.getTask().getTitle(), 0, this.getTaskSid(), this.getLearningSession().getOwnerId(), null, this.getLearningSession().getSid());
    }

    public String getToolType() {
        return ((SingleTask)this.getTask()).getToolType();
    }

    public void prepareTool() throws ControllerException, SystemException {
        try {
            log.debug((Object)("prepareTool: " + this.getSid()));
            if (this.getToolProxy() != null) {
                log.debug((Object)"prepareTool: already bound");
                return;
            }
            log.debug((Object)"prepareTool: binding");
            ToolProxy tool = ToolProxy.findToolProxy(this.getToolType());
            log.debug((Object)("prepareTool: tool found " + tool));
            tool.bindTaskInstance(this);
        }
        catch (ToolNotFoundException e) {
            throw new SystemException(e);
        }
    }

    public DisplayTaskData run(Learner learner) {
        log.info((Object)("run: learner " + learner.getSid()));
        DisplayTaskData displayTaskData = new DisplayTaskData(43);
        displayTaskData.setSessionId(learner.getLearningSession().getSid());
        displayTaskData.setTaskId(this.getSid());
        displayTaskData.setUrlA(this.getToolProxy().getUrl(this, "run"));
        return displayTaskData;
    }

    public DisplayTaskData view() {
        DisplayTaskData displayTaskData = new DisplayTaskData(52);
        displayTaskData.setUrlA(this.getToolProxy().getUrl(this, "view"));
        return displayTaskData;
    }

    public String[] checkup(Learner learner) {
        String[] urls = new String[]{this.getToolProxy().getUrl(this, "checkup") + "&userId=" + learner.getUserId()};
        return urls;
    }

    public DisplayTaskData resume(Learner learner) {
        log.info((Object)("resume: learner " + learner.getSid()));
        DisplayTaskData displayTaskData = new DisplayTaskData(50);
        displayTaskData.setSessionId(learner.getLearningSession().getSid());
        displayTaskData.setTaskId(this.getSid());
        displayTaskData.setUrlA(this.getToolProxy().getUrl(this, "resume"));
        return displayTaskData;
    }

    public ToolProxy getToolProxy() {
        return this.toolProxy;
    }

    public void setToolProxy(ToolProxy toolProxy) {
        this.toolProxy = toolProxy;
    }

    public boolean getComplete() {
        return this.complete;
    }

    public boolean isComplete() {
        return this.complete;
    }

    protected void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void complete(Learner learner) {
        log.debug((Object)("learner: " + learner));
        log.debug((Object)("completedLearners: " + this.completedLearners));
        log.debug((Object)("getGroup: " + this.getGroup()));
        log.debug((Object)("complete: task instance '" + this.getSid() + "'"));
        this.completedLearners.add(new Long(learner.getSid()));
        if (this.getCompletedLearners().size() == this.getGroup().size()) {
            this.setComplete(true);
        }
        log.debug((Object)("complete: set size: " + this.getCompletedLearners().size()));
    }

    public Set getCompletedLearners() {
        return this.completedLearners;
    }

    public int getCompletedLearnersCount() {
        return this.completedLearners.size();
    }

    private void setCompletedLearners(Set completedLearners) {
        this.completedLearners = completedLearners;
    }

    public boolean hasCompleted(Learner learner) {
        return this.completedLearners.contains(new Long(learner.getSid()));
    }

    public String toString() {
        return super.toString() + new ToStringBuilder((Object)this).append("complete", this.complete).append("completedLearners", this.completedLearners.size()).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

