/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.learner;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class Group
implements Serializable {
    private long sid;
    private String name;
    private Map members;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$learner$Group == null ? (class$com$webmcq$ld$controller$learner$Group = Group.class$("com.webmcq.ld.controller.learner.Group")) : class$com$webmcq$ld$controller$learner$Group));
    static /* synthetic */ Class class$com$webmcq$ld$controller$learner$Group;

    private Group() {
    }

    public Group(String name) {
        this.name = name;
        this.members = new HashMap();
    }

    public long getSid() {
        return this.sid;
    }

    private void setSid(long sid) {
        this.sid = sid;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public Map getMembers() {
        return this.members;
    }

    private void setMembers(Map members) {
        this.members = members;
    }

    public void join(Learner learner) throws ControllerException {
        if (this.hasJoined(learner)) {
            throw new ControllerException("UserData " + learner.getUserId() + " has already joined the group '" + this.getSid() + "'");
        }
        this.members.put(new Long(learner.getUserId()), learner);
    }

    public boolean hasJoined(Learner learner) {
        log.debug((Object)("learner: " + learner));
        return this.hasJoined(learner.getUserId());
    }

    public boolean hasJoined(long userId) {
        log.debug((Object)("members: " + this.members));
        return this.members.containsKey(new Long(userId));
    }

    public int size() {
        return this.members.size();
    }

    public void toNextTask(PersistenceSession sess) throws ControllerException {
        Iterator i = this.members.keySet().iterator();
        while (i.hasNext()) {
            Learner learner = (Learner)this.members.get(i.next());
            learner.toNextTask(sess, learner.getNextTaskInstance(sess));
        }
    }

    public boolean checkCompletion() {
        Iterator i = this.members.keySet().iterator();
        while (i.hasNext()) {
            Learner learner = (Learner)this.members.get(i.next());
            if (learner.getStatus() == 4) continue;
            return false;
        }
        return true;
    }

    public Learner findLearner(ShwaaUserData user) {
        return (Learner)this.members.get(user.getUid());
    }

    public Learner findLearner(long userId) {
        return (Learner)this.members.get(new Long(userId));
    }

    public boolean isMember(Long userId) {
        return this.members.containsKey(userId);
    }

    public Iterator getUserIds() {
        return this.members.keySet().iterator();
    }

    public Learner[] getLearners() {
        return this.members.values().toArray(new Learner[this.members.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

