/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.filemanager;

import com.allaire.wddx.WddxDeserializationException;
import com.webmcq.ld.tool.filemanager.FileManagerException;
import com.webmcq.ld.tool.filemanager.FileManagerService;
import com.webmcq.ld.tool.filemanager.FileManagerServiceHome;
import com.webmcq.ld.tool.filemanager.IllegalFileException;
import com.webmcq.ld.util.EJBHomeFactory;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.log4j.Logger;

public class FileManagerDelegate {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$filemanager$FileManagerDelegate == null ? (class$com$webmcq$ld$tool$filemanager$FileManagerDelegate = FileManagerDelegate.class$("com.webmcq.ld.tool.filemanager.FileManagerDelegate")) : class$com$webmcq$ld$tool$filemanager$FileManagerDelegate));
    static /* synthetic */ Class class$com$webmcq$ld$tool$filemanager$FileManagerDelegate;
    static /* synthetic */ Class class$com$webmcq$ld$tool$filemanager$FileManagerServiceHome;

    public static String uploadFile(FileItem fileToUpload, String originalFilename, Integer taskInstanceId, boolean preferDownload, boolean extractWebContent, boolean allowExecutables) throws FileManagerException, IllegalFileException, Throwable {
        String value = null;
        try {
            FileManagerService service = FileManagerDelegate.getService();
            value = service.uploadFile(fileToUpload, originalFilename, taskInstanceId, preferDownload, extractWebContent, allowExecutables);
            FileManagerDelegate.remove(service);
        }
        catch (RemoteException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw new FileManagerException(e);
        }
        return value;
    }

    public static String uploadResource(FileItem fileToUpload, String originalFilename, String directoryName, Integer taskInstanceId, boolean allowExecutables) throws FileManagerException, IllegalFileException, Throwable {
        String value = null;
        try {
            FileManagerService service = FileManagerDelegate.getService();
            value = service.uploadResource(fileToUpload, originalFilename, directoryName, allowExecutables);
            FileManagerDelegate.remove(service);
        }
        catch (RemoteException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw new FileManagerException(e);
        }
        return value;
    }

    public static boolean deleteResource(String fileName, String directoryName) throws FileManagerException, IllegalFileException {
        boolean value;
        try {
            FileManagerService service = FileManagerDelegate.getService();
            value = service.deleteResource(fileName, directoryName);
            FileManagerDelegate.remove(service);
        }
        catch (RemoteException e) {
            throw new FileManagerException(e);
        }
        return value;
    }

    public static boolean copyDirectory(String source, String destination) throws FileManagerException, IllegalFileException {
        boolean value;
        try {
            FileManagerService service = FileManagerDelegate.getService();
            value = service.copyDirectory(source, destination);
            FileManagerDelegate.remove(service);
        }
        catch (RemoteException e) {
            throw new FileManagerException(e);
        }
        return value;
    }

    public static boolean createTextFile(String fileName, String fileDirectory, String content) throws FileManagerException, Throwable {
        boolean value = false;
        try {
            FileManagerService service = FileManagerDelegate.getService();
            value = service.createTextFile(fileName, fileDirectory, content);
            FileManagerDelegate.remove(service);
        }
        catch (RemoteException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw new FileManagerException(e);
        }
        return value;
    }

    public static String readTextFile(String fileName, String fileDirectory) throws FileManagerException, Throwable {
        String value = new String("");
        try {
            FileManagerService service = FileManagerDelegate.getService();
            value = service.readTextFile(fileName, fileDirectory);
            FileManagerDelegate.remove(service);
        }
        catch (RemoteException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw new FileManagerException(e);
        }
        return value;
    }

    public static Long importDesign(String username, FileItem fileToUpload, String originalFilename, String submittedTitle, String fileExtension) throws FileManagerException, IllegalFileException, Throwable {
        try {
            FileManagerService service = FileManagerDelegate.getService();
            Long ldId = service.importDesign(username, fileToUpload, originalFilename, submittedTitle, fileExtension);
            FileManagerDelegate.remove(service);
            return ldId;
        }
        catch (RemoteException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw new FileManagerException(e);
        }
    }

    public static void sendFile(String uriString, HttpServletResponse res, ServletContext context, boolean preferDownload) throws IOException {
        try {
            FileManagerService service = FileManagerDelegate.getService();
            service.sendFile(uriString, res, context, preferDownload);
            FileManagerDelegate.remove(service);
        }
        catch (RemoteException e) {
            throw new IOException(e.getClass().getName());
        }
    }

    public static void sendDesign(String username, String ldid, HttpServletResponse res, ServletContext context, String exportType) throws FileManagerException, NamingException, ServletException, WddxDeserializationException, Exception {
        try {
            FileManagerService service = FileManagerDelegate.getService();
            service.sendDesign(username, ldid, res, context, exportType);
            FileManagerDelegate.remove(service);
        }
        catch (RemoteException e) {
            throw new FileManagerException(e);
        }
    }

    public static String getAccessUrl(String uriString, HttpServletResponse res, HttpServletRequest req, boolean preferDownload) {
        String value = null;
        try {
            FileManagerService service = FileManagerDelegate.getService();
            value = service.getAccessUrl(uriString, res, req, preferDownload);
            FileManagerDelegate.remove(service);
        }
        catch (RemoteException e) {
            throw new FileManagerException(e);
        }
        return value;
    }

    public static int isSupportedType(String uriString) {
        int value = 0;
        try {
            FileManagerService service = FileManagerDelegate.getService();
            value = service.isSupportedType(uriString);
            FileManagerDelegate.remove(service);
        }
        catch (RemoteException e) {
            throw new FileManagerException(e);
        }
        return value;
    }

    public static String getDirectoryName() throws FileManagerException, Throwable {
        String value = new String("");
        try {
            FileManagerService service = FileManagerDelegate.getService();
            value = service.getDirectoryName();
            FileManagerDelegate.remove(service);
        }
        catch (RemoteException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw new FileManagerException(e);
        }
        return value;
    }

    private static FileManagerService getService() {
        try {
            FileManagerServiceHome home = (FileManagerServiceHome)EJBHomeFactory.getInstance().lookup("ejb/tool/filemanager/FileManagerService", class$com$webmcq$ld$tool$filemanager$FileManagerServiceHome == null ? (class$com$webmcq$ld$tool$filemanager$FileManagerServiceHome = FileManagerDelegate.class$("com.webmcq.ld.tool.filemanager.FileManagerServiceHome")) : class$com$webmcq$ld$tool$filemanager$FileManagerServiceHome);
            return home.create();
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private static void remove(FileManagerService service) {
        try {
            service.remove();
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public static String getUploadDir() {
        String uploadDir;
        FileManagerService service = FileManagerDelegate.getService();
        try {
            uploadDir = service.getUploadDir();
        }
        catch (RemoteException e) {
            log.error((Object)e);
            throw new FileManagerException(e);
        }
        return uploadDir;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

