/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.nb;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.interfaces.ContentRepositoryLocal;
import com.webmcq.ld.content.interfaces.ContentRepositoryUtil;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.tool.StaffMonitorNotifier;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.nb.NBException;
import com.webmcq.ld.tool.nb.interfaces.NBEntryData;
import com.webmcq.ld.tool.nb.interfaces.NBEntryLocal;
import com.webmcq.ld.tool.nb.interfaces.NBEntryLocalHome;
import com.webmcq.ld.tool.nb.interfaces.NBEntryPK;
import com.webmcq.ld.tool.nb.interfaces.NBEntryUtil;
import com.webmcq.ld.tool.nb.interfaces.NBSectionData;
import com.webmcq.ld.tool.nb.interfaces.NBSectionLocal;
import com.webmcq.ld.tool.nb.interfaces.NBSectionLocalHome;
import com.webmcq.ld.tool.nb.interfaces.NBSectionPK;
import com.webmcq.ld.tool.nb.interfaces.NBSectionUtil;
import com.webmcq.ld.tool.nb.interfaces.NBUserData;
import com.webmcq.ld.tool.nb.interfaces.NBUserLocal;
import com.webmcq.ld.tool.nb.interfaces.NBUserUtil;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.EJBUtil;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import net.sf.hibernate.HibernateException;
import org.apache.log4j.Logger;

public abstract class NBServiceBean
extends BaseSessionBean {
    public static final String TOOL_TYPE = "nb";
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$nb$NBServiceBean == null ? (class$com$webmcq$ld$tool$nb$NBServiceBean = NBServiceBean.class$("com.webmcq.ld.tool.nb.NBServiceBean")) : class$com$webmcq$ld$tool$nb$NBServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$tool$nb$NBServiceBean;

    public void createSession(AbstractTaskVO abTask, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            log.debug((Object)("createSession: session id : " + taskInstance.getSid()));
            SimpleTaskVO task = (SimpleTaskVO)abTask;
            this.createSession(task, taskInstance, group, inputContentId);
            Content[] contents = ContentServiceDelegate.getContents(inputContentId);
            log.debug((Object)("content received: " + contents.length));
            this.postToSession(taskInstance.getSid(), contents);
            this.notifyNoticeBoard(taskInstance.getSid(), task.getTitle());
        }
        catch (NBException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ToolException(e);
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            throw new SystemException(e);
        }
    }

    private void createSession(SimpleTaskVO task, TaskInstanceData instance, GroupData group, long contentId) {
        try {
            NBSectionLocal section = NBSectionUtil.getLocalHome().create(task.getTitle());
            section.setSessionId(instance.getSid());
            section.setContentId(contentId);
        }
        catch (NamingException e) {
            throw new SystemException(e);
        }
        catch (CreateException e) {
            throw new SystemException(e);
        }
    }

    public NBUserData findUser(String login) {
        try {
            Collection coll = NBUserUtil.getLocalHome().findByLogin(login);
            NBUserLocal user = (NBUserLocal)EJBUtil.findSingle(coll);
            return user.getData();
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            e.printStackTrace();
            throw new EJBException((Exception)((Object)e));
        }
    }

    public DisplayTaskData completeSession(long userId, int sessionId) throws NBException {
        try {
            DisplayTaskData displayTaskData = null;
            Collection coll = NBSectionUtil.getLocalHome().findBySessionId(sessionId);
            NBSectionLocal section = (NBSectionLocal)EJBUtil.findSingle(coll);
            if (section == null) {
                throw new NBException("no such session found: '" + sessionId + "'");
            }
            displayTaskData = LearnerServiceDelegate.moveToNextTask(sessionId, userId);
            return displayTaskData;
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            e.printStackTrace();
            throw new EJBException((Exception)((Object)e));
        }
        catch (TaskInstanceNotFoundException e) {
            throw new NBException("Task Instance not found", e);
        }
        catch (ControllerException e) {
            throw new NBException("Controller reported an error", e);
        }
        catch (SystemException e) {
            throw e;
        }
    }

    public NBSectionData getSectionBySession(int sessionId) {
        try {
            Collection coll = NBSectionUtil.getLocalHome().findBySessionId(sessionId);
            NBSectionLocal section = (NBSectionLocal)EJBUtil.findSingle(coll);
            if (section != null) {
                return section.getData();
            }
            return null;
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            return null;
        }
    }

    public void refresh(long sectionId) {
        try {
            NBEntryLocalHome home = NBEntryUtil.getLocalHome();
            NBSectionPK pk = new NBSectionPK(sectionId);
            NBSectionLocal section = NBSectionUtil.getLocalHome().findByPrimaryKey(pk);
            long contentId = section.getContentId();
            ContentRepositoryLocal repo = ContentRepositoryUtil.getLocalHome().create();
            Content[] contents = repo.getContents(contentId);
            repo.remove();
            if (contents.length == this.getNumberOfDistinctEntries(sectionId)) {
                return;
            }
            for (int i = 0; i < contents.length; ++i) {
                long cid = contents[i].getSid();
                if (home.findByContentId(cid).size() != 0) continue;
                this.addContent(section, contents[i]);
            }
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (RemoveException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void insertEntry(long sectionId, String newTitle, String newContent) throws NBException {
        try {
            NBSectionPK pk = new NBSectionPK(sectionId);
            NBSectionLocal section = NBSectionUtil.getLocalHome().findByPrimaryKey(pk);
            Collection coll = section.getEntries();
            Iterator itr = coll.iterator();
            if (coll.size() > 0) {
                NBEntryLocal entryFirst = (NBEntryLocal)itr.next();
                NBEntryLocal entry = NBEntryUtil.getLocalHome().create(newTitle);
                entry.setContent(newContent);
                entry.setContentId(entryFirst.getContentId());
                entry.setDefineLater(new Boolean(false));
                section.getEntries().add(entry);
            }
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void updateEntry(int entryId, String newTitle, String newContent) throws NBException {
        try {
            NBEntryPK pk = new NBEntryPK(entryId);
            NBEntryLocal entry = NBEntryUtil.getLocalHome().findByPrimaryKey(pk);
            if (entry == null) {
                throw new NBException("no such entry found");
            }
            entry.setTitle(newTitle);
            entry.setContent(newContent);
            entry.setDefineLater(new Boolean(false));
            entry.setIsHTML(new Boolean(false));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public NBEntryData[] getEntries(long sectionId) {
        try {
            NBSectionPK pk = new NBSectionPK(sectionId);
            NBSectionLocal section = NBSectionUtil.getLocalHome().findByPrimaryKey(pk);
            Collection coll = section.getEntries();
            NBEntryData[] entries = new NBEntryData[coll.size()];
            Iterator itr = coll.iterator();
            int i = 0;
            while (itr.hasNext()) {
                NBEntryLocal entry = (NBEntryLocal)itr.next();
                entries[i] = entry.getData();
                ++i;
            }
            return entries;
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            return null;
        }
    }

    public void post(long sectionId, Content[] contents) throws NBException {
        try {
            NBSectionPK pk = new NBSectionPK(sectionId);
            NBSectionLocal section = NBSectionUtil.getLocalHome().findByPrimaryKey(pk);
            for (int i = 0; i < contents.length; ++i) {
                this.addContent(section, contents[i]);
            }
        }
        catch (FinderException e) {
            throw new NBException("section '" + sectionId + "' not found");
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getNumberOfDistinctEntries(long sectionId) {
        int entriesNumber = 0;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String queryString = "SELECT COUNT(DISTINCT contentId) FROM nb_entry WHERE section_Id=?";
        PersistenceSession sess = null;
        try {
            try {
                sess = new PersistenceSession();
                conn = sess.persistece().connection();
                stmt = conn.prepareStatement(queryString);
                stmt.setLong(1, sectionId);
                rs = stmt.executeQuery();
                rs.next();
                entriesNumber = rs.getInt(1);
            }
            catch (HibernateException eHi) {
                throw new EJBException((Exception)((Object)eHi));
            }
            catch (SQLException sqle) {
                throw new EJBException((Exception)sqle);
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            sess.close();
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            catch (SQLException sqle2) {
                throw new EJBException((Exception)sqle2);
            }
        }
        sess.close();
        try {}
        catch (SQLException sqle2) {
            throw new EJBException((Exception)sqle2);
        }
        if (rs != null) {
            rs.close();
        }
        if (stmt == null) return entriesNumber;
        stmt.close();
        return entriesNumber;
    }

    private void addContent(NBSectionLocal section, Content content) {
        try {
            NBEntryLocal entry = NBEntryUtil.getLocalHome().create(content.getTitle());
            entry.setContent(content.getBody());
            entry.setContentURL(content.getBodyURL());
            entry.setPostDate(content.getDateCreatedJavaDate());
            entry.setContentId(content.getSid());
            entry.setDefineLater(content.isDefineLater());
            entry.setIsHTML(content.isHTML());
            section.getEntries().add(entry);
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void postToSession(long sessionId, Content[] contents) throws NBException {
        try {
            Collection coll = NBSectionUtil.getLocalHome().findBySessionId(sessionId);
            NBSectionLocal section = (NBSectionLocal)EJBUtil.findSingle(coll);
            for (int i = 0; i < contents.length; ++i) {
                this.addContent(section, contents[i]);
            }
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new NBException(e);
        }
    }

    public void notifyNoticeBoard(long taskInstanceId, String title) throws NBException {
        try {
            String toolpath = "tool/nb/nb.do?method=getMonitorNoticeBoard&sessionId=" + taskInstanceId;
            StaffMonitorNotifier.notifyControllerOfURL(taskInstanceId, TOOL_TYPE, title, toolpath);
        }
        catch (ControllerException e) {
            throw new NBException(e);
        }
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            this.deleteSession(taskInstance);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            throw new SystemException(e);
        }
    }

    public void deleteSession(TaskInstance instance) {
        try {
            NBSectionLocalHome localHome = NBSectionUtil.getLocalHome();
            Collection coll = localHome.findBySessionId(instance.getSid());
            Iterator iter = coll.iterator();
            NBSectionLocal nbLocal = null;
            while (iter.hasNext()) {
                nbLocal = (NBSectionLocal)iter.next();
                nbLocal.remove();
            }
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

