/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.qna.web;

import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.qna.QNAException;
import com.webmcq.ld.tool.qna.dto.QNADTOFactory;
import com.webmcq.ld.tool.qna.dto.QuestionAnswerData;
import com.webmcq.ld.tool.qna.interfaces.QNAService;
import com.webmcq.ld.tool.qna.interfaces.QNAServiceUtil;
import com.webmcq.ld.usermanagement.UserRole;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;
import javax.ejb.CreateException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class QNAAction
extends ToolAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$qna$web$QNAAction == null ? (class$com$webmcq$ld$tool$qna$web$QNAAction = QNAAction.class$("com.webmcq.ld.tool.qna.web.QNAAction")) : class$com$webmcq$ld$tool$qna$web$QNAAction));
    public static final String TASK_INSTANCE_ID_TAG = "sessionId";
    public static final String MODE_TAG = "mode";
    public static final String SESSION_TAG = "session";
    public static final String VIEW_ONLY_MODE_TAG = "viewOnly";
    public static final String MODIFY_MODE_TAG = "modify";
    public static final String PREVIEW_CHECKUP = "previewCheckup";
    public static final String ENTRY_TAG = "entry";
    public static final String ANSWER_TAG = "answer";
    public static final String ERROR_TAG = "error";
    public static final String STUDENT_ID_TAG = "userId";
    public static final String NEW_QUESTION_CONTENT_TAG = "newQuestionContent";
    public static final String NEW_QUESTION_TITLE_TAG = "newQuestionTitle";
    public static final String QUESTION_ID_TAG = "questionId";
    static /* synthetic */ Class class$com$webmcq$ld$tool$qna$web$QNAAction;

    public ActionForward dispatch(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        return this.getEntry(mapping, form, req, res);
    }

    public ActionForward getEntry(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            QNAService service;
            QuestionAnswerData[] entries;
            String mode = WebUtil.readStrParam(req, MODE_TAG);
            log.debug((Object)("getEntry mode" + mode));
            String sessionType = (String)req.getSession().getAttribute(SESSION_TAG);
            if (mode.equals("view") && sessionType != null && sessionType.equals("preview")) {
                req.setAttribute(PREVIEW_CHECKUP, (Object)PREVIEW_CHECKUP);
            }
            int sessionId = WebUtil.readIntParam(req, TASK_INSTANCE_ID_TAG);
            long userId = -1L;
            String username = null;
            if ("view".equals(mode)) {
                req.setAttribute(VIEW_ONLY_MODE_TAG, (Object)mode);
            } else if ("checkup".equals(mode)) {
                req.setAttribute(VIEW_ONLY_MODE_TAG, (Object)mode);
                userId = WebUtil.readLongParam(req, STUDENT_ID_TAG);
                if (userId == -1L) {
                    log.warn((Object)"getEntry: In checkup mode but student id is missing.");
                }
            }
            if (userId == -1L) {
                username = WebUtil.getUsername(req);
                userId = UserServiceDelegate.findUserId(username);
            }
            if ((entries = (service = QNAServiceUtil.getHome().create()).getAnswer(userId, username, sessionId)) == null) {
                req.setAttribute(ERROR_TAG, (Object)"Unable to find question details");
                entries = QNADTOFactory.createDummyQAData();
            }
            for (int indexEntry = 0; indexEntry < entries.length; ++indexEntry) {
                Boolean defineLater = entries[indexEntry].getDefineLater();
                if (defineLater == null || !defineLater.booleanValue()) continue;
                req.setAttribute(MODIFY_MODE_TAG, (Object)"todefine");
                req.setAttribute(VIEW_ONLY_MODE_TAG, (Object)"view");
                break;
            }
            service.remove();
            req.setAttribute(SESSION_TAG, (Object)sessionType);
            req.setAttribute(TASK_INSTANCE_ID_TAG, (Object)Integer.toString(sessionId));
            req.setAttribute("entries", (Object)entries);
            req.setAttribute("entriesNumber", (Object)Integer.toString(entries.length));
            WebUtil.saveToken(req, "transactionKeyQuestionAnswer", this.generateToken(req));
            return mapping.findForward(ENTRY_TAG);
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward getAllAnswers(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String error = null;
            QuestionAnswerData[] entries = null;
            int sessionId = WebUtil.readIntParam(req, TASK_INSTANCE_ID_TAG);
            if (!req.isUserInRole(UserRole.STAFF.getName())) {
                log.error((Object)("upload: Request to view all answers but user " + WebUtil.getUsername(req) + " not entitled to upload a file (must have Staff role)"));
                entries = QNADTOFactory.createDummyQAData();
                error = "You need staff privilege to view the answers";
            } else {
                QNAService service = QNAServiceUtil.getHome().create();
                entries = service.getAllAnswers(sessionId);
                service.remove();
                if (entries == null) {
                    req.setAttribute(ERROR_TAG, (Object)"Unable to find question details");
                    entries = QNADTOFactory.createDummyQAData();
                }
                if (req.isUserInRole(UserRole.STAFF.getName())) {
                    for (int indexEntry = 0; indexEntry < entries.length; ++indexEntry) {
                        Boolean defineLater = entries[indexEntry].getDefineLater();
                        if (defineLater == null || !defineLater.booleanValue()) continue;
                        req.setAttribute("entrytoupdate", (Object)entries[indexEntry]);
                        req.setAttribute(MODIFY_MODE_TAG, (Object)"todefine");
                        break;
                    }
                }
            }
            req.setAttribute(TASK_INSTANCE_ID_TAG, (Object)Integer.toString(sessionId));
            req.setAttribute("entries", (Object)entries);
            if (error != null) {
                req.setAttribute(ERROR_TAG, (Object)error);
            }
            return mapping.findForward("allanswers");
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward completeSession(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            if (WebUtil.isTokenValid(req, "transactionKeyQuestionAnswer")) {
                WebUtil.resetToken(req, "transactionKeyQuestionAnswer");
                req.getSession().removeAttribute("transactionDoneQna");
                log.debug((Object)"completeSession");
                String username = WebUtil.getUsername(req);
                long userId = UserServiceDelegate.findUserId(username);
                int sessionId = WebUtil.readIntParam(req, TASK_INSTANCE_ID_TAG);
                String[] contents = req.getParameterValues(ANSWER_TAG);
                String[] questionsId = req.getParameterValues(QUESTION_ID_TAG);
                QNAService service = QNAServiceUtil.getHome().create();
                if (contents != null) {
                    for (int contentIndex = 0; contentIndex < contents.length; ++contentIndex) {
                        service.setAnswer(username, userId, sessionId, contents[contentIndex], Integer.parseInt(questionsId[contentIndex]));
                    }
                }
                DisplayTaskData displayTaskData = service.completeSession(userId, sessionId);
                service.remove();
                ActionForward action = this.displayTask(displayTaskData, mapping, form, req, res);
                req.getSession().setAttribute("transactionDoneQna", (Object)action);
                return action;
            }
            return this.duplicateSubmission(mapping, req, "transactionDoneQna");
        }
        catch (QNAException e) {
            throw new SystemException(e);
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
        catch (RemoveException e) {
            throw new SystemException(e.getMessage());
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward insertQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"insertQuestion");
            QuestionAnswerData[] entries = null;
            int sessionId = WebUtil.readIntParam(req, TASK_INSTANCE_ID_TAG);
            String newQuestionTitle = req.getParameter(NEW_QUESTION_TITLE_TAG);
            String newQuestionContent = req.getParameter(NEW_QUESTION_CONTENT_TAG);
            QNAService service = QNAServiceUtil.getHome().create();
            service.insertQuestion(sessionId, newQuestionTitle, newQuestionContent);
            entries = service.getAllAnswers(sessionId);
            req.setAttribute("entries", (Object)entries);
            return mapping.findForward("allanswers");
        }
        catch (QNAException e) {
            throw new SystemException(e);
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
    }

    public ActionForward updateQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"insertQuestion");
            QuestionAnswerData[] entries = null;
            int sessionId = WebUtil.readIntParam(req, TASK_INSTANCE_ID_TAG);
            String newQuestionTitle = req.getParameter(NEW_QUESTION_TITLE_TAG);
            String newQuestionContent = req.getParameter(NEW_QUESTION_CONTENT_TAG);
            int questionsId = WebUtil.readIntParam(req, QUESTION_ID_TAG);
            QNAService service = QNAServiceUtil.getHome().create();
            service.updateQuestion(questionsId, newQuestionTitle, newQuestionContent);
            entries = service.getAllAnswers(sessionId);
            req.setAttribute("entries", (Object)entries);
            return mapping.findForward("allanswers");
        }
        catch (QNAException e) {
            throw new SystemException(e);
        }
        catch (CreateException e) {
            throw new SystemException(e.getMessage());
        }
        catch (NamingException e) {
            throw new SystemException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

