/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.reportsubmission;

import com.webmcq.ld.tool.reportsubmission.interfaces.LearnerReportData;
import com.webmcq.ld.tool.reportsubmission.interfaces.LearnerReportPK;
import com.webmcq.ld.tool.reportsubmission.interfaces.ReportReviewData;
import com.webmcq.ld.tool.reportsubmission.interfaces.ReportReviewLocal;
import com.webmcq.ld.tool.reportsubmission.interfaces.ReportReviewUtil;
import com.webmcq.ld.util.BaseEntityBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class LearnerReportBean
extends BaseEntityBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$reportsubmission$LearnerReportBean == null ? (class$com$webmcq$ld$tool$reportsubmission$LearnerReportBean = LearnerReportBean.class$("com.webmcq.ld.tool.reportsubmission.LearnerReportBean")) : class$com$webmcq$ld$tool$reportsubmission$LearnerReportBean));
    static /* synthetic */ Class class$com$webmcq$ld$tool$reportsubmission$LearnerReportBean;

    public abstract int getSid();

    public abstract void setSid(int var1);

    public abstract long getTaskInstanceId();

    public abstract void setTaskInstanceId(long var1);

    public abstract Long getSubmitterUserId();

    public abstract void setSubmitterUserId(Long var1);

    public abstract String getFilename();

    public abstract void setFilename(String var1);

    public abstract String getFilenameNoPath();

    public abstract void setFilenameNoPath(String var1);

    public abstract String getOriginalFilename();

    public abstract void setOriginalFilename(String var1);

    public abstract String getFileDescription();

    public abstract void setFileDescription(String var1);

    public abstract Date getDateSubmitted();

    public abstract void setDateSubmitted(Date var1);

    public abstract Collection getReviews();

    public abstract void setReviews(Collection var1);

    public void addReview(ReportReviewLocal review) {
        this.getReviews().add(review);
    }

    public void removeReview(ReportReviewLocal review) {
        this.getReviews().remove(review);
    }

    public void setReviewSent(long receiverUserId) {
        ReportReviewLocal review;
        Collection reviews = this.getReviews();
        Iterator iter = reviews.iterator();
        boolean reviewFound = false;
        while (iter.hasNext()) {
            review = (ReportReviewLocal)iter.next();
            if (review.getReviewerUserId() == null || review.getReviewerUserId() != receiverUserId) continue;
            review.setReportSent(true);
            reviewFound = true;
        }
        if (!reviewFound && (review = this.createReview(receiverUserId)) != null) {
            review.setReportSent(true);
        }
    }

    private ReportReviewLocal createReview(long receiverUserId) {
        ReportReviewLocal review = null;
        try {
            review = ReportReviewUtil.getLocalHome().create();
            review.setTaskInstanceId(this.getTaskInstanceId());
            review.setReviewerUserId(new Long(receiverUserId));
        }
        catch (CreateException e) {
        }
        catch (NamingException e) {
            // empty catch block
        }
        return review;
    }

    public ReportReviewLocal setReviewMarks(long receiverUserId, String mark, String comment, String filename) {
        Collection reviews = this.getReviews();
        Iterator iter = reviews.iterator();
        ReportReviewLocal review = null;
        while (iter.hasNext() && review == null) {
            ReportReviewLocal tempReview = (ReportReviewLocal)iter.next();
            if (tempReview.getReviewerUserId() == null || tempReview.getReviewerUserId() != receiverUserId) continue;
            review = tempReview;
        }
        if (review == null) {
            review = this.createReview(receiverUserId);
        }
        review.setMark(mark);
        review.setReviewersComment(comment);
        review.setReviewFilename(filename);
        return review;
    }

    public List getReviewData() {
        ArrayList<ReportReviewData> results = new ArrayList<ReportReviewData>(this.getReviews().size());
        Collection reviews = this.getReviews();
        Iterator iter = reviews.iterator();
        while (iter.hasNext()) {
            ReportReviewLocal review = (ReportReviewLocal)iter.next();
            results.add(review.getData());
        }
        return results;
    }

    public boolean needsMarking() {
        Collection reviews = this.getReviews();
        if (reviews == null) {
            return false;
        }
        Iterator iter = reviews.iterator();
        while (iter.hasNext()) {
            ReportReviewLocal review = (ReportReviewLocal)iter.next();
            if (review.isMarked()) continue;
            return true;
        }
        return false;
    }

    public LearnerReportPK ejbCreate() throws CreateException {
        this.setSid(this.nextId());
        return null;
    }

    public void ejbPostCreate() {
    }

    public abstract LearnerReportData getData();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

