/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.voterank;

import com.webmcq.ld.tool.voterank.interfaces.PollContentData;
import com.webmcq.ld.tool.voterank.interfaces.PollContentPK;
import com.webmcq.ld.tool.voterank.interfaces.PollNominationLocal;
import com.webmcq.ld.tool.voterank.interfaces.VoteLocal;
import com.webmcq.ld.tool.voterank.interfaces.VoteUtil;
import com.webmcq.ld.util.BaseEntityBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.naming.NamingException;

public abstract class PollContentBean
extends BaseEntityBean {
    public static int INPROGRESS = 1;
    public static int COMPLETE = 3;

    public abstract int getSid();

    public abstract void setSid(int var1);

    public abstract long getTaskInstanceId();

    public abstract void setTaskInstanceId(long var1);

    public abstract String getTitle();

    public abstract void setTitle(String var1);

    public abstract String getContent();

    public abstract void setContent(String var1);

    public abstract String getDescription();

    public abstract void setDescription(String var1);

    public abstract Collection getNominations();

    public abstract void setNominations(Collection var1);

    public void addNomination(PollNominationLocal nom) {
        Collection nominations = this.getNominations();
        nominations.add(nom);
    }

    public void removeNomination(PollNominationLocal nom) {
        Collection nominations = this.getNominations();
        nominations.remove(nom);
    }

    public Set getNominationsAsStrings() {
        HashSet<String> strings = null;
        ArrayList nominationEjbs = new ArrayList(this.getNominations());
        if (nominationEjbs != null) {
            strings = new HashSet<String>(nominationEjbs.size());
            Iterator iter = nominationEjbs.iterator();
            while (iter.hasNext()) {
                PollNominationLocal nomination = (PollNominationLocal)iter.next();
                strings.add(nomination.getText());
            }
        }
        return strings;
    }

    public abstract Collection getVotes();

    public abstract void setVotes(Collection var1);

    public void addIndividualVote(VoteLocal vote) throws CreateException, NamingException {
        this.getVotes().add(vote);
        String nominationRef = vote.normaliseNominationString(vote.getNomination());
        ArrayList voteSnapshot = new ArrayList(this.getVotes());
        boolean found = false;
        Iterator iter = voteSnapshot.iterator();
        while (!found && iter.hasNext()) {
            VoteLocal element = (VoteLocal)iter.next();
            if (!element.isSummaryVote() || !nominationRef.equals(element.getNormalisedNomination())) continue;
            element.setNumVotes(element.getNumVotes() + vote.getVoteValue());
            found = true;
        }
        if (!found) {
            VoteLocal summaryVote = VoteUtil.getLocalHome().create(vote.getNomination(), true);
            summaryVote.setVoteValue(0L);
            summaryVote.setUserId(-1L);
            summaryVote.setNumVotes(vote.getVoteValue());
            this.getVotes().add(summaryVote);
        }
    }

    public Collection getIndividualVotes(long userId) {
        HashSet<VoteLocal> indVotes = new HashSet<VoteLocal>();
        ArrayList votes = new ArrayList(this.getVotes());
        Iterator iter = votes.iterator();
        while (iter.hasNext()) {
            VoteLocal vote = (VoteLocal)iter.next();
            if (!vote.isIndividualVote() || vote.getUserId() != userId) continue;
            indVotes.add(vote);
        }
        return indVotes;
    }

    public Collection getIndividualVotes() {
        HashSet<VoteLocal> indVotes = new HashSet<VoteLocal>();
        ArrayList votes = new ArrayList(this.getVotes());
        Iterator iter = votes.iterator();
        while (iter.hasNext()) {
            VoteLocal vote = (VoteLocal)iter.next();
            if (!vote.isIndividualVote()) continue;
            indVotes.add(vote);
        }
        return indVotes;
    }

    public Collection getSummaryVotes() {
        HashSet<VoteLocal> summVotes = new HashSet<VoteLocal>();
        ArrayList votes = new ArrayList(this.getVotes());
        Iterator iter = votes.iterator();
        while (iter.hasNext()) {
            VoteLocal vote = (VoteLocal)iter.next();
            if (!vote.isSummaryVote()) continue;
            summVotes.add(vote);
        }
        return summVotes;
    }

    public abstract Boolean getDefineLater();

    public abstract void setDefineLater(Boolean var1);

    public abstract int getMaxToChoose();

    public abstract void setMaxToChoose(int var1);

    public abstract String getVoteMethod();

    public abstract void setVoteMethod(String var1);

    public abstract boolean getAllowPollNominations();

    public abstract void setAllowPollNominations(boolean var1);

    public PollContentPK ejbCreate() throws CreateException {
        this.setSid(this.nextId());
        this.setCompletionStatus(INPROGRESS);
        return null;
    }

    public void ejbPostCreate() {
    }

    public boolean isPrePollNomination(String nominationValue) {
        if (nominationValue == null) {
            return false;
        }
        ArrayList nominationEjbs = new ArrayList(this.getNominations());
        if (nominationEjbs != null) {
            Iterator iter = nominationEjbs.iterator();
            while (iter.hasNext()) {
                PollNominationLocal nomination = (PollNominationLocal)iter.next();
                if (!nominationValue.equals(nomination.getText())) continue;
                return true;
            }
        }
        return false;
    }

    public abstract int getCompletionStatus();

    public abstract void setCompletionStatus(int var1);

    public boolean setCompletionComplete() {
        this.setCompletionStatus(COMPLETE);
        return true;
    }

    public abstract Long getOutputContentId();

    public abstract void setOutputContentId(Long var1);

    public abstract boolean getProgressiveDisplay();

    public abstract void setProgressiveDisplay(boolean var1);

    public abstract int getNumVoters();

    public abstract void setNumVoters(int var1);

    public abstract int getNumVotersVoted();

    public abstract void setNumVotersVoted(int var1);

    public abstract PollContentData getData();
}

