/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.usermanagement.sysadmin.web;

import com.webmcq.ld.usermanagement.RequestUtil;
import com.webmcq.ld.usermanagement.Rights;
import com.webmcq.ld.usermanagement.UserManagementAuthorisationException;
import com.webmcq.ld.usermanagement.UserManagementException;
import com.webmcq.ld.usermanagement.interfaces.UserManagementService;
import com.webmcq.ld.usermanagement.interfaces.UserManagementServiceUtil;
import com.webmcq.ld.usermanagement.sysadmin.web.OrganisationAddUsersActionForm;
import com.webmcq.ld.usermanagement.sysadmin.web.SystemAdminAction;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import javax.ejb.CreateException;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

public class OrganisationAddUsersAction
extends Action {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$usermanagement$sysadmin$web$OrganisationAddUsersAction == null ? (class$com$webmcq$ld$usermanagement$sysadmin$web$OrganisationAddUsersAction = OrganisationAddUsersAction.class$("com.webmcq.ld.usermanagement.sysadmin.web.OrganisationAddUsersAction")) : class$com$webmcq$ld$usermanagement$sysadmin$web$OrganisationAddUsersAction));
    public static final String SUBMIT_SHOW_USERS = "Show Users";
    public static final String SUBMIT_ADD_USERS = "Add Selected Users";
    static /* synthetic */ Class class$com$webmcq$ld$usermanagement$sysadmin$web$OrganisationAddUsersAction;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)"sysadmin perform");
        RequestUtil.dumpReqDetails(request, log);
        if (this.isCancelled(request)) {
            SystemAdminAction adminAction = new SystemAdminAction();
            Long sessionOrgId = RequestUtil.getSessionOrgId(request.getSession());
            if (sessionOrgId != null && sessionOrgId != -1L) {
                String screen = adminAction.implOrganisationEdit(mapping, form, request, response, sessionOrgId);
                return mapping.findForward(screen);
            }
            return adminAction.getAdmin(mapping, form, request, response);
        }
        ActionErrors errors = new ActionErrors();
        OrganisationAddUsersActionForm dataForm = (OrganisationAddUsersActionForm)form;
        Long orgId = null;
        boolean finished = false;
        if (errors.isEmpty()) {
            try {
                log.debug((Object)("dataForm is " + (Object)((Object)dataForm)));
                orgId = dataForm.getSid();
                if (orgId == null || orgId == -1L) {
                    errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
                }
                if (this.isShowUsers(request)) {
                    this.addUsersToForm(request, dataForm);
                } else {
                    this.addUsersToOrg(request, dataForm, orgId, errors);
                    finished = true;
                }
            }
            catch (RemoteException e) {
                log.error((Object)"EJB related exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
            }
            catch (CreateException e) {
                log.error((Object)"EJB related exception occured", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
            }
            catch (NamingException e) {
                log.error((Object)"EJB related exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
            }
            catch (UserManagementException e) {
                log.error((Object)"UserManagementException occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getMessage()));
            }
            catch (UserManagementAuthorisationException e) {
                log.error((Object)"UserManagementAuthorisationException occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(e.getMessage()));
            }
            catch (Exception e) {
                log.error((Object)"Exception occured ", (Throwable)e);
                errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.system"));
            }
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            if (mapping.getInput() != null) {
                return new ActionForward(mapping.getInput());
            }
            return mapping.findForward("error");
        }
        if (finished) {
            SystemAdminAction adminAction = new SystemAdminAction();
            String screen = adminAction.implOrganisationEdit(mapping, form, request, response, orgId);
            return mapping.findForward(screen);
        }
        return mapping.findForward("organisationaddusers");
    }

    private void addUsersToOrg(HttpServletRequest request, OrganisationAddUsersActionForm dataForm, Long orgId, ActionErrors errors) throws CreateException, RemoteException, NamingException, UserManagementException, UserManagementAuthorisationException {
        UserManagementService service = UserManagementServiceUtil.getHome().create();
        Long adminUserId = RequestUtil.getUserId(request, service);
        HashMap toAdd = new HashMap();
        this.decodeUserRight(errors, toAdd, dataForm.getSelectedUserRight());
        Iterator iter = toAdd.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            service.updateUserMembership((Long)element.getKey(), orgId, (Integer)element.getValue(), false, adminUserId);
        }
    }

    private void decodeUserRight(ActionErrors errors, Map toAdd, String[] selectedUserRights) {
        if (selectedUserRights == null || toAdd == null) {
            return;
        }
        for (int i = 0; i < selectedUserRights.length; ++i) {
            String userRight = selectedUserRights[i];
            Long userId = null;
            Integer right = null;
            if (userRight.length() == 0) continue;
            try {
                int index = userRight.indexOf(95);
                userId = new Long(userRight.substring(0, index));
                right = new Integer(userRight.substring(index + 1));
            }
            catch (NumberFormatException e) {
                log.error((Object)("decodeRole: Unable to convert user id to long. Value was " + userRight));
            }
            if (userId == null) continue;
            int result = Rights.compare(right, (Integer)toAdd.get(userId));
            log.debug((Object)("Comparing right for user id " + userId + " new right " + right + " old right " + toAdd.get(userId)));
            if (result != 1) continue;
            toAdd.put(userId, right);
        }
    }

    private void addUsersToForm(HttpServletRequest request, OrganisationAddUsersActionForm dataForm) throws CreateException, RemoteException, NamingException, UserManagementException, UserManagementAuthorisationException {
        Long adminUserId;
        UserManagementService service;
        SortedSet users;
        Long selectedOrgId = dataForm.getSelectedOrgId();
        if (selectedOrgId != null && (users = (service = UserManagementServiceUtil.getHome().create()).getHomeUsersFromOrganisation(selectedOrgId, adminUserId = RequestUtil.getUserId(request, service))) != null) {
            log.debug((Object)("Adding users to form " + users.toString()));
            dataForm.setPotentialUsers(users);
        }
    }

    private boolean isShowUsers(HttpServletRequest request) {
        String submitValue = request.getParameter("submit");
        log.debug((Object)("Submit value is " + submitValue));
        return SUBMIT_SHOW_USERS.equals(submitValue);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

