/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.SessionFactory;

public class HibernateUtilFactory {
    private static HibernateUtilFactory instance;
    private static String FACTORY_NAME;
    private static String SESSION_FACTORY_JNDI_NAME;
    private Context context = new InitialContext();
    private DataSource ds;
    private Map sessionFactories = new HashMap();

    private HibernateUtilFactory() throws NamingException {
    }

    public static HibernateUtilFactory getInstance() throws NamingException {
        if (instance == null) {
            instance = new HibernateUtilFactory();
        }
        return instance;
    }

    public SessionFactory getSessionFactory() throws NamingException {
        SessionFactory factory = (SessionFactory)this.sessionFactories.get(FACTORY_NAME);
        if (factory == null) {
            factory = (SessionFactory)this.context.lookup(SESSION_FACTORY_JNDI_NAME);
            this.sessionFactories.put(FACTORY_NAME, factory);
        }
        return factory;
    }

    public void closeSessionFactory() throws NamingException, HibernateException {
        SessionFactory factory = (SessionFactory)this.sessionFactories.get(FACTORY_NAME);
        if (factory != null) {
            factory.close();
            this.sessionFactories.remove(FACTORY_NAME);
        }
    }

    public DataSource getDataSource() throws NamingException {
        if (this.ds == null) {
            this.ds = (DataSource)this.context.lookup("java:/MySqlDS");
        }
        return this.ds;
    }

    static {
        FACTORY_NAME = "factoryname";
        SESSION_FACTORY_JNDI_NAME = "java:/HibernateFactory";
    }
}

