/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util;

import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceDAO;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.hibernate.Session;
import org.apache.log4j.Logger;

public class WebUtil {
    public static final String TRANSACTION_KEY_NB = "transactionKeyNoticeBoard";
    public static final String TRANSACTION_KEY_JNRL = "transactionKeyJournal";
    public static final String TRANSACTION_KEY_QNA = "transactionKeyQuestionAnswer";
    public static final String TRANSACTION_KEY_GROUPREPORT = "transactionKeyGroupReport";
    public static final String TRANSACTION_KEY_GROUPING = "transactionKeyGrouping";
    public static final String TRANSACTION_KEY_SIMPLEASSESSMENT = "transactionKeySimpleAssessment";
    public static final String TRANSACTION_KEY_MB = "transactionKeyMessageBoard";
    public static final String TRANSACTION_KEY_REPORT_SUBMISSION = "transactionKeyReportSubmission";
    public static final String TRANSACTION_KEY_URL_CONTENT = "transactionKeyUrlContent";
    public static final String TRANSACTION_KEY_VOTE = "transactionKeyVote";
    public static final String TRANSACTION_KEY_IMGGALLERY = "transactionKeyImgGallery";
    public static final String TRANSACTION_KEY_OPTIONAL = "transactionKeyOptional";
    public static final String TRANSACTION_KEY_SURVEY = "transactionKeySurvey";
    public static final String TRANSACTION_DONE_GROUPING = "transactionDoneGrouping";
    public static final String TRANSACTION_DONE_GROUPREPORT = "transactionDoneGroupeReport";
    public static final String TRANSACTION_DONE_JNRL = "transactionDoneJnrl";
    public static final String TRANSACTION_DONE_MB = "transactionDoneMb";
    public static final String TRANSACTION_DONE_NB = "transactionDoneNoticeBoard";
    public static final String TRANSACTION_DONE_QNA = "transactionDoneQna";
    public static final String TRANSACTION_DONE_REPORT_SUBMISSION = "transactionDoneReportSubmission";
    public static final String TRANSACTION_DONE_SIMPLEASSESSMENT = "transactionDoneSimpleAssessment";
    public static final String TRANSACTION_DONE_URL_CONTENT = "transactionDoneUrlContent";
    public static final String TRANSACTION_DONE_VOTE = "transactionDoneVote";
    public static final String TRANSACTION_DONE_OPTIONAL = "transactionDoneOptional";
    public static final String TRANSACTION_DONE_SURVEY = "transactionDoneSurvey";
    public static final String CURRENT_TASK_ID = "currentTaskId";
    public static final String COMPLETED_TASK_ID = "completedTaskId";
    public static final String TASK_TO_DISPLAY = "tasktodisplay";
    public static final String SEQUENCE_COMPLETED = "sequenceCompleted";
    public static final String REFRESH_PROGRESS_DATA = "refresh";
    public static final String IS_REUSABLE = "isReusable";
    public static final int MAX_NUMBER_OF_DUPLICATE_SUBMISSION = 4;
    public static final String JUNIT_START = "JUNIT_START";
    public static final String JUNIT_END = "JUNIT_END";
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$util$WebUtil == null ? (class$com$webmcq$ld$util$WebUtil = WebUtil.class$("com.webmcq.ld.util.WebUtil")) : class$com$webmcq$ld$util$WebUtil));
    static /* synthetic */ Class class$com$webmcq$ld$util$WebUtil;

    public static boolean isTokenValid(HttpServletRequest req, String tokenName) {
        if (req.getSession() != null) {
            String valueSession = (String)req.getSession().getAttribute(tokenName);
            String valueRequest = req.getParameter(tokenName);
            log.debug((Object)("(Session Token) name : " + tokenName + " value : " + valueSession));
            log.debug((Object)("(Request Token) name : " + tokenName + " value : " + valueRequest));
            if (valueSession != null && valueRequest != null && valueSession.equals(valueRequest)) {
                return true;
            }
        }
        return false;
    }

    public static void saveTaskURL(HttpServletRequest req, String[] urls) {
        if (urls != null) {
            if (urls.length == 1) {
                req.setAttribute("urlA", (Object)urls[0]);
            } else if (urls.length == 2) {
                req.setAttribute("urlA", (Object)urls[0]);
                req.setAttribute("urlB", (Object)urls[1]);
            }
        }
    }

    public static void saveTaskURL(HttpServletRequest req, DisplayTaskData displayTaskData) {
        if (displayTaskData != null) {
            if (displayTaskData.getMessageType() == 51) {
                WebUtil.initTaskAttributes(req);
            }
            String currentTask = (String)req.getSession().getAttribute(CURRENT_TASK_ID);
            req.getSession().setAttribute(COMPLETED_TASK_ID, (Object)currentTask);
            req.getSession().setAttribute(CURRENT_TASK_ID, (Object)Long.toString(displayTaskData.getTaskId()));
            WebUtil.setRefresh(req, true);
            if (displayTaskData.getMessageType() == 20) {
                req.getSession().setAttribute(SEQUENCE_COMPLETED, (Object)"true");
            } else {
                req.getSession().setAttribute(SEQUENCE_COMPLETED, (Object)"false");
            }
            req.getSession().setAttribute(TASK_TO_DISPLAY, (Object)displayTaskData);
            req.getSession().setAttribute(IS_REUSABLE, (Object)"false");
        }
    }

    public static void setRefresh(HttpServletRequest req, boolean refreshValue) {
        req.getSession().setAttribute(REFRESH_PROGRESS_DATA, (Object)Boolean.toString(refreshValue));
    }

    public static void initTaskAttributes(HttpServletRequest req) {
        req.getSession().setAttribute(CURRENT_TASK_ID, (Object)"-1");
        req.getSession().setAttribute(COMPLETED_TASK_ID, (Object)"-1");
        req.getSession().setAttribute(TASK_TO_DISPLAY, null);
        req.getSession().setAttribute(SEQUENCE_COMPLETED, (Object)"false");
        req.getSession().setAttribute(REFRESH_PROGRESS_DATA, (Object)"false");
        req.getSession().setAttribute(IS_REUSABLE, (Object)"false");
    }

    public static void saveToken(HttpServletRequest req, String tokenName, String tokenValue) {
        if (req.getSession().getAttribute(tokenName) != null) {
            WebUtil.resetToken(req, tokenName);
        }
        req.getSession().setAttribute(tokenName, (Object)tokenValue);
        log.debug((Object)("(Save Session Token) name : " + tokenName + " value : " + tokenValue));
    }

    public static String retrieveToken(HttpServletRequest req, String tokenName) {
        return (String)req.getSession().getAttribute(tokenName);
    }

    public static void resetToken(HttpServletRequest req, String tokenName) {
        req.getSession().removeAttribute(tokenName);
    }

    public static void checkString(String paramName, String paramValue) throws IllegalArgumentException {
        if (paramValue == null || paramValue.length() < 1) {
            throw new IllegalArgumentException(paramName + " is required '" + paramValue + "'");
        }
    }

    public static int checkInteger(String paramName, String paramValue) throws IllegalArgumentException {
        try {
            WebUtil.checkString(paramName, paramValue);
            return Integer.parseInt(paramValue.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(paramName + " should be an integer '" + paramValue + "'");
        }
    }

    public static long checkLong(String paramName, String paramValue) throws IllegalArgumentException {
        try {
            WebUtil.checkString(paramName, paramValue);
            return Long.parseLong(paramValue.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(paramName + " should be a long '" + paramValue + "'");
        }
    }

    public static boolean checkBoolean(String paramName, String paramValue) throws IllegalArgumentException {
        WebUtil.checkString(paramName, paramValue);
        return Boolean.valueOf(paramValue.trim());
    }

    public static int readIntParam(HttpServletRequest req, String paramName) {
        return WebUtil.checkInteger(paramName, req.getParameter(paramName));
    }

    public static int readIntParamFromUserSession(HttpServletRequest req, String paramName) {
        HttpSession session = req.getSession();
        if (session.getAttribute(paramName) != null) {
            return WebUtil.checkInteger(paramName, String.valueOf((Integer)session.getAttribute(paramName)));
        }
        return -1;
    }

    public static long readLongParam(HttpServletRequest req, String paramName) {
        return WebUtil.checkLong(paramName, req.getParameter(paramName));
    }

    public static String readStrParam(HttpServletRequest req, String paramName) {
        return WebUtil.readStrParam(req, paramName, false);
    }

    public static String readStrParam(HttpServletRequest req, String paramName, boolean isOptional) {
        if (!isOptional) {
            WebUtil.checkString(paramName, req.getParameter(paramName));
        }
        return req.getParameter(paramName);
    }

    public static boolean readBooleanParam(HttpServletRequest req, String paramName) throws IllegalArgumentException {
        return WebUtil.checkBoolean(paramName, req.getParameter(paramName));
    }

    public static boolean readBooleanParam(HttpServletRequest req, String paramName, boolean defaultValue) {
        try {
            return WebUtil.checkBoolean(paramName, req.getParameter(paramName));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static String getUsername(HttpServletRequest req) throws SystemException {
        Principal prin = req.getUserPrincipal();
        if (prin == null) {
            throw new SystemException("Trying to get username but principal object missing. Request is " + req.toString());
        }
        String username = prin.getName();
        if (username == null) {
            throw new SystemException("Name missing from principal object. Request is " + req.toString() + " Principal object is " + ((Object)prin).toString());
        }
        return username;
    }

    public static String buildToolResultsUrl(String path, String method, long taskInstanceId, String otherParams) {
        StringBuffer description = new StringBuffer(2000);
        description.append(path);
        description.append(".do?method=");
        description.append(method);
        description.append("&sessionId=");
        description.append(taskInstanceId);
        description.append("&userId=0");
        if (otherParams != null) {
            description.append("&");
            description.append(otherParams);
        }
        return description.toString();
    }

    public static long retrieveLearningSessionIdFromSession(HttpServletRequest req, String mode) {
        long lsessionID = -1L;
        if (mode == null || mode.equals("checkup")) {
            HttpSession session = req.getSession();
            if (session.getAttribute("MLearningSessionID") != null) {
                lsessionID = Integer.parseInt((String)session.getAttribute("MLearningSessionID"));
            }
        } else {
            lsessionID = WebUtil.readIntParamFromUserSession(req, "CurLearningSessionID");
        }
        if (lsessionID == -1L) {
            if (req.getAttribute("sessionId") == null) {
                throw new SystemException("TaskInstanceId cannot be found in request scope!");
            }
            long taskInstanceId = (Long)req.getAttribute("sessionId");
            PersistenceSession sess = new PersistenceSession();
            TaskInstanceDAO tiDao = new TaskInstanceDAO(sess);
            TaskInstance taskInstance = null;
            try {
                taskInstance = tiDao.find(taskInstanceId);
            }
            catch (TaskInstanceNotFoundException e) {
                throw new SystemException(e.getMessage());
            }
            lsessionID = taskInstance.getLearningSession().getSid();
            req.getSession().setAttribute("MLearningSessionID", (Object)new Long(lsessionID).toString());
        }
        return lsessionID;
    }

    public static Session retrievePersistenceSession(HttpServletRequest req, String name) {
        Session s = (Session)req.getSession().getAttribute(name);
        if (s == null || !s.isOpen()) {
            return null;
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

