/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util.persistence;

import com.webmcq.ld.util.exception.DataAccessException;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.io.Serializable;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.type.Type;
import org.apache.log4j.Logger;

public class BaseDAO {
    protected PersistenceSession sess;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$util$persistence$BaseDAO == null ? (class$com$webmcq$ld$util$persistence$BaseDAO = BaseDAO.class$("com.webmcq.ld.util.persistence.BaseDAO")) : class$com$webmcq$ld$util$persistence$BaseDAO));
    static /* synthetic */ Class class$com$webmcq$ld$util$persistence$BaseDAO;

    public BaseDAO() {
    }

    public BaseDAO(PersistenceSession sess) {
        this.sess = sess;
    }

    public void insert(Object obj) throws SystemException {
        try {
            this.sess.persistece().save(obj);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public void update(Object obj) throws SystemException, JDBCException {
        try {
            this.sess.persistece().saveOrUpdate(obj);
        }
        catch (HibernateException e) {
            if (e instanceof JDBCException) {
                throw (JDBCException)((Object)e);
            }
            throw new SystemException(e);
        }
    }

    public void update(Object obj, long id) throws SystemException {
        try {
            this.sess.persistece().update(obj, (Serializable)new Long(id));
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public Object find(Class clazz, long id) throws SystemException {
        try {
            return this.sess.persistece().get(clazz, (Serializable)new Long(id));
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public Object find(Class clazz, Long id) throws SystemException {
        return this.find(clazz, (long)id);
    }

    public List findAll(Class clazz) throws SystemException {
        try {
            return this.sess.persistece().find("from obj in class " + clazz.getName());
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public void remove(Class clazz, long id) throws SystemException {
        try {
            String query = "from obj in class " + clazz.getName() + " where obj.sid = ?";
            this.sess.persistece().delete(query, (Object)new Long(id), (Type)Hibernate.LONG);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public void save(Object object) throws HibernateException {
        this.sess.persistece().save(object);
    }

    public Transaction startTransaction() {
        return this.sess.startTransaction();
    }

    public void commitTransaction(Transaction tx) {
        this.sess.commitTransaction(tx);
    }

    public void rollbackTransaction(Transaction tx) {
        this.sess.rollbackTransaction(tx);
    }

    public void LockSession(Object obj, LockMode mode) {
        this.sess.lockSession(obj, mode);
    }

    public void flush() {
        this.sess.flush();
    }

    public void initializePersistenceSession(boolean isLongSession) throws DataAccessException {
        if (!isLongSession) {
            this.sess = new PersistenceSession();
        } else if (isLongSession && !this.sess.persistece().isConnected()) {
            this.sess.reconnect();
        }
    }

    public void finalizeSession(boolean isLongSession) {
        try {
            if (isLongSession) {
                this.sess.disconnect();
            } else {
                this.sess.close();
            }
        }
        catch (DataAccessException e) {
            throw new SystemException("Fail to finalize the persist session");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

