/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util.sequence;

import com.webmcq.ld.util.sequence.interfaces.SequenceLocal;
import com.webmcq.ld.util.sequence.interfaces.SequenceLocalHome;
import com.webmcq.ld.util.sequence.interfaces.SequenceUtil;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.TransactionRolledbackLocalException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public abstract class SequenceGenBean
implements SessionBean {
    private Hashtable _entries = new Hashtable();
    private int _blockSize;
    private int _retryCount;
    private SequenceLocalHome _sequenceHome;

    public int getNextNumber(String name) {
        try {
            Entry entry = (Entry)this._entries.get(name);
            if (entry == null) {
                entry = new Entry();
                try {
                    entry.sequence = this._sequenceHome.findByPrimaryKey(name);
                }
                catch (FinderException e) {
                    entry.sequence = this._sequenceHome.create(name);
                }
                this._entries.put(name, entry);
            }
            if (entry.last == entry.next) {
                int retry = 0;
                while (true) {
                    try {
                        entry.last = entry.sequence.getNextKeyAfterIncrementingBy(this._blockSize);
                        entry.next = entry.last - this._blockSize;
                    }
                    catch (TransactionRolledbackLocalException e) {
                        if (retry >= this._retryCount) {
                            throw new EJBException((Exception)((Object)e));
                        }
                        ++retry;
                        continue;
                    }
                    break;
                }
            }
            return entry.next++;
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void setSessionContext(SessionContext arg0) {
        try {
            InitialContext ctx = new InitialContext();
            this._blockSize = (Integer)ctx.lookup("java:comp/env/blockSize");
            this._retryCount = (Integer)ctx.lookup("java:comp/env/retryCount");
            this._sequenceHome = SequenceUtil.getLocalHome();
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbPostCreate() throws CreateException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    private class Entry {
        SequenceLocal sequence;
        int next;
        int last;

        private Entry() {
        }
    }
}

