/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.dao;

import com.webmcq.ld.activities.ActivityDefnVO;
import com.webmcq.ld.activities.MultiTaskVO;
import com.webmcq.ld.activities.dao.MultiTaskDAO;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.BaseDAO;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.io.Serializable;
import java.util.List;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.type.Type;
import org.apache.log4j.Logger;

public class ActivityDefnDAO
extends BaseDAO {
    private static Logger logger = Logger.getLogger((String)(class$com$webmcq$ld$activities$ActivityDefnVO == null ? (class$com$webmcq$ld$activities$ActivityDefnVO = ActivityDefnDAO.class$("com.webmcq.ld.activities.ActivityDefnVO")) : class$com$webmcq$ld$activities$ActivityDefnVO).getName());
    private static final String lookupByTransitionId = "select act from act in class com.webmcq.ld.activities.ActivityDefnVO, tran in act.transitions.elements where tran.sid = ?";
    private static final String lookupByTaskIdDirectly = "select act from act in class com.webmcq.ld.activities.ActivityDefnVO, task in act.tasks.elements where task.sid = ?";
    static /* synthetic */ Class class$com$webmcq$ld$activities$ActivityDefnVO;

    public ActivityDefnDAO(PersistenceSession sess) {
        super(sess);
    }

    public ActivityDefnVO get(long sid) {
        logger.debug((Object)("find: " + sid));
        try {
            ActivityDefnVO actDef = (ActivityDefnVO)this.sess.persistece().get(class$com$webmcq$ld$activities$ActivityDefnVO == null ? (class$com$webmcq$ld$activities$ActivityDefnVO = ActivityDefnDAO.class$("com.webmcq.ld.activities.ActivityDefnVO")) : class$com$webmcq$ld$activities$ActivityDefnVO, (Serializable)new Long(sid));
            if (actDef == null) {
                logger.debug((Object)"activity not found");
                return null;
            }
            logger.debug((Object)"activity found");
            return actDef;
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public ActivityDefnVO find(long sid) {
        logger.debug((Object)("find: " + sid));
        try {
            ActivityDefnVO actDef = (ActivityDefnVO)this.sess.persistece().get(class$com$webmcq$ld$activities$ActivityDefnVO == null ? (class$com$webmcq$ld$activities$ActivityDefnVO = ActivityDefnDAO.class$("com.webmcq.ld.activities.ActivityDefnVO")) : class$com$webmcq$ld$activities$ActivityDefnVO, (Serializable)new Long(sid));
            if (actDef == null) {
                logger.debug((Object)"activity not found");
                return null;
            }
            logger.debug((Object)"activity found");
            return actDef;
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public ActivityDefnVO findContainsTransition(long transitionId) {
        logger.debug((Object)("find activity containing transition id: " + transitionId));
        try {
            List list = this.sess.persistece().find(lookupByTransitionId, (Object)new Long(transitionId), (Type)Hibernate.LONG);
            if (list.size() == 0) {
                logger.debug((Object)"activity not found");
                return null;
            }
            logger.debug((Object)"activity found");
            return (ActivityDefnVO)list.get(0);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public ActivityDefnVO findContainsTaskDirectly(long id) {
        logger.debug((Object)("find activity containing task id: " + id));
        try {
            List list;
            if (this.sess == null) {
                logger.error((Object)"Session is null");
            }
            if (this.sess.persistece() == null) {
                logger.error((Object)"Persistence is null");
            }
            if ((list = this.sess.persistece().find(lookupByTaskIdDirectly, (Object)new Long(id), (Type)Hibernate.LONG)).size() == 0) {
                logger.debug((Object)"activity not found");
                return null;
            }
            logger.debug((Object)"activity found");
            return (ActivityDefnVO)list.get(0);
        }
        catch (HibernateException e) {
            throw new SystemException(e);
        }
    }

    public ActivityDefnVO findContainsTask(long id) {
        MultiTaskDAO mtDAO;
        MultiTaskVO multitask;
        logger.debug((Object)("find activity containing task id: " + id));
        ActivityDefnVO activity = this.findContainsTaskDirectly(id);
        if (activity == null && (multitask = (mtDAO = new MultiTaskDAO(this.sess)).findContainsTask(id)) != null) {
            activity = this.findContainsTask(multitask.getSid());
        }
        logger.debug((Object)("Activity " + (activity != null ? "found" : "not found")));
        return activity;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

