/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.activities.runtimeaccess.tree;

import com.webmcq.ld.activities.runtimeaccess.tree.AbstractStrategy;
import com.webmcq.ld.activities.runtimeaccess.tree.DesignItem;
import com.webmcq.ld.activities.runtimeaccess.tree.DesignItemsDTO;
import com.webmcq.ld.activities.runtimeaccess.tree.TransitionLeaf;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import org.apache.log4j.Logger;

public class SelectionStrategy
extends AbstractStrategy
implements Serializable {
    private static Logger log = Logger.getLogger((String)(class$com$webmcq$ld$activities$runtimeaccess$tree$SelectionStrategy == null ? (class$com$webmcq$ld$activities$runtimeaccess$tree$SelectionStrategy = SelectionStrategy.class$("com.webmcq.ld.activities.runtimeaccess.tree.SelectionStrategy")) : class$com$webmcq$ld$activities$runtimeaccess$tree$SelectionStrategy).getName());
    static final long serialVersionUID = 7643976206679993577L;
    private int m_minimumNumberToComplete = 0;
    private DesignItemsDTO m_cacheAllItems;
    private LinkedList m_cacheLinearSequence;
    static /* synthetic */ Class class$com$webmcq$ld$activities$runtimeaccess$tree$SelectionStrategy;

    public SelectionStrategy(int minimumNumberToComplete) {
        this.m_minimumNumberToComplete = minimumNumberToComplete;
    }

    public void updatedChildren() {
        this.m_cacheAllItems = null;
        this.m_cacheLinearSequence = null;
    }

    public DesignItemsDTO getNextItems(DesignItem currentChild) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNextItems: childrenBySid is " + (this.getChildrenBySid() != null ? this.getChildrenBySid().toString() : "null")));
        }
        if (currentChild == null) {
            return this.getAllItems();
        }
        TransitionLeaf transitionAfterContainer = this.getFollowingTransition();
        if (transitionAfterContainer != null && !currentChild.equals(transitionAfterContainer) && transitionAfterContainer.isSync()) {
            return new DesignItemsDTO(new DesignItem[]{transitionAfterContainer}, 1);
        }
        return DesignItemsDTO.getEmptyVersion();
    }

    private DesignItemsDTO getAllItems() {
        SortedMap childrenBySid = this.getChildrenBySid();
        if (childrenBySid == null) {
            log.warn((Object)("Trying to following items but no children exist. Node is " + (this.m_node != null ? this.m_node.toString() : "null")));
            return DesignItemsDTO.getEmptyVersion();
        }
        if (this.m_cacheAllItems == null) {
            DesignItem[] itemArray = childrenBySid.values().toArray(new DesignItem[childrenBySid.size()]);
            this.m_cacheAllItems = new DesignItemsDTO(itemArray, this.getMinimumNumberToComplete());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating new version of all items " + this.m_cacheAllItems));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Using the cache version of all items " + this.m_cacheAllItems));
        }
        return this.m_cacheAllItems;
    }

    public List getLinearSequence() {
        if (this.m_cacheLinearSequence == null) {
            SortedMap childrenBySid = this.getChildrenBySid();
            if (childrenBySid == null) {
                log.warn((Object)("Trying to get linear sequence but no children exist. Node is " + (this.m_node != null ? this.m_node.toString() : "null")));
                return new LinkedList();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getLinearSequence: childrenBySid is " + childrenBySid.toString()));
            }
            TransitionLeaf transitionAfterContainer = this.getFollowingTransition();
            LinkedList list = new LinkedList(childrenBySid.values());
            if (transitionAfterContainer != null && transitionAfterContainer.isSync()) {
                list.add(transitionAfterContainer);
            }
            this.m_cacheLinearSequence = list;
        }
        return this.m_cacheLinearSequence;
    }

    public int getMinimumNumberToComplete() {
        return this.m_minimumNumberToComplete;
    }

    public void setMinimumNumberToComplete(int minimumNumberToComplete) {
        this.m_minimumNumberToComplete = minimumNumberToComplete;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

