/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller;

import com.webmcq.ld.controller.Activity;
import com.webmcq.ld.controller.ActivityInstance;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.design.LearningDesign;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class LearnerProgress {
    private long sid;
    private long learningDesignId;
    private TaskInstance currentTaskInstance = null;
    private List pastTaskInstances;
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$LearnerProgress == null ? (class$com$webmcq$ld$controller$LearnerProgress = LearnerProgress.class$("com.webmcq.ld.controller.LearnerProgress")) : class$com$webmcq$ld$controller$LearnerProgress));
    static /* synthetic */ Class class$com$webmcq$ld$controller$LearnerProgress;

    private LearnerProgress() {
    }

    public LearnerProgress(long learningDesignId) {
        this.learningDesignId = learningDesignId;
        this.pastTaskInstances = new ArrayList();
    }

    public ActivityInstance[] getPastActivityInstances(ActivityInstance curActInstance) throws ControllerException {
        return this.getPastActivities(curActInstance).toArray(new ActivityInstance[0]);
    }

    public List getPastActivities(ActivityInstance curActInstance) throws ControllerException {
        ActivityInstance lastAct;
        log.debug((Object)"get Past Activities");
        List activities = this.groupTaskInstances();
        if (curActInstance != null && activities.size() > 0 && (lastAct = (ActivityInstance)activities.get(activities.size() - 1)).getActivityId() == curActInstance.getActivityId()) {
            activities.remove(activities.size() - 1);
        }
        return activities;
    }

    private List groupTaskInstances() throws ControllerException {
        log.debug((Object)("task instances taken size: " + this.pastTaskInstances.size()));
        List taskInstances = this.removeDummyTask(this.pastTaskInstances);
        if (taskInstances.size() == 0) {
            return new ArrayList();
        }
        ArrayList<ActivityInstance> activities = new ArrayList<ActivityInstance>();
        Iterator iter = taskInstances.iterator();
        TaskInstance task = (TaskInstance)iter.next();
        ActivityInstance activityInstance = new ActivityInstance(task.getTask().getActivity());
        activityInstance.addTaskInstance(task);
        while (iter.hasNext()) {
            task = (TaskInstance)iter.next();
            long activityId = task.getTask().getActivity().getSid();
            if (activityId != activityInstance.getActivityId()) {
                activities.add(activityInstance);
                activityInstance = new ActivityInstance(task.getTask().getActivity());
            }
            activityInstance.addTaskInstance(task);
        }
        activities.add(activityInstance);
        return activities;
    }

    private List removeDummyTask(List taskInstances) {
        ArrayList<TaskInstance> pastNonDummyTaskInstances = new ArrayList<TaskInstance>();
        Iterator iter = taskInstances.iterator();
        int index = 0;
        while (iter.hasNext()) {
            TaskInstance task = (TaskInstance)iter.next();
            if (task.getType() == 5 || task.getType() == 3) continue;
            pastNonDummyTaskInstances.add(index, task);
            ++index;
        }
        return pastNonDummyTaskInstances;
    }

    public Activity[] getFutureActivties(ActivityInstance curActInstance) throws ControllerException {
        Activity currentActivity = this.getCurrentActivity(curActInstance);
        log.debug((Object)"get Future Activties");
        if (currentActivity == null) {
            TaskInstance taskInstance = this.getLastTaskInstance();
            currentActivity = taskInstance == null ? null : taskInstance.getTask().getActivity();
        }
        if (currentActivity != null) {
            LearningDesign learningDesign = new LearningDesign(this.learningDesignId);
            return learningDesign.getFutureActivities(currentActivity);
        }
        return new Activity[0];
    }

    public TaskInstance getCurrentTaskInstance() {
        return this.currentTaskInstance;
    }

    public void setCurrentTaskInstance(TaskInstance currentTaskInstance) {
        this.currentTaskInstance = currentTaskInstance;
    }

    public Task getCurrentTask() {
        Task task = null;
        if (this.getCurrentTaskInstance() == null) {
            int size;
            if (this.pastTaskInstances != null && (size = this.pastTaskInstances.size()) > 0) {
                task = ((TaskInstance)this.pastTaskInstances.get(size - 1)).getTask();
            }
        } else {
            task = this.getCurrentTaskInstance().getTask();
        }
        return task;
    }

    public List getPastTaskInstances() {
        return this.pastTaskInstances;
    }

    public Long[] getPastTaskInstanceIds() {
        Long[] ids = new Long[this.pastTaskInstances.size()];
        for (int i = 0; i < ids.length; ++i) {
            TaskInstance task = (TaskInstance)this.pastTaskInstances.get(i);
            ids[i] = new Long(task.getSid());
        }
        return ids;
    }

    private void setPastTaskInstances(List pastTaskInstances) {
        this.pastTaskInstances = pastTaskInstances;
    }

    public void completeCurrentTask() {
        if (this.currentTaskInstance != null) {
            this.pastTaskInstances.add(this.currentTaskInstance);
        }
    }

    public boolean hasTaken(TaskInstance taskInstance) {
        Iterator i = this.pastTaskInstances.iterator();
        while (i.hasNext()) {
            TaskInstance ti = (TaskInstance)i.next();
            if (ti.getSid() != taskInstance.getSid()) continue;
            return true;
        }
        return false;
    }

    public TaskInstance getLastTaskInstance() {
        if (this.pastTaskInstances.size() == 0) {
            return null;
        }
        return (TaskInstance)this.pastTaskInstances.get(this.pastTaskInstances.size() - 1);
    }

    public void removeTaskInstanceFromHistory(long taskInstanceId) throws ControllerException {
        if (taskInstanceId != this.getLastTaskInstance().getSid()) {
            throw new ControllerException("There is something wrong with the learner progress");
        }
        this.pastTaskInstances.remove(this.pastTaskInstances.size() - 1);
    }

    public Activity getCurrentActivity() throws ControllerException {
        ActivityInstance curActInstance = this.getCurrentActivityInstance();
        if (curActInstance == null) {
            return null;
        }
        return curActInstance.getActivity();
    }

    public Activity getCurrentActivity(ActivityInstance curActInstance) throws ControllerException {
        if (curActInstance == null) {
            return null;
        }
        return curActInstance.getActivity();
    }

    public ActivityInstance getCurrentActivityInstance() throws ControllerException {
        log.debug((Object)"getCurrentActivityInstance()");
        if (this.currentTaskInstance == null) {
            return null;
        }
        Activity activity = this.currentTaskInstance.getTask().getActivity();
        if (activity == null) {
            return null;
        }
        ActivityInstance activityInstance = new ActivityInstance(activity);
        Iterator iter = this.getActivityTasks(activity.getSid()).iterator();
        while (iter.hasNext()) {
            activityInstance.addTaskInstance((TaskInstance)iter.next());
        }
        activityInstance.addTaskInstance(this.currentTaskInstance);
        return activityInstance;
    }

    private List getActivityTasks(long activityId) throws ControllerException {
        TaskInstance task;
        Activity activity;
        log.debug((Object)("getActivityTasks: pastTaskInstances: " + this.pastTaskInstances.size()));
        List pastNonDummyTaskInstances = this.removeDummyTask(this.pastTaskInstances);
        ArrayList<TaskInstance> found = new ArrayList<TaskInstance>();
        for (int i = pastNonDummyTaskInstances.size() - 1; i >= 0 && (activity = (task = (TaskInstance)pastNonDummyTaskInstances.get(i)).getTask().getActivity()) != null && activity.getSid() == activityId; --i) {
            found.add(0, task);
        }
        log.debug((Object)("getActivityTasks: found: " + found.size()));
        return found;
    }

    public long getSid() {
        return this.sid;
    }

    private void setSid(long sid) {
        this.sid = sid;
    }

    private long getLearningDesignId() {
        return this.learningDesignId;
    }

    private void setLearningDesignId(long l) {
        this.learningDesignId = l;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

