/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.design;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.MultiTaskVO;
import com.webmcq.ld.activities.OptionalActivityDummyTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.activities.TransitionDefnVO;
import com.webmcq.ld.activities.dao.TaskDAO;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.MultiTask;
import com.webmcq.ld.controller.OptionalTask;
import com.webmcq.ld.controller.SingleTask;
import com.webmcq.ld.controller.SyncTask;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.design.LearningDesignServiceDelegate;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.ejb.EJBException;

public class TaskManager {
    private static final long END = -2L;
    private static final long NULL = 0L;

    public static SingleTask getSingleTask(long taskId) {
        return new SingleTask(LearningDesignServiceDelegate.getTask(taskId));
    }

    public static SyncTask getSyncTask(long taskId) {
        return new SyncTask(LearningDesignServiceDelegate.getTask(taskId));
    }

    public static MultiTask getMultiTask(long taskId, Task subTask1, Task subTask2) {
        return new MultiTask(LearningDesignServiceDelegate.getTask(taskId), subTask1, subTask2);
    }

    public static OptionalTask getOptionalTask(long ldid, long taskId) {
        try {
            return TaskManager.createOptionTask(ldid, LearningDesignServiceDelegate.getTask(taskId));
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task nextTask(long ldid, Task task) throws ControllerException {
        PersistenceSession sess = null;
        AbstractTaskVO taskVO = null;
        Task nextTask = null;
        try {
            sess = new PersistenceSession();
            TaskDAO taskDao = new TaskDAO(sess);
            long nextTaskId = 0L;
            if (task != null) {
                nextTaskId = task.getTask().getNextTaskId();
            }
            if (nextTaskId == 0L) {
                taskVO = TaskManager.getNextTask(ldid, task);
                if (taskVO == null) {
                    task.getTask().setNextTaskId(-2L);
                } else if (task != null && task.getType() != 3) {
                    task.getTask().setNextTaskId(taskVO.getSid());
                }
                if (task != null && task.getType() != 3) {
                    taskDao.update(task.getTask());
                }
            } else if (nextTaskId != -2L) {
                taskVO = taskDao.find(nextTaskId);
            }
            nextTask = TaskManager.convert(ldid, taskVO);
            sess.flush();
        }
        finally {
            sess.close();
        }
        return nextTask;
    }

    public static Task nextTask(long ldid, Task task, PersistenceSession sess) throws ControllerException {
        AbstractTaskVO taskVO = null;
        Task nextTask = null;
        TaskDAO taskDao = new TaskDAO(sess);
        long nextTaskId = 0L;
        if (task != null) {
            nextTaskId = task.getTask().getNextTaskId();
        }
        if (nextTaskId == 0L) {
            taskVO = TaskManager.getNextTask(ldid, task);
            if (taskVO == null) {
                task.getTask().setNextTaskId(-2L);
            } else if (task != null && task.getType() != 3) {
                task.getTask().setNextTaskId(taskVO.getSid());
            }
            if (task != null && task.getType() != 3) {
                taskDao.update(task.getTask());
            }
        } else if (nextTaskId != -2L) {
            taskVO = taskDao.find(nextTaskId);
        }
        nextTask = TaskManager.convert(ldid, taskVO);
        sess.flush();
        return nextTask;
    }

    public static Task convert(long ldid, AbstractTaskVO task) throws ControllerException {
        if (task == null) {
            return null;
        }
        switch (task.theTaskType()) {
            case 2: {
                return TaskManager.createMultiTask(ldid, task);
            }
            case 5: {
                return TaskManager.createOptionTask(ldid, task);
            }
            case 3: {
                return TaskManager.createWaitingTask(task);
            }
        }
        return TaskManager.createSingleTask(task);
    }

    private static MultiTask createMultiTask(long ldid, AbstractTaskVO taskVO) throws ControllerException {
        if (!(taskVO instanceof MultiTaskVO)) {
            throw new ControllerException("MultiTaskVO expected instead of '" + taskVO.getClass().getName() + "'");
        }
        Task[] subTasks = TaskManager.getSubTasks(ldid, taskVO);
        return new MultiTask(taskVO, subTasks[0], subTasks[1]);
    }

    private static Task[] getSubTasks(long ldid, AbstractTaskVO taskVO) throws ControllerException {
        Vector tmp = LearningDesignServiceDelegate.getNextTaskSet(ldid, taskVO);
        if (tmp.size() != 2) {
            throw new ControllerException("expected Vector of size 2");
        }
        return TaskManager.createSingleTask(TaskManager.convert(tmp));
    }

    private static AbstractTaskVO[] convert(List v) {
        return v.toArray(new AbstractTaskVO[0]);
    }

    private static SingleTask[] createSingleTask(AbstractTaskVO[] tasks) throws ControllerException {
        SingleTask[] converted = new SingleTask[tasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            converted[i] = TaskManager.createSingleTask(tasks[i]);
        }
        return converted;
    }

    private static SingleTask createSingleTask(AbstractTaskVO taskVO) throws ControllerException {
        if (!(taskVO instanceof SimpleTaskVO)) {
            throw new ControllerException("SimpleTaskVO expected instead of '" + taskVO.getClass().getName() + "'");
        }
        return new SingleTask(taskVO);
    }

    private static AbstractTaskVO getNextTask(long learningDesignId, Task currentTask) throws ControllerException {
        List result = TaskManager.getNextTaskSet(learningDesignId, currentTask);
        if (result.size() == 0) {
            return null;
        }
        if (result.size() > 1) {
            throw new ControllerException("expected 1 task but received '" + result.size() + "'");
        }
        Object obj = result.get(0);
        if (obj instanceof AbstractTaskVO) {
            return (AbstractTaskVO)obj;
        }
        throw new ControllerException("AbstractTaskVO expected but received '" + obj.getClass().getName() + "'");
    }

    private static AbstractTaskVO getNextTask(long learningDesignId, Task currentTask, PersistenceSession sess) throws ControllerException {
        List result = TaskManager.getNextTaskSet(learningDesignId, currentTask, sess);
        if (result.size() == 0) {
            return null;
        }
        if (result.size() > 1) {
            throw new ControllerException("expected 1 task but received '" + result.size() + "'");
        }
        Object obj = result.get(0);
        if (obj instanceof AbstractTaskVO) {
            return (AbstractTaskVO)obj;
        }
        throw new ControllerException("AbstractTaskVO expected but received '" + obj.getClass().getName() + "'");
    }

    private static List getNextTaskSet(long learningDesignId, Task currentTask) throws ControllerException {
        Vector result;
        if (currentTask == null) {
            result = LearningDesignServiceDelegate.getNextTaskSet(learningDesignId, null);
        } else if (currentTask instanceof MultiTask) {
            MultiTask mTask = (MultiTask)currentTask;
            result = LearningDesignServiceDelegate.getNextTaskSet(learningDesignId, mTask.getTask2().getTask());
        } else if (currentTask instanceof OptionalTask) {
            OptionalTask oTask = (OptionalTask)currentTask;
            result = LearningDesignServiceDelegate.getNextTaskSetFromOptional(learningDesignId, oTask.getTask());
        } else {
            result = LearningDesignServiceDelegate.getNextTaskSet(learningDesignId, currentTask.getTask());
        }
        return result;
    }

    private static List getNextTaskSet(long learningDesignId, Task currentTask, PersistenceSession sess) throws ControllerException {
        Vector result;
        if (currentTask == null) {
            result = LearningDesignServiceDelegate.getNextTaskSet(learningDesignId, null);
        } else if (currentTask instanceof MultiTask) {
            MultiTask mTask = (MultiTask)currentTask;
            result = LearningDesignServiceDelegate.getNextTaskSet(learningDesignId, mTask.getTask2().getTask(), sess);
        } else if (currentTask instanceof OptionalTask) {
            OptionalTask oTask = (OptionalTask)currentTask;
            result = LearningDesignServiceDelegate.getNextTaskSetFromOptional(learningDesignId, oTask.getTask(), sess);
        } else {
            result = LearningDesignServiceDelegate.getNextTaskSet(learningDesignId, currentTask.getTask(), sess);
        }
        return result;
    }

    private static OptionalTask createOptionTask(long ldid, AbstractTaskVO taskVO) throws ControllerException {
        if (!(taskVO instanceof OptionalActivityDummyTaskVO)) {
            throw new ControllerException("expected OptionalActivityDummyTaskVO instead of '" + taskVO.getClass().getName() + "'");
        }
        OptionalActivityDummyTaskVO optionTask = (OptionalActivityDummyTaskVO)taskVO;
        OptionalTask task = new OptionalTask(optionTask);
        Iterator i = optionTask.getSubFirstTasks().iterator();
        while (i.hasNext()) {
            Task aTask = TaskManager.convert(ldid, (AbstractTaskVO)i.next());
            task.addSubTask(aTask);
        }
        return task;
    }

    private static SyncTask createWaitingTask(AbstractTaskVO taskVO) throws ControllerException {
        if (!(taskVO instanceof TransitionDefnVO)) {
            throw new ControllerException("WaitingTask expected instead of '" + taskVO.getClass().getName() + "'");
        }
        return new SyncTask(taskVO);
    }
}

