/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.learner;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.Learner;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.Task;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.UserNameData;
import com.webmcq.ld.controller.learner.Group;
import com.webmcq.ld.controller.learner.GroupSet;
import com.webmcq.ld.controller.tool.grouping.GroupingContent;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class LearnerGroup {
    private long sid;
    private Group learners = new Group("class");
    private Map groupSets = new HashMap();
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$learner$LearnerGroup == null ? (class$com$webmcq$ld$controller$learner$LearnerGroup = LearnerGroup.class$("com.webmcq.ld.controller.learner.LearnerGroup")) : class$com$webmcq$ld$controller$learner$LearnerGroup));
    static /* synthetic */ Class class$com$webmcq$ld$controller$learner$LearnerGroup;

    public long getSid() {
        return this.sid;
    }

    private void setSid(long l) {
        this.sid = l;
    }

    public Map getGroupSets() {
        return this.groupSets;
    }

    private void setGroupSets(Map groupSets) {
        this.groupSets = groupSets;
    }

    public void addGroupSet(GroupSet groupSet) {
        this.groupSets.put(new Long(groupSet.getGroupingId()), groupSet);
    }

    public boolean containsGroupSet(long groupingId) {
        return this.groupSets.containsKey(new Long(groupingId));
    }

    public GroupSet getGroupSet(long groupingId) {
        return (GroupSet)this.groupSets.get(new Long(groupingId));
    }

    public void join(Learner learner) throws ControllerException {
        this.learners.join(learner);
    }

    public Learner join(UserData user, LearningSession learningSession) throws ControllerException {
        if (this.hasJoined(user.getSid())) {
            return this.findLearner(user.getSid());
        }
        Learner newMember = new Learner(user.getSid(), learningSession);
        this.join(newMember);
        return newMember;
    }

    public boolean hasJoined(long userId) {
        return this.learners.hasJoined(userId);
    }

    public Group findGroup(Task task, Learner learner) throws ControllerException {
        if (task.isGroupTask()) {
            long groupingId = task.getGroupDefinition().getSid();
            GroupSet groupSet = this.getGroupSet(groupingId);
            if (groupSet == null) {
                throw new ControllerException("group set '" + groupingId + "' not found");
            }
            Group group = groupSet.getGroup(learner.getUserId());
            if (group == null) {
                throw new ControllerException("no group for learner '" + learner.getSid() + "' found");
            }
            return group;
        }
        return this.getLearners();
    }

    public Group getLearners() {
        return this.learners;
    }

    private void setLearners(Group learners) {
        this.learners = learners;
    }

    public Learner findLearner(ShwaaUserData user) {
        return this.learners.findLearner(user);
    }

    public Learner findLearner(long userId) {
        return this.learners.findLearner(userId);
    }

    public void createGroupSet(GroupingContent content, HashMap cachedUsers) throws ControllerException, UserNotFoundException {
        GroupSet groupSet = new GroupSet(content.getGroupingId());
        log.debug((Object)("number of groups: " + content.getGroups().size()));
        Iterator i = content.getGroups().iterator();
        while (i.hasNext()) {
            groupSet.addGroup(this.createGroup((GroupData)i.next(), cachedUsers));
        }
        log.debug((Object)("group set: " + groupSet));
        this.addGroupSet(groupSet);
    }

    public void createGroupSet(GroupingContent content) throws ControllerException, UserNotFoundException {
        GroupSet groupSet = new GroupSet(content.getGroupingId());
        log.debug((Object)("number of groups: " + content.getGroups().size()));
        Iterator i = content.getGroups().iterator();
        while (i.hasNext()) {
            groupSet.addGroup(this.createGroup((GroupData)i.next()));
        }
        log.debug((Object)("group set: " + groupSet));
        this.addGroupSet(groupSet);
    }

    public void updateGroupSet(GroupingContent grouping, HashMap cachedUsers) throws ControllerException, UserNotFoundException {
        GroupSet groupSet = this.getGroupSet(grouping.getGroupingId());
        Iterator i = grouping.getGroups().iterator();
        while (i.hasNext()) {
            GroupData groupData = (GroupData)i.next();
            Group group = groupSet.getGroup(groupData.getName());
            if (group == null) {
                Group newGroup = this.createGroup(groupData, cachedUsers);
                groupSet.addGroup(newGroup);
                continue;
            }
            this.updateGroup(group, groupData, cachedUsers);
        }
    }

    public void updateGroupSet(GroupingContent grouping) throws ControllerException, UserNotFoundException {
        GroupSet groupSet = this.getGroupSet(grouping.getGroupingId());
        Iterator i = grouping.getGroups().iterator();
        while (i.hasNext()) {
            GroupData groupData = (GroupData)i.next();
            Group group = groupSet.getGroup(groupData.getName());
            if (group == null) {
                Group newGroup = this.createGroup(groupData);
                groupSet.addGroup(newGroup);
                continue;
            }
            this.updateGroup(group, groupData);
        }
    }

    private Group updateGroup(Group oldGroup, GroupData groupData, HashMap cachedUsers) throws UserNotFoundException, ControllerException {
        Iterator i = groupData.getMembers().keySet().iterator();
        while (i.hasNext()) {
            UserNameData uData = (UserNameData)groupData.getMembers().get(i.next());
            if (oldGroup.isMember(new Long(uData.getSid()))) continue;
            UserData user = (UserData)cachedUsers.get(new Long(uData.getSid()));
            Learner learner = this.findLearner(user.getSid());
            oldGroup.join(learner);
        }
        return oldGroup;
    }

    private Group updateGroup(Group oldGroup, GroupData groupData) throws ControllerException, UserNotFoundException {
        Iterator i = groupData.getMembers().keySet().iterator();
        while (i.hasNext()) {
            UserNameData uData = (UserNameData)groupData.getMembers().get(i.next());
            if (oldGroup.isMember(new Long(uData.getSid()))) continue;
            Learner learner = this.findLearner(uData.getSid());
            if (learner == null) {
                throw new UserNotFoundException(uData.getSid());
            }
            oldGroup.join(learner);
        }
        return oldGroup;
    }

    private Group createGroup(GroupData groupData, HashMap cachedUsers) throws UserNotFoundException, ControllerException {
        Group newGroup = new Group(groupData.getName());
        Iterator i = groupData.getMembers().keySet().iterator();
        while (i.hasNext()) {
            UserNameData uData = (UserNameData)groupData.getMembers().get(i.next());
            UserData user = (UserData)cachedUsers.get(new Long(uData.getSid()));
            Learner learner = this.findLearner(user.getSid());
            newGroup.join(learner);
        }
        return newGroup;
    }

    private Group createGroup(GroupData groupData) throws ControllerException, UserNotFoundException {
        Group newGroup = new Group(groupData.getName());
        Iterator i = groupData.getMembers().keySet().iterator();
        while (i.hasNext()) {
            UserNameData uData = (UserNameData)groupData.getMembers().get(i.next());
            Learner learner = this.findLearner(uData.getSid());
            if (learner == null) {
                throw new UserNotFoundException(uData.getSid());
            }
            newGroup.join(learner);
        }
        return newGroup;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

