/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.tool.grouping;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.GroupDefnVO;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.LearningSession;
import com.webmcq.ld.controller.SingleTask;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.controller.dto.UserNameData;
import com.webmcq.ld.controller.tool.grouping.Group;
import com.webmcq.ld.controller.tool.grouping.Grouping;
import com.webmcq.ld.controller.tool.grouping.GroupingContent;
import com.webmcq.ld.controller.tool.grouping.GroupingDAO;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.usermanagement.UserData;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.exception.SystemException;
import com.webmcq.ld.util.persistence.PersistenceSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class GroupingServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$tool$grouping$GroupingServiceBean == null ? (class$com$webmcq$ld$controller$tool$grouping$GroupingServiceBean = GroupingServiceBean.class$("com.webmcq.ld.controller.tool.grouping.GroupingServiceBean")) : class$com$webmcq$ld$controller$tool$grouping$GroupingServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$controller$tool$grouping$GroupingServiceBean;

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            log.debug((Object)"createSession");
            SingleTask sTask = new SingleTask(task);
            this.createSession(taskInstance, sTask.getGroupingDefinition(), null, null, outputContentId, outputContentDestination, group);
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw new ToolException(e);
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw new ToolException(e);
        }
    }

    private void createSession(TaskInstanceData taskInstance, GroupDefnVO groupDefn, String learnerAction, String teacherAction, Long outputContentId, String outputDestination, GroupData group) throws ToolException, SystemException, ControllerException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"createSession:");
            sess = new PersistenceSession();
            GroupingDAO dao = new GroupingDAO(sess);
            Grouping grouping = new Grouping(taskInstance.getSid(), group.getName(), groupDefn.getSid(), groupDefn.getDefnContentSid(), outputDestination);
            ArrayList users = new ArrayList(group.getMembers().keySet());
            grouping.doGrouping(users);
            dao.insert(grouping);
            sess.flush();
            LearnerServiceDelegate.handleGroupingContent(taskInstance.getSid(), this.toContent(grouping, taskInstance.getLearningSessionId()));
        }
        catch (UserNotFoundException e) {
            e.printStackTrace();
            throw new ToolException(e);
        }
        catch (TaskInstanceNotFoundException e) {
            e.printStackTrace();
            throw new ToolException(e);
        }
        catch (ControllerException e) {
            e.printStackTrace();
            throw new ToolException(e);
        }
        finally {
            sess.close();
        }
    }

    public void updateGrouping(long userId, long taskInstanceId, long lsessionId) throws ToolException, SystemException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"updateGrouping");
            sess = new PersistenceSession();
            GroupingDAO dao = new GroupingDAO(sess);
            Grouping grouping = dao.find(taskInstanceId);
            grouping.getGrouper().doGrouping(grouping, grouping.getDefinition(), userId);
            dao.update(grouping);
            sess.flush();
            LearnerServiceDelegate.handleGroupingContent(taskInstanceId, this.toContent(grouping, lsessionId));
        }
        catch (ToolException e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw e;
        }
        catch (UserNotFoundException e) {
            e.printStackTrace();
            throw new ToolException(e);
        }
        catch (TaskInstanceNotFoundException e) {
            e.printStackTrace();
            throw new ToolException(e);
        }
        catch (ControllerException e) {
            e.printStackTrace();
            throw new ToolException(e);
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw new ToolException(e);
        }
        finally {
            sess.close();
        }
    }

    public Map getGroupingData(long userId, long taskInstanceId, long lsessionId) throws UserNotFoundException, SystemException, TaskInstanceNotFoundException {
        PersistenceSession sess = null;
        try {
            log.debug((Object)"getGroupingData");
            sess = new PersistenceSession();
            GroupingDAO dao = new GroupingDAO(sess);
            Grouping grouping = dao.find(taskInstanceId);
            HashMap cachedUsers = this.getCachedUserFromSession(lsessionId);
            HashMap<String, List> groups = new HashMap<String, List>();
            Iterator iter = grouping.getGroups();
            while (iter.hasNext()) {
                Group group = (Group)iter.next();
                List members = this.convertGroup(group, cachedUsers, lsessionId);
                groups.put(group.getName(), members);
            }
            HashMap<String, List> hashMap = groups;
            return hashMap;
        }
        catch (UserNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (SystemException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        catch (TaskInstanceNotFoundException e) {
            this.getSessionContext().setRollbackOnly();
            throw e;
        }
        finally {
            sess.close();
        }
    }

    private HashMap getCachedUserFromSession(long lsessionId) throws TaskInstanceNotFoundException {
        return LearningSession.getInstance().getLearningSessionUsers(String.valueOf(lsessionId));
    }

    private List convertGroup(Group group, HashMap cachedUsers, long lsessId) throws UserNotFoundException {
        ArrayList<UserNameData> users = new ArrayList<UserNameData>();
        Iterator iter = group.iterator();
        while (iter.hasNext()) {
            UserData user;
            Long userId = (Long)iter.next();
            UserData userData = user = cachedUsers != null ? (UserData)cachedUsers.get(userId) : null;
            if (user == null) {
                user = UserServiceDelegate.findCompleteUser(userId);
                LearningSession.getInstance().cacheLearningSessionUsers(String.valueOf(lsessId), user);
            }
            UserNameData userNameData = new UserNameData(user.getSid(), user.getLogin(), user.getFirstName(), user.getLastName());
            users.add(userNameData);
        }
        return users;
    }

    private GroupingContent toContent(Grouping grouping, long lsessionId) throws UserNotFoundException, TaskInstanceNotFoundException {
        GroupingContent content = new GroupingContent();
        content.setMainGroup(grouping.getMainGroupName());
        content.setGroupingId(grouping.getGroupingId());
        HashMap cachedUsers = this.getCachedUserFromSession(lsessionId);
        Iterator iter = grouping.getGroups();
        while (iter.hasNext()) {
            Group group = (Group)iter.next();
            GroupData data = new GroupData();
            data.setSid(group.getSid());
            data.setName(group.getName());
            List members = this.convertGroup(group, cachedUsers, lsessionId);
            HashMap<Long, UserNameData> memberMap = new HashMap<Long, UserNameData>();
            for (int i = 0; i < members.size(); ++i) {
                UserNameData user = (UserNameData)members.get(i);
                memberMap.put(new Long(user.getSid()), user);
            }
            data.setMembers(memberMap);
            content.addGroup(data);
        }
        return content;
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

