/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.controller.web;

import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.dto.ActivityData;
import com.webmcq.ld.controller.dto.LearningSessionData;
import com.webmcq.ld.controller.util.WDDXUtil;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.service.interfaces.LearnerService;
import com.webmcq.ld.service.interfaces.LearnerServiceUtil;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.WebUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LearnerAction
extends ToolAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$controller$web$LearnerAction == null ? (class$com$webmcq$ld$controller$web$LearnerAction = LearnerAction.class$("com.webmcq.ld.controller.web.LearnerAction")) : class$com$webmcq$ld$controller$web$LearnerAction));
    static /* synthetic */ Class class$com$webmcq$ld$controller$web$LearnerAction;

    public ActionForward getLearningSessions(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"getLearningSessions");
            long userId = UserServiceDelegate.findUserId(WebUtil.getUsername(req));
            long classId = 0L;
            if (req.getParameter("classId") != null) {
                classId = Long.parseLong(req.getParameter("classId"));
            }
            LearningSessionData[] data = LearnerServiceDelegate.getLearningSessions(userId, classId);
            String packet = WDDXUtil.createACKMessage("getLearningSessions", data);
            log.debug((Object)packet);
            res.getWriter().print(packet);
            this.initTaskAttributes(req);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getLearningSessions"));
            return null;
        }
        catch (UserNotFoundException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getLearningSessions"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward setOrganisation(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"setOrganisation");
            long sessionId = WebUtil.readLongParam(req, "sessionId");
            long orgId = WebUtil.readLongParam(req, "orgId");
            String username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            LearnerService service = LearnerServiceUtil.getHome().create();
            service.setOrganisation(userId, sessionId, orgId);
            service.remove();
            res.getWriter().print(WDDXUtil.createACKMessage("setOrganisation", sessionId));
            return null;
        }
        catch (Exception e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "setOrganisation"));
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward restartSequence(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        log.debug((Object)"restartSequence");
        String msg = WDDXUtil.createACK("restartsequence");
        res.getWriter().print(msg);
        log.debug((Object)("restartSequence response WDDX Packet : " + msg));
        return null;
    }

    public ActionForward resumeSequence(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"resumeSequence");
            int sessionId = WebUtil.readIntParam(req, "LearningSessionID");
            String username = WebUtil.getUsername(req);
            long userId = UserServiceDelegate.findUserId(username);
            this.cacheCurrentLearningSessionId(req, sessionId);
            LearnerService service = LearnerServiceUtil.getHome().create();
            DisplayTaskData displayTaskData = service.resume(userId, username, sessionId);
            service.remove();
            if (displayTaskData == null) {
                displayTaskData = new DisplayTaskData();
                displayTaskData.setMessageType(20);
            }
            String msg = WDDXUtil.createACK("resumesequence");
            res.getWriter().print(msg);
            log.debug((Object)("resumeSequence response WDDX Packet : " + msg));
            return this.displayTask(displayTaskData, mapping, form, req, res);
        }
        catch (UserNotFoundException e) {
            throw new ServletException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "resumesequence"));
            return null;
        }
        catch (ControllerException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "resumesequence"));
            return null;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward startSequence(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"startSequence");
            String username = WebUtil.getUsername(req);
            int sessionId = WebUtil.readIntParam(req, "LearningSessionID");
            this.cacheCurrentLearningSessionId(req, sessionId);
            DisplayTaskData displayTaskData = LearnerServiceDelegate.join(username, sessionId);
            String msg = WDDXUtil.createACK("startsequence");
            res.getWriter().print(msg);
            log.debug((Object)("startSequence response WDDX Packet : " + msg));
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "startsequence"));
            return null;
        }
        catch (ControllerException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "startsequence"));
            return null;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void cacheCurrentLearningSessionId(HttpServletRequest req, int sessionId) {
        HttpSession hsession = req.getSession();
        hsession.setAttribute("CurLearningSessionID", (Object)new Integer(sessionId));
    }

    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"view");
            long taskInstanceId = WebUtil.readIntParam(req, "taskInstanceId");
            String username = WebUtil.getUsername(req);
            ShwaaUserData user = UserServiceDelegate.find(username);
            LearnerService service = LearnerServiceUtil.getHome().create();
            DisplayTaskData displayTaskData = service.view(user, taskInstanceId);
            service.remove();
            this.initTaskAttributes(req);
            String msg = WDDXUtil.createMoveMessage("view", displayTaskData.getUrlA());
            log.debug((Object)msg);
            res.getWriter().print(msg);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "view"));
            return null;
        }
        catch (ControllerException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "view"));
            return null;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward exit(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"exit");
            int sessionId = WebUtil.readIntParam(req, "sessionId");
            String username = WebUtil.getUsername(req);
            ShwaaUserData user = UserServiceDelegate.find(username);
            LearnerService service = LearnerServiceUtil.getHome().create();
            service.exit(user, sessionId);
            service.remove();
            String msg = WDDXUtil.createACK("exit");
            log.debug((Object)msg);
            res.getWriter().print(msg);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "exit"));
            return null;
        }
        catch (ControllerException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "exit"));
            return null;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public ActionForward getProgress(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"getProgress");
            long learningSessionId = WebUtil.readIntParam(req, "LearningSessionID");
            String username = WebUtil.getUsername(req);
            long userid = UserServiceDelegate.findUserId(username);
            LearnerService service = LearnerServiceUtil.getHome().create();
            ActivityData[] data = service.getProgress(userid, learningSessionId);
            log.debug((Object)("data: " + data.length));
            service.remove();
            String msg = WDDXUtil.createACKMessage("getProgress", data);
            res.getWriter().print(msg);
            return null;
        }
        catch (IllegalArgumentException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getProgress"));
            return null;
        }
        catch (ControllerException e) {
            res.getWriter().print(WDDXUtil.createCriticalErrorMsg(e, "getProgress"));
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException((Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

