/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.chat.servlet;

import com.webmcq.ld.service.ConfigurationKeys;
import com.webmcq.ld.service.ConfigurationServiceDelegate;
import com.webmcq.ld.tool.chat.flashserver.ServerShell;
import com.webmcq.ld.tool.chat.servlet.ChatArchive;
import com.webmcq.ld.tool.chat.web.ChatGroupForm;
import java.io.IOException;
import javax.ejb.EJBException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class ChatServerServlet
extends HttpServlet {
    protected static final Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$chat$servlet$ChatServerServlet == null ? (class$com$webmcq$ld$tool$chat$servlet$ChatServerServlet = ChatServerServlet.class$("com.webmcq.ld.tool.chat.servlet.ChatServerServlet")) : class$com$webmcq$ld$tool$chat$servlet$ChatServerServlet));
    private final ChatServerServlet me = null;
    protected static final String COMMAND = "command";
    public static final String COMMAND_START = "start";
    public static final String COMMAND_STOP = "stop";
    public static final String COMMAND_RESTART = "restart";
    public static final String COMMAND_GET_GROUP_ARCHIVE = "GET_GROUP_ARCHIVE";
    protected static final String CHATGROUP = "chatgroup";
    protected static final String VIEW_JSP = "/tool/chat/view.jsp";
    protected static final String ERROR_JSP = "/tool/chat/error.jsp";
    protected static final String ERROR_ATTR = "error";
    private static final String ATTR_ARCHIVE = "archive";
    private static final String FORM_CHAT_GROUP = "ChatGroupForm";
    public ServerShell serverShell = null;
    protected static final int DEFAULT_PORT_NUMBER = 9800;
    private String hostName;
    private Integer portNumberInteger;
    private int portNumber;
    static /* synthetic */ Class class$com$webmcq$ld$tool$chat$servlet$ChatServerServlet;

    public void init(ServletConfig config) throws ServletException {
        log.debug((Object)"init");
        try {
            this.hostName = ConfigurationServiceDelegate.get(ConfigurationKeys.CHAT_SERVER_NAME);
            this.portNumberInteger = ConfigurationServiceDelegate.getAsInteger(ConfigurationKeys.CHAT_PORT_NUMBER);
            this.portNumber = this.portNumberInteger;
        }
        catch (EJBException e) {
            log.error((Object)"Exception thrown trying to get chat parameters ", (Throwable)e);
            this.hostName = null;
        }
        log.info((Object)("hostName: '" + this.hostName + "'"));
        log.info((Object)("portNumber: '" + this.portNumber + "'"));
        if (this.hostName == null) {
            throw new ServletException("Chat Server serverName not configured");
        }
        try {
            log.info((Object)"sending 'start' to chat ServerShell");
            this.serverShell = new ServerShell(this, this.hostName, this.portNumber);
            log.debug((Object)(" *** ServerShell= " + this.serverShell));
            this.serverShell.start();
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info((Object)"ChatServerServlet admin command interface...");
        String command = request.getParameter(COMMAND);
        if (command == null || "".equals(command.trim())) {
            command = (String)request.getAttribute(COMMAND);
        }
        HttpSession session = request.getSession(false);
        if (command == null || "".equals(command.trim())) {
            if (session != null) {
                command = (String)session.getAttribute(COMMAND);
            }
            if (command != null) {
                command = command.trim();
            }
        }
        log.debug((Object)("  command = " + command));
        if (COMMAND_GET_GROUP_ARCHIVE.equalsIgnoreCase(command)) {
            this.getGroupArchive(request, response);
        } else if (COMMAND_START.equalsIgnoreCase(command)) {
            if (this.serverShell != null) {
                this.serverShell.start();
            }
        } else if (COMMAND_STOP.equalsIgnoreCase(command)) {
            if (this.serverShell != null) {
                this.serverShell.stop();
            }
        } else if (COMMAND_RESTART.equalsIgnoreCase(command)) {
            if (this.serverShell != null) {
                this.serverShell.restart();
            }
        } else {
            RequestDispatcher dispatcher = null;
            String errorMsg = "unknown command";
            request.setAttribute(ERROR_ATTR, (Object)errorMsg);
            dispatcher = request.getRequestDispatcher(ERROR_JSP);
            if (dispatcher != null) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private void getGroupArchive(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        log.debug((Object)"  getGroupArchive");
        ChatGroupForm groupForm = null;
        groupForm = (ChatGroupForm)((Object)request.getAttribute(FORM_CHAT_GROUP));
        HttpSession session = null;
        if (groupForm == null) {
            session = request.getSession(false);
            if (session == null) {
                log.error((Object)"session is null");
                throw new ServletException("groupForm is null");
            }
            groupForm = (ChatGroupForm)((Object)session.getAttribute(FORM_CHAT_GROUP));
        }
        if (groupForm == null) {
            log.error((Object)"groupForm is null");
            throw new ServletException("groupForm is null");
        }
        String chatgroup = groupForm.getChatGroupId();
        if (chatgroup == null) {
            log.error((Object)"chatgroup is null");
            throw new ServletException("chatgroup is null");
        }
        if ("".equals(chatgroup.trim())) {
            log.error((Object)"chatgroup is empty");
            throw new ServletException("chatgroup is empty");
        }
        log.debug((Object)("  chatgroup = " + chatgroup));
        ChatArchive archive = this.serverShell.getChatRoomArchive(chatgroup);
        log.debug((Object)archive);
        session.setAttribute(ATTR_ARCHIVE, (Object)archive);
        RequestDispatcher dispatcher = null;
        dispatcher = request.getRequestDispatcher(VIEW_JSP);
        try {
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            log.error((Object)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)e);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void destroy() {
        log.info((Object)"ChatServerServlet shuttting down...");
        this.serverShell.stop();
        this.serverShell = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

