/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.jrnl;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.ToolNotFoundException;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.LearningSessionData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.controller.dto.UserNameData;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.service.interfaces.LearnerService;
import com.webmcq.ld.service.interfaces.LearnerServiceUtil;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.jrnl.JrnlEntryBean;
import com.webmcq.ld.tool.jrnl.JrnlException;
import com.webmcq.ld.tool.jrnl.interfaces.JrnlEntryData;
import com.webmcq.ld.tool.jrnl.interfaces.JrnlEntryLocal;
import com.webmcq.ld.tool.jrnl.interfaces.JrnlEntryLocalHome;
import com.webmcq.ld.tool.jrnl.interfaces.JrnlEntryPK;
import com.webmcq.ld.tool.jrnl.interfaces.JrnlEntryUtil;
import com.webmcq.ld.tool.jrnl.interfaces.JrnlTaskBoilerplateLocal;
import com.webmcq.ld.tool.jrnl.interfaces.JrnlTaskBoilerplateLocalHome;
import com.webmcq.ld.tool.jrnl.interfaces.JrnlTaskBoilerplateUtil;
import com.webmcq.ld.usermanagement.interfaces.ShwaaUserData;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.EJBUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class JrnlServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$jrnl$JrnlServiceBean == null ? (class$com$webmcq$ld$tool$jrnl$JrnlServiceBean = JrnlServiceBean.class$("com.webmcq.ld.tool.jrnl.JrnlServiceBean")) : class$com$webmcq$ld$tool$jrnl$JrnlServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$tool$jrnl$JrnlServiceBean;

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            Content content = null;
            if (inputContentId != null) {
                content = ContentServiceDelegate.getContent(inputContentId);
            }
            this.createSession((SimpleTaskVO)task, taskInstance, outputContentId, content);
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ToolException(e);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw new SystemException(e);
        }
    }

    private void createSession(SimpleTaskVO task, TaskInstanceData instance, Long outputContentId, Content content) throws EJBException {
        try {
            Collection entries = JrnlTaskBoilerplateUtil.getLocalHome().findByTaskInstanceId((int)instance.getSid());
            JrnlTaskBoilerplateLocal entry = (JrnlTaskBoilerplateLocal)EJBUtil.findSingle(entries);
            if (entry != null) {
                log.warn((Object)("Boilerplate for task instance " + instance.toString() + " already exists. Not creating new boilerplate text."));
            } else {
                entry = content != null ? JrnlTaskBoilerplateUtil.getLocalHome().create(instance.getSid(), content.getTitle(), content.getBody(), outputContentId) : JrnlTaskBoilerplateUtil.getLocalHome().create(instance.getSid(), "No title", "", outputContentId);
            }
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public DisplayTaskData completeSession(long userId, long sessionId) throws JrnlException, EJBException {
        try {
            DisplayTaskData displayTaskData = null;
            Collection entries = JrnlEntryUtil.getLocalHome().findByUserIdTaskInstanceId(userId, sessionId);
            JrnlEntryLocal entry = (JrnlEntryLocal)EJBUtil.findSingle(entries);
            if (entry == null) {
                log.error((Object)("No journal entry found but user is trying to complete. userId=" + userId + " taskInstanceId=" + sessionId));
                throw new JrnlException("No journal entry found");
            }
            displayTaskData = LearnerServiceDelegate.moveToNextTask(sessionId, userId);
            return displayTaskData;
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException(e);
        }
    }

    public JrnlEntryData getEntryBySid(long entrySid) throws EJBException {
        try {
            JrnlEntryPK pk = new JrnlEntryPK(entrySid);
            JrnlEntryLocal entry = JrnlEntryUtil.getLocalHome().findByPrimaryKey(pk);
            if (entry != null) {
                return entry.getData();
            }
            return null;
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException(e);
        }
    }

    public JrnlEntryData getEntryByUserTask(long userId, long taskInstanceId) throws EJBException {
        try {
            Collection entries = JrnlEntryUtil.getLocalHome().findByUserIdTaskInstanceId(userId, taskInstanceId);
            JrnlEntryLocal entry = (JrnlEntryLocal)EJBUtil.findSingle(entries);
            if (entry != null) {
                return entry.getData();
            }
            return null;
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException(e);
        }
    }

    public SortedSet getEntriesByUser(long userId, Long sequenceId, String scope) throws EJBException {
        if (sequenceId != null) {
            this.updateSequenceIds(null, sequenceId);
        }
        try {
            HashSet allEntries = new HashSet();
            if (sequenceId == null) {
                Collection entries = JrnlEntryUtil.getLocalHome().findByUserId(userId);
                if (entries != null) {
                    allEntries.addAll(entries);
                }
            } else {
                Collection entries = JrnlEntryUtil.getLocalHome().findByUserIdSequenceId(userId, sequenceId);
                if (entries != null) {
                    allEntries.addAll(entries);
                }
                log.debug((Object)("getEntriesByUser: After finding by sequence number, the entries are:" + ((Object)allEntries).toString()));
                LearnerService service = LearnerServiceUtil.getHome().create();
                TaskInstanceData[] taskInstances = service.getJournalTasks(sequenceId);
                for (int i = 0; i < taskInstances.length; ++i) {
                    TaskInstanceData taskInstanceData = taskInstances[i];
                    log.debug((Object)("Found task " + taskInstanceData.toString()));
                    entries = JrnlEntryUtil.getLocalHome().findByUserIdTaskInstanceId(userId, taskInstanceData.getSid());
                    if (entries == null) continue;
                    allEntries.addAll(entries);
                }
                log.debug((Object)("After finding task entries, the entries are:" + ((Object)allEntries).toString()));
            }
            return this.convertToDataAndScope(allEntries, scope);
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException(e);
        }
    }

    public SortedSet getLearners(Long sequenceId, String scope) throws EJBException {
        if (sequenceId != null) {
            this.updateSequenceIds(null, sequenceId);
        }
        log.debug((Object)("Looking for entries for sequence id " + sequenceId + " scope " + scope));
        try {
            HashMap<Long, UserNameData> users = new HashMap<Long, UserNameData>();
            Collection entries = JrnlEntryUtil.getLocalHome().findBySequenceId(sequenceId);
            if (entries != null) {
                Iterator iter = entries.iterator();
                while (iter.hasNext()) {
                    Long userId;
                    JrnlEntryLocal entry = (JrnlEntryLocal)iter.next();
                    if (!entry.inScope(scope) || users.containsKey(userId = new Long(entry.getUserId()))) continue;
                    ShwaaUserData user = UserServiceDelegate.find(userId);
                    UserNameData userData = new UserNameData(user.getUid(), user.getLogin(), user.getFirstName(), user.getLastName());
                    users.put(userId, userData);
                }
            }
            TreeSet output = new TreeSet(new UsernameComparator());
            output.addAll(users.values());
            log.debug((Object)("returning " + ((Object)output).toString()));
            return output;
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException(e);
        }
    }

    public TreeMap getAllJournalEntries(Long sequenceId) {
        SortedSet set = this.getLearners(sequenceId, JrnlEntryBean.SCOPE_TEACHER);
        TreeMap<UserNameData, SortedSet> map = new TreeMap<UserNameData, SortedSet>(new UsernameComparator());
        Iterator iterator = set.iterator();
        SortedSet entries = null;
        while (iterator.hasNext()) {
            UserNameData userNameData = (UserNameData)iterator.next();
            entries = this.getEntriesByUser(userNameData.getSid(), sequenceId, JrnlEntryBean.SCOPE_TEACHER);
            map.put(userNameData, entries);
        }
        return map;
    }

    private SortedSet convertToDataAndScope(Collection entries, String scope) {
        String knownScope;
        TreeSet<JrnlEntryData> values = new TreeSet<JrnlEntryData>(new JrnlEntryCreateDateComparator());
        String string = knownScope = scope == null ? JrnlEntryBean.SCOPE_TEACHER : scope;
        if (entries != null) {
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                JrnlEntryLocal entry = (JrnlEntryLocal)iter.next();
                if (!entry.inScope(knownScope)) continue;
                values.add(entry.getData());
            }
        }
        return values;
    }

    public SortedMap getSequencesByUser(long userId, String scope) throws EJBException {
        try {
            LearnerService service = LearnerServiceUtil.getHome().create();
            LearningSessionData[] lsData = service.getLearningSessions(userId);
            TreeMap<Long, LearningSessionData> sequenceMap = new TreeMap<Long, LearningSessionData>();
            for (int i = 0; i < lsData.length; ++i) {
                LearningSessionData learningSessionData = lsData[i];
                long sessionId = learningSessionData.getSid();
                this.updateSequenceIds(service, sessionId);
                Collection entries = null;
                try {
                    entries = JrnlEntryUtil.getLocalHome().findByUserIdSequenceId(userId, sessionId);
                }
                catch (FinderException e) {
                    // empty catch block
                }
                if (entries == null || entries.size() <= 0) continue;
                log.debug((Object)("Entries exist for sequence " + sessionId));
                sequenceMap.put(new Long(sessionId), learningSessionData);
            }
            log.debug((Object)("Returning map " + sequenceMap.toString()));
            return sequenceMap;
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (Exception e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException(e);
        }
    }

    public JrnlEntryData putEntry(Long sid, long userId, Long sequenceId, Long taskInstanceId, String title, String body, String scope) throws EJBException {
        JrnlEntryLocal entry = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding/Updating for entry sid" + sid + " user id" + userId + " taskInstanceId " + taskInstanceId + " sequenceId " + sequenceId));
        }
        try {
            if (sid != null) {
                JrnlEntryPK pk = new JrnlEntryPK(sid);
                try {
                    entry = JrnlEntryUtil.getLocalHome().findByPrimaryKey(pk);
                }
                catch (FinderException e) {}
            } else if (taskInstanceId != null) {
                try {
                    Collection entries = JrnlEntryUtil.getLocalHome().findByUserIdTaskInstanceId(userId, taskInstanceId);
                    if (entries.size() > 1) {
                        log.warn((Object)("putEntry: There is more than one journal entry for task " + taskInstanceId + " user " + userId + ". The wrong entry may be updated."));
                    }
                    entry = (JrnlEntryLocal)EJBUtil.findSingle(entries);
                }
                catch (FinderException e) {
                    // empty catch block
                }
            }
            boolean editable = true;
            if (scope != null && scope.equals(JrnlEntryBean.SCOPE_TEACHER)) {
                editable = false;
            }
            if (entry != null) {
                log.debug((Object)("Updating entry, editable is " + editable));
                entry.update(title, body, scope, editable);
            } else {
                log.debug((Object)"Creating new entry");
                JrnlEntryLocalHome localHome = JrnlEntryUtil.getLocalHome();
                entry = localHome.create(userId, sequenceId, taskInstanceId, title, body, scope, editable);
            }
            log.debug((Object)("Entry now is " + (entry != null ? entry.toString() : "null")));
            return entry.getData();
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
    }

    public JrnlEntryData createNewTaskEntry(long userId, long taskInstanceId) throws EJBException {
        JrnlEntryLocal entry = null;
        try {
            Collection entries = JrnlTaskBoilerplateUtil.getLocalHome().findByTaskInstanceId(taskInstanceId);
            JrnlTaskBoilerplateLocal boilerplate = (JrnlTaskBoilerplateLocal)EJBUtil.findSingle(entries);
            JrnlEntryLocalHome localHome = JrnlEntryUtil.getLocalHome();
            if (boilerplate != null) {
                entry = localHome.create(userId, null, new Long(taskInstanceId), boilerplate.getTitle(), boilerplate.getBody(), JrnlEntryBean.SCOPE_TEACHER, true);
            } else {
                log.warn((Object)("Boilerplate text for Journal Task " + taskInstanceId + " is missing."));
                entry = localHome.create(userId, null, new Long(taskInstanceId), "No Title", "", JrnlEntryBean.SCOPE_TEACHER, true);
            }
            return entry.getData();
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            return null;
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
    }

    private void updateSequenceIds(LearnerService inputService, long sequenceId) {
        try {
            LearnerService service = inputService != null ? inputService : LearnerServiceUtil.getHome().create();
            log.debug((Object)("Updating entries for sequence " + sequenceId));
            TaskInstanceData[] taskInstances = service.getJournalTasks(sequenceId);
            for (int i = 0; i < taskInstances.length; ++i) {
                TaskInstanceData taskInstanceData = taskInstances[i];
                log.debug((Object)("Found task " + taskInstanceData.toString()));
                try {
                    Collection entries = JrnlEntryUtil.getLocalHome().findByTaskInstanceIdSequenceIdNull(taskInstanceData.getSid());
                    if (entries == null || entries.size() <= 0) continue;
                    Iterator iter = entries.iterator();
                    while (iter.hasNext()) {
                        JrnlEntryLocal entry = (JrnlEntryLocal)iter.next();
                        entry.setSequenceId(new Long(sequenceId));
                    }
                    continue;
                }
                catch (FinderException e) {
                    // empty catch block
                }
            }
        }
        catch (ToolNotFoundException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (RemoteException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            log.error((Object)"Exception occured ", (Throwable)e);
            throw new EJBException((Exception)e);
        }
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            this.deleteBolierPlateEntries(taskInstance);
            JrnlTaskBoilerplateLocalHome localHome = JrnlTaskBoilerplateUtil.getLocalHome();
            Collection collection = localHome.findByTaskInstanceId(taskInstance.getSid());
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                JrnlTaskBoilerplateLocal local = (JrnlTaskBoilerplateLocal)iter.next();
                local.remove();
            }
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public void deleteBolierPlateEntries(TaskInstance taskInstance) {
        try {
            JrnlEntryLocalHome localHome = JrnlEntryUtil.getLocalHome();
            Collection collection = localHome.findBySequenceId(taskInstance.getLearningSession().getSid());
            this.deleteCollection(collection);
            collection = localHome.findByTaskInstanceId(taskInstance.getSid());
            this.deleteCollection(collection);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    private void deleteCollection(Collection collection) {
        try {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                JrnlEntryLocal local = (JrnlEntryLocal)iter.next();
                local.remove();
            }
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class UsernameComparator
    implements Comparator {
        UsernameComparator() {
        }

        public int compare(Object o1, Object o2) throws ClassCastException {
            UserNameData data1 = (UserNameData)o1;
            UserNameData data2 = (UserNameData)o2;
            Integer nullCompareValue = this.nullCompare(o1, o2);
            if (nullCompareValue != null) {
                return nullCompareValue;
            }
            if (data1.getLastName().compareTo(data2.getLastName()) == 0) {
                return (int)(data1.getSid() - data2.getSid());
            }
            return data1.getLastName().compareTo(data2.getLastName());
        }

        protected Integer nullCompare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return new Integer(0);
            }
            if (o1 == null && o2 != null) {
                return new Integer(-1);
            }
            if (o1 != null && o2 == null) {
                return new Integer(1);
            }
            return null;
        }
    }

    class JrnlEntryCreateDateComparator
    implements Comparator {
        JrnlEntryCreateDateComparator() {
        }

        public int compare(Object o1, Object o2) throws ClassCastException {
            Integer nullCompareValue = this.nullCompare(o1, o2);
            if (nullCompareValue != null) {
                return nullCompareValue;
            }
            JrnlEntryData entry1 = (JrnlEntryData)o1;
            JrnlEntryData entry2 = (JrnlEntryData)o2;
            if (entry1.getCreateDate().before(entry2.getCreateDate())) {
                return -1;
            }
            if (entry1.getCreateDate().after(entry2.getCreateDate())) {
                return 1;
            }
            return this.longCompare(entry1.getSid(), entry2.getSid());
        }

        protected int longCompare(long sid1, long sid2) {
            if (sid1 < sid2) {
                return -1;
            }
            if (sid1 == sid2) {
                return 0;
            }
            return 1;
        }

        protected Integer nullCompare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return new Integer(0);
            }
            if (o1 == null && o2 != null) {
                return new Integer(-1);
            }
            if (o1 != null && o2 == null) {
                return new Integer(1);
            }
            return null;
        }
    }
}

