/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.qna;

import com.webmcq.ld.activities.AbstractTaskVO;
import com.webmcq.ld.activities.SimpleTaskVO;
import com.webmcq.ld.content.Content;
import com.webmcq.ld.content.interfaces.ContentRepositoryLocal;
import com.webmcq.ld.content.interfaces.ContentRepositoryUtil;
import com.webmcq.ld.controller.ControllerException;
import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.TaskInstance;
import com.webmcq.ld.controller.dao.TaskInstanceNotFoundException;
import com.webmcq.ld.controller.dto.GroupData;
import com.webmcq.ld.controller.dto.TaskInstanceData;
import com.webmcq.ld.service.ContentServiceDelegate;
import com.webmcq.ld.service.LearnerServiceDelegate;
import com.webmcq.ld.tool.StaffMonitorNotifier;
import com.webmcq.ld.tool.ToolException;
import com.webmcq.ld.tool.qna.QNAException;
import com.webmcq.ld.tool.qna.dto.QNADTOFactory;
import com.webmcq.ld.tool.qna.dto.QuestionAnswerData;
import com.webmcq.ld.tool.qna.interfaces.SimpleAnswerLocal;
import com.webmcq.ld.tool.qna.interfaces.SimpleAnswerUtil;
import com.webmcq.ld.tool.qna.interfaces.SimpleQuestionData;
import com.webmcq.ld.tool.qna.interfaces.SimpleQuestionLocal;
import com.webmcq.ld.tool.qna.interfaces.SimpleQuestionPK;
import com.webmcq.ld.tool.qna.interfaces.SimpleQuestionUtil;
import com.webmcq.ld.util.BaseSessionBean;
import com.webmcq.ld.util.EJBUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public abstract class QNAServiceBean
extends BaseSessionBean {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$qna$QNAServiceBean == null ? (class$com$webmcq$ld$tool$qna$QNAServiceBean = QNAServiceBean.class$("com.webmcq.ld.tool.qna.QNAServiceBean")) : class$com$webmcq$ld$tool$qna$QNAServiceBean));
    static /* synthetic */ Class class$com$webmcq$ld$tool$qna$QNAServiceBean;

    public void createSession(AbstractTaskVO task, TaskInstanceData taskInstance, GroupData group, String outputContentDestination, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
        try {
            SimpleTaskVO simpleTask = (SimpleTaskVO)task;
            this.createSession(simpleTask, taskInstance, outputContentId);
            if (inputContentId != null) {
                Content content = ContentServiceDelegate.getContent(inputContentId);
                this.setContent((int)taskInstance.getSid(), content);
            }
            this.notifyVotesReceived(taskInstance.getSid(), simpleTask.getTitle());
        }
        catch (ControllerException e) {
            this.getSessionContext().setRollbackOnly();
            throw new ToolException(e);
        }
        catch (Exception e) {
            this.getSessionContext().setRollbackOnly();
            e.printStackTrace();
            throw new SystemException(e);
        }
    }

    private void createSession(SimpleTaskVO task, TaskInstanceData instance, Long outputContentId) {
        try {
            log.debug((Object)"createSession");
            SimpleQuestionLocal question = SimpleQuestionUtil.getLocalHome().create(task.getTitle());
            question.setSessionId(instance.getSid());
            question.setContentId(outputContentId);
            log.debug((Object)("session created with session id '" + question.getSessionId() + "'"));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public DisplayTaskData completeSession(long userId, int sessionId) throws QNAException {
        try {
            DisplayTaskData displayTaskData = null;
            Collection entries = SimpleQuestionUtil.getLocalHome().findBySessionId(sessionId);
            SimpleQuestionLocal entry = (SimpleQuestionLocal)EJBUtil.findSingle(entries);
            if (entry == null) {
                throw new QNAException("no such session found");
            }
            displayTaskData = LearnerServiceDelegate.moveToNextTask(sessionId, userId);
            return displayTaskData;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (TaskInstanceNotFoundException e) {
            throw new EJBException((Exception)e);
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
        catch (SystemException e) {
            throw e;
        }
    }

    public SimpleQuestionData getEntryBySession(int sessionId) {
        try {
            Collection entries = SimpleQuestionUtil.getLocalHome().findBySessionId(sessionId);
            SimpleQuestionLocal entry = (SimpleQuestionLocal)EJBUtil.findSingle(entries);
            if (entry != null) {
                return entry.getData();
            }
            return null;
        }
        catch (FinderException e) {
            return null;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
    }

    public QuestionAnswerData[] getAnswer(long userId, String username, int sessionId) throws QNAException {
        try {
            Collection entries = SimpleQuestionUtil.getLocalHome().findBySessionId(sessionId);
            if (entries == null) {
                throw new QNAException("no such session found");
            }
            QuestionAnswerData[] qaData = new QuestionAnswerData[entries.size()];
            Iterator itr = entries.iterator();
            int i = 0;
            while (itr.hasNext()) {
                QuestionAnswerData data;
                SimpleQuestionLocal entry = (SimpleQuestionLocal)itr.next();
                Collection answers = SimpleAnswerUtil.getLocalHome().findByUserAndQuestionId(userId, sessionId, entry.getSid());
                SimpleAnswerLocal answer = (SimpleAnswerLocal)EJBUtil.findSingle(answers);
                qaData[i] = data = QNADTOFactory.getSingleQAData(userId, username, entry, answer);
                ++i;
            }
            return qaData;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public QuestionAnswerData[] getAllAnswers(int sessionId) throws QNAException {
        try {
            Collection entries = SimpleQuestionUtil.getLocalHome().findBySessionId(sessionId);
            if (entries == null) {
                throw new QNAException("no such session found");
            }
            QuestionAnswerData[] qaData = new QuestionAnswerData[entries.size()];
            Iterator itr = entries.iterator();
            int i = 0;
            while (itr.hasNext()) {
                QuestionAnswerData data;
                SimpleQuestionLocal entry = (SimpleQuestionLocal)itr.next();
                Collection answers = SimpleAnswerUtil.getLocalHome().findByQuestionId(sessionId, entry.getSid());
                qaData[i] = data = QNADTOFactory.getAllQAData(entry, answers);
                ++i;
            }
            return qaData;
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void setAnswer(String userName, long userId, int sessionId, String content, int questionId) throws QNAException {
        try {
            SimpleQuestionPK pk = new SimpleQuestionPK(questionId);
            SimpleQuestionLocal entry = SimpleQuestionUtil.getLocalHome().findByPrimaryKey(pk);
            if (entry == null) {
                throw new QNAException("no such session found");
            }
            if (entry.getShowUser() != null && entry.getShowUser().booleanValue() && userName != null && userName != "") {
                content = "(" + userName + ") " + content;
            }
            SimpleAnswerLocal answer = SimpleAnswerUtil.getLocalHome().create();
            answer.setContent(content);
            answer.setQuestion(entry);
            answer.setUserId(userId);
            this.sendContent(answer);
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void insertQuestion(int sessionId, String newQuestionTitle, String newQuestionContent) throws QNAException {
        log.debug((Object)"insertQuestion : INSERT A NEW QUESTION ");
        try {
            Collection entries = SimpleQuestionUtil.getLocalHome().findBySessionId(sessionId);
            SimpleQuestionLocal entry = (SimpleQuestionLocal)EJBUtil.findSingle(entries);
            if (entry == null) {
                throw new QNAException("no such session found");
            }
            SimpleQuestionLocal question = SimpleQuestionUtil.getLocalHome().create(newQuestionTitle);
            question.setSessionId(sessionId);
            question.setContent(newQuestionContent);
            question.setContentId(entry.getContentId());
            question.setShowUser(entry.getShowUser());
            question.setDefineLater(new Boolean(false));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    public void updateQuestion(int questionId, String questionTitle, String questionContent) throws QNAException {
        log.debug((Object)"updateQuestion : UPDATE AN EXISTING QUESTION ");
        try {
            SimpleQuestionPK pk = new SimpleQuestionPK(questionId);
            SimpleQuestionLocal question = SimpleQuestionUtil.getLocalHome().findByPrimaryKey(pk);
            if (question == null) {
                throw new QNAException("no such session found");
            }
            question.setTitle(questionTitle);
            question.setContent(questionContent);
            question.setDefineLater(new Boolean(false));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private void sendContent(SimpleAnswerLocal answer) {
        try {
            Long contentId = answer.getQuestion().getContentId();
            if (contentId != null) {
                ContentRepositoryLocal repo = ContentRepositoryUtil.getLocalHome().create();
                Content content = this.answerToContent(answer);
                repo.setContent(contentId, content);
            }
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
    }

    private Content answerToContent(SimpleAnswerLocal answer) {
        Content content = new Content(new Date());
        content.setBody(answer.getContent());
        return content;
    }

    private void setContent(int sessionId, Content content) {
        try {
            Collection coll = SimpleQuestionUtil.getLocalHome().findBySessionId(sessionId);
            SimpleQuestionLocal question = (SimpleQuestionLocal)EJBUtil.findSingle(coll);
            if (question == null) {
                log.warn((Object)("setContent: no question found '" + sessionId + "'"));
            } else {
                question.setTitle(content.getTitle());
                question.setContent(content.getBody());
                question.setShowUser(content.isShowUser());
                question.setDefineLater(content.isDefineLater());
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new EJBException((Exception)e);
        }
        catch (FinderException e) {
            e.printStackTrace();
            throw new EJBException((Exception)((Object)e));
        }
    }

    private void notifyVotesReceived(long taskInstanceId, String title) {
        try {
            String toolpath = "/tool/qna/qna.do?method=getAllAnswers&sessionId=" + taskInstanceId;
            StaffMonitorNotifier.notifyControllerOfURL(taskInstanceId, "qa", title, toolpath);
        }
        catch (ControllerException e) {
            throw new EJBException((Exception)e);
        }
    }

    public void deleteSession(TaskInstance taskInstance, Long inputContentId, Long outputContentId) throws ToolException, SystemException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

