/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.tool.survey.web;

import com.webmcq.ld.controller.DisplayTaskData;
import com.webmcq.ld.controller.web.ToolAction;
import com.webmcq.ld.service.UserNotFoundException;
import com.webmcq.ld.service.UserServiceDelegate;
import com.webmcq.ld.tool.survey.ISurveyService;
import com.webmcq.ld.tool.survey.SurveyManager;
import com.webmcq.ld.tool.survey.web.QuestionnaireForm;
import com.webmcq.ld.util.WebUtil;
import com.webmcq.ld.util.exception.SystemException;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SurveyAction
extends ToolAction {
    private static Logger log = Logger.getLogger((Class)(class$com$webmcq$ld$tool$survey$web$SurveyAction == null ? (class$com$webmcq$ld$tool$survey$web$SurveyAction = SurveyAction.class$("com.webmcq.ld.tool.survey.web.SurveyAction")) : class$com$webmcq$ld$tool$survey$web$SurveyAction));
    private static final String LOAD_QUESTIONNAIRE = "load";
    private static final String SUBMIT_QUESTIONNAIRE = "submit";
    private static final String VIEW_INDIVIDUAL_SUMMARY = "view";
    private static final String PARAM_USERID = "userId";
    private static final String PARAM_MODE = "mode";
    private static final String ATTR_MODE = "mode";
    private static final String ATTR_VIEW_ONLY = "viewOnly";
    private static final String ATTR_USERNAME = "username";
    private static final boolean OPTIONAL = true;
    static /* synthetic */ Class class$com$webmcq$ld$tool$survey$web$SurveyAction;

    public ActionForward loadQuestionnaire(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireForm questionnaireForm = (QuestionnaireForm)form;
        String mode = WebUtil.readStrParam(request, "mode", true);
        ISurveyService surveyService = SurveyManager.getSurveyService(request);
        String login = request.getRemoteUser();
        if (mode != null && (mode.equals(VIEW_INDIVIDUAL_SUMMARY) || mode.equals("checkup"))) {
            request.setAttribute(ATTR_VIEW_ONLY, (Object)"true");
            request.setAttribute("mode", (Object)mode);
            if (mode.equals("checkup")) {
                login = UserServiceDelegate.find(WebUtil.readIntParam(request, PARAM_USERID)).getLogin();
            }
        }
        request.setAttribute(ATTR_USERNAME, (Object)login);
        if (questionnaireForm == null) {
            log.error((Object)"Fail to pre-load the questionnaire form.");
            throw new SystemException("Fail to pre-load the questionnaire form.");
        }
        long taskinstanceId = (Long)questionnaireForm.get("sessionId");
        questionnaireForm.buildQuestionnaireForm(login, surveyService.retrieveSurvey(taskinstanceId));
        request.setAttribute("QuestionnaireForm", (Object)questionnaireForm);
        if (request.getAttribute(ATTR_VIEW_ONLY) != null) {
            return mapping.findForward(VIEW_INDIVIDUAL_SUMMARY);
        }
        WebUtil.saveToken(request, "transactionKeySurvey", this.generateToken(request));
        return mapping.findForward(LOAD_QUESTIONNAIRE);
    }

    public ActionForward submitQuestionnaire(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        QuestionnaireForm questionnaireForm = (QuestionnaireForm)form;
        if (this.isCancelled(request)) {
            questionnaireForm.resetSurveyQuestions();
            WebUtil.saveToken(request, "transactionKeySurvey", this.generateToken(request));
            return mapping.findForward(LOAD_QUESTIONNAIRE);
        }
        if (!WebUtil.isTokenValid(request, "transactionKeySurvey")) {
            return this.duplicateSubmission(mapping, request, "transactionDoneSurvey");
        }
        List userResponses = questionnaireForm.buildUserResponseVO(request);
        ISurveyService surveyService = SurveyManager.getSurveyService(request);
        String login = request.getRemoteUser();
        request.setAttribute(ATTR_USERNAME, (Object)login);
        request.setAttribute("mode", (Object)"resume");
        surveyService.saveUserResponses(userResponses, (Long)questionnaireForm.get("sessionId"), UserServiceDelegate.findCompleteUser(login));
        WebUtil.saveToken(request, "transactionKeySurvey", this.generateToken(request));
        return mapping.findForward(SUBMIT_QUESTIONNAIRE);
    }

    public ActionForward completeSession(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ISurveyService surveyService = SurveyManager.getSurveyService(request);
        QuestionnaireForm qForm = (QuestionnaireForm)form;
        if (this.isCancelled(request)) {
            return mapping.getInputForward();
        }
        try {
            if (WebUtil.isTokenValid(request, "transactionKeySurvey")) {
                DisplayTaskData displayTaskData = surveyService.completeSession(UserServiceDelegate.findUserId(WebUtil.getUsername(request)), (Long)qForm.get("sessionId"));
                return this.displayTask(displayTaskData, mapping, (ActionForm)qForm, request, response);
            }
            return this.duplicateSubmission(mapping, request, "transactionDoneSurvey");
        }
        catch (UserNotFoundException e) {
            throw new SystemException("UserNotFoundException occured in completeSession of survey tool", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

