/*
 * Decompiled with CFR 0.152.
 */
package com.webmcq.ld.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class CSVFile {
    private Writer writer = null;

    public CSVFile(String fileName) throws IOException {
        this.setupWriter(fileName, false);
    }

    public CSVFile(String fileName, boolean append) throws IOException {
        this.setupWriter(fileName, append);
    }

    private void setupWriter(String fileName, boolean append) throws IOException {
        this.writer = new FileWriter(fileName, append);
    }

    public CSVFile(File file) throws IOException {
        this.setupWriter(file, false);
    }

    public CSVFile(File file, boolean append) throws IOException {
        this.setupWriter(file, append);
    }

    private void setupWriter(File file, boolean append) throws IOException {
        this.writer = new FileWriter(file, append);
    }

    public CSVFile(FileDescriptor fd) {
        this.writer = new FileWriter(fd);
    }

    public CSVFile(Writer writer) {
        this.writer = writer;
    }

    public void write(String[] values) throws IOException {
        for (int i = 0; i < values.length; ++i) {
            String string = this.escapeForCSV(values[i]);
            this.writer.write(string);
            if (i >= values.length - 1) continue;
            this.writer.write(44);
        }
        this.writer.write("\n");
        this.writer.flush();
    }

    private String escapeForCSV(String input) {
        if (input == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(input.length() * 2);
        buf.append('\"');
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"') {
                buf.append("\"\"");
                continue;
            }
            if (c == '\n' || c == '\r') {
                buf.append('\n');
                if (i + 1 >= input.length() || input.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            buf.append(c);
        }
        buf.append('\"');
        return buf.toString();
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

